//
//  GroovyAdditions.java
//  WOGroovy
//

package wogroovy.additions;

import com.webobjects.foundation.*;
import com.webobjects.eocontrol.*;
import java.util.*;
import java.net.*;
import er.extensions.*;

public class GroovyAdditions {

    //
    // instance creation
    //
    
    public static NSArray arrayValue(List self) {
        return new NSArray(self.toArray());
    }
    
    public static NSMutableArray mutableArrayValue(List self) {
        return new NSMutableArray(self.toArray());
    }
    
    public static NSDictionary dictionaryValue(Map self) {
        return new NSDictionary(self.values().toArray(), self.keySet().toArray());
    }
    
    public static NSMutableDictionary mutableDictionaryValue(Map self) {
        return new NSMutableDictionary(self.values().toArray(), self.keySet().toArray());
    }
    
    public static NSArray arrayValue(Object self) {
        return ERXValueUtilities.arrayValue(self);
    }

    public static NSArray arrayValueWithDefault(Object self,  NSArray def) {
        return ERXValueUtilities.arrayValueWithDefault(self, def);
    }

    public static boolean booleanValue(Object self) {
        return ERXValueUtilities.booleanValue(self);
    }

    public static boolean booleanValueWithDefault(Object self,  boolean def) {
        return ERXValueUtilities.booleanValueWithDefault(self, def);
    }

    public static NSDictionary dictionaryValue(Object self) {
        return ERXValueUtilities.dictionaryValue(self);
    }

    public static NSDictionary dictionaryValueWithDefault(Object self,
                                                          NSDictionary def) {
        return ERXValueUtilities.dictionaryValueWithDefault(self, def);
    }

    public static int intValue(Object self) {
        return ERXValueUtilities.intValue(self);
    }

    public static int intValueWithDefault(Object self, int def) {
        return ERXValueUtilities.intValueWithDefault(self, def);
    }

    public static NSArray lastNMonthsArray(int self) {
        return ERXGraphUtilities.lastNMonthsArray(self);
    }

    public static NSArray lastNMonthsAsStringsArray(int self) {
        return ERXGraphUtilities.lastNMonthsAsStringsArray(self);
    }

    public static NSTimestamp unixDate(Number self) {
        return ERXTimestampUtilities.unixDate(self);
    }

    public static String stackTrace(Throwable self) {
        return ERXUtilities.stackTrace(self);
    }

    public static String localizedTemplateStringForKey(Object self,
                                                       String key,
                                                       String framework,
                                                       NSArray languages) {
        return ERXStringUtilities.localizedTemplateStringWithObjectForKey(self,
                                                                          key,
                                                                          framework,
                                                                          languages);
    }

    public static NSArray sortOrderings(Map self) {
        NSMutableArray orderings = new NSMutableArray();
        for (Iterator iter = self.keySet().iterator(); iter.hasNext();) {
            String key = iter.next().toString();
            NSSelector selector = (NSSelector)self.get(key);
            orderings.addObject(new EOSortOrdering(key, selector));
        }
        return orderings;
    }



    //
    // testing
    //

    public static boolean existsFiles(URL self) {
        return NSPathUtilities.fileExistsAtPathURL(self);
    }

}
