//
//  FileAdditions.java
//  WOGroovy
//

package wogroovy.additions;

import com.webobjects.foundation.*;
import com.webobjects.eocontrol.*;
import er.extensions.*;
import java.io.*;

public class FileAdditions {

    //
    // accessing
    //

    public static NSArray filesInDirectory(File self,
                                           boolean recursive) {
        return ERXFileUtilities.arrayByAddingFilesInDirectory(self, recursive);
    }

    public static byte[] bytes(File self) throws IOException {
        return ERXFileUtilities.bytesFromFile(self);
    }

    public static byte[] bytes(InputStream self) throws IOException {
        return ERXFileUtilities.bytesFromInputStream(self);
    }

    public static String string(File self) throws IOException {
        return ERXFileUtilities.stringFromFile(self);
    }

    public static String string(File self, String encoding) throws IOException {
        return ERXFileUtilities.stringFromFile(self, encoding);
    }

    public static String string(InputStream self) throws IOException {
        return ERXFileUtilities.stringFromInputStream(self);
    }

    public static String string(InputStream self, String encoding)
        throws IOException {
        return ERXFileUtilities.stringFromInputStream(self, encoding);
    }


    //
    // executing
    //

    public static void copyFiles(File self,
                                 File dstDirectory,
                                 boolean deleteOriginals,
                                 boolean recursiveCopy,
                                 FileFilter filter)
        throws IOException, FileNotFoundException {
        ERXFileUtilities.copyFilesFromDirectory(self,
                                                dstDirectory,
                                                deleteOriginals,
                                                recursiveCopy,
                                                filter);
    }

    public static boolean deleteDirectory(File self) {
        return ERXFileUtilities.deleteDirectory(self);
    }

    public static void deleteFiles(File self, boolean recurseIntoDirectories) {
        ERXFileUtilities.deleteFilesInDirectory(self, recurseIntoDirectories);
    }

    public static void linkFiles(File self,
                                 File destination,
                                 boolean symbolic,
                                 boolean allowUnlink,
                                 boolean doNotFollowSymbolicLinks)
        throws IOException {
        ERXFileUtilities.linkFiles(self, destination, symbolic, allowUnlink,
                                          doNotFollowSymbolicLinks);
    }

    public static File unzip(File self, File destination) throws IOException {
        return ERXFileUtilities.unzipFile(self, destination);
    }

    public static void writeToFile(InputStream self, File file) throws IOException {
        ERXFileUtilities.writeInputStreamToFile(file, self);
    }

}
