//
//  EOEnterpriseObjectAdditions.java
//  WOGroovy
//

package wogroovy.additions;

import com.webobjects.foundation.*;
import com.webobjects.eoaccess.*;
import com.webobjects.eocontrol.*;
import er.extensions.*;

public class EOEnterpriseObjectAdditions {

    //
    // accessing
    //

    public static Object getAt(EOEnterpriseObject self, Object key) {
        return self.valueForKey(key.toString());
    }
    
    public static void putAt(EOEnterpriseObject self, Object key, Object object) {
        self.takeValueForKey(object, key.toString());
    }

    public static void refault(EOEnterpriseObject self) {
        ERXEOControlUtilities.refaultObject(self);
    }

    public static void
        addObjectToObjectOnBothSidesOfRelationshipWithKey(EOEnterpriseObject self,
                                                          EOEnterpriseObject reference,
                                                          String key) {
        ERXEOControlUtilities.
            addObjectToObjectOnBothSidesOfRelationshipWithKey(self,
                                                              reference,
                                                              key);
    }

    public static EORelationship relationshipWithKeyPath(EOEnterpriseObject self,
                                                         String keyPath) {
        return ERXUtilities.relationshipWithObjectAndKeyPath(self, keyPath);
    }


    //
    // replicating
    //

    public static void deplicateRelationship(ERXGenericRecord self,
                                             String relationshipName) {
        ERXUtilities.deplicateRelationshipFromEO(self, relationshipName);
    }

    public static void replicateDataToEO(ERXGenericRecord self,
                                         ERXGenericRecord other,
                                         NSArray attributeNames) {
        ERXUtilities.replicateDataFromEOToEO(self, other, attributeNames);
    }

    public static void replicateRelationshipToEO(ERXGenericRecord self,
                                                 ERXGenericRecord other,
                                                 String relationshipName) {
        ERXUtilities.replicateRelationshipFromEOToEO(self, other, relationshipName);
    }


    //
    // encoding
    //

    public static String stringByEncodingPrimaryKeys(EOEnterpriseObject self,
                                                     String seperator,
                                                     boolean encrypt) {
        return ERXEOEncodingUtilities.
            encodeEnterpriseObjectPrimaryKeyForUrl(self, seperator, encrypt);
    }

    public static String encodedEntityName(EOEnterpriseObject self) {
        return ERXEOEncodingUtilities.entityNameEncode(self);
    }

}
