//
//  EOEditingContextAdditions.java
//  WOGroovy
//

package wogroovy.additions;

import com.webobjects.foundation.*;
import com.webobjects.eoaccess.*;
import com.webobjects.eocontrol.*;
import er.extensions.*;

public class EOEditingContextAdditions {

    //
    // connecting
    //

    public static void connectWithModelNamed(EOEditingContext self,
                                             String name,
                                             NSDictionary overrides) {
        EOUtilities.connectWithModelNamed(self, name, overrides);
    }


    //
    // instance creation
    //

    public static EOEnterpriseObject createAndInsertInstance(EOEditingContext self,
                                                             String entityName) {
        return EOUtilities.createAndInsertInstance(self, entityName);
    }

    public static NSDictionary primaryKeyForObject(EOEditingContext self,
                                                   EOEnterpriseObject object) {
        return EOUtilities.primaryKeyForObject(self, object);
    }

    public static EOQualifier qualifierForEnterpriseObject(EOEditingContext self,
                                                           EOEnterpriseObject object) {
        return EOUtilities.qualifierForEnterpriseObject(self, object);
    }

    public static Number getNextValFromSequenceNamed(EOEditingContext self,
                                                     String modelNamed,
                                                     String sequenceName) {
        return ERXEOAccessUtilities.getNextValFromSequenceNamed(self, modelNamed, sequenceName);
    }

    public static EOFetchSpecification
        primaryKeyFetchSpecificationForEntity(EOEditingContext self,
                                              String entityName,
                                              EOQualifier eoqualifier,
                                              NSArray sortOrderings,
                                              NSArray additionalKeys) {
        return
            ERXEOControlUtilities.primaryKeyFetchSpecificationForEntity(self,
                                                                     entityName,
                                                                     eoqualifier,
                                                                     sortOrderings,
                                                                     additionalKeys);
    }

    public static NSArray primaryKeysMatchingQualifier(EOEditingContext self,
                                                       String entityName,
                                                       EOQualifier eoqualifier,
                                                       NSArray sortOrderings) {
        return ERXEOControlUtilities.primaryKeysMatchingQualifier(self,
                                                               entityName,
                                                               eoqualifier,
                                                               sortOrderings);
    }

    public static EOEnterpriseObject createEO(EOEditingContext self,
                                              String entityName) {
        return ERXUtilities.createEO(entityName, self);
    }

    public static EOEnterpriseObject createEO(EOEditingContext self,
                                              String entityName,
                                              NSDictionary objectInfo) {
        return ERXUtilities.createEO(entityName, self, objectInfo);
    }

    public static EOEnterpriseObject createEOLinkedToEO(EOEditingContext self,
                                                        String entityName,
                                                        String relationshipName,
                                                        EOEnterpriseObject eo) {
        return ERXUtilities.createEOLinkedToEO(entityName, self, relationshipName, eo);
    }

    public static EOEnterpriseObject createEOLinkedToEO(EOEditingContext self,
                                                        String entityName,
                                                        String relationshipName,
                                                        EOEnterpriseObject eo,
                                                        NSDictionary objectInfo) {
        return ERXUtilities.createEOLinkedToEO(entityName, self,
                                               relationshipName, eo, objectInfo);
    }


    //
    // accessing
    //

    public static EODatabaseContext databaseContextForModelNamed(EOEditingContext self,
                                                                 String name) {
        return EOUtilities.databaseContextForModelNamed(self, name);
    }

    public static NSDictionary destinationKeyForSourceObject(EOEditingContext self,
                                                             EOEnterpriseObject object,
                                                             String name) {
        return EOUtilities.destinationKeyForSourceObject(self, object, name);
    }

    public static EOEntity entityForClass(EOEditingContext self, Class theClass) {
        return EOUtilities.entityForClass(self, theClass);
    }

    public static EOEntity entityForObject(EOEditingContext self,
                                           EOEnterpriseObject obj) {
        return EOUtilities.entityForObject(self, obj);
    }

    public static EOEntity entityNamed(EOEditingContext self, String name) {
        return EOUtilities.entityNamed(self, name);
    }

    public static EOEnterpriseObject faultWithPrimaryKey(EOEditingContext self,
                                                         String entityName,
                                                         NSDictionary pkDict) {
        return EOUtilities.faultWithPrimaryKey(self, entityName, pkDict);
    }

    public static EOEnterpriseObject faultWithPrimaryKeyValue(EOEditingContext self,
                                                              String entityName,
                                                              Object value) {
        return EOUtilities.faultWithPrimaryKeyValue(self, entityName, value);
    }

    public static EOEnterpriseObject localInstanceOfObject(EOEditingContext self,
                                                           EOEnterpriseObject object) {
        return EOUtilities.localInstanceOfObject(self, object);
    }

    public static NSArray localInstancesOfObjects(EOEditingContext self,
                                                  NSArray objects) {
        return EOUtilities.localInstancesOfObjects(self, objects);
    }

    public static EOModelGroup modelGroup(EOEditingContext self) {
        return EOUtilities.modelGroup(self);
    }

    public static Number objectCountWithQualifier(EOEditingContext self,
                                                  String entityName,
                                                  EOQualifier qualifier) {
        return ERXEOControlUtilities.objectCountWithQualifier(self, entityName,
                                                              qualifier);
    }


    public static NSArray deletedObjectsPKeys(EOEditingContext self) {
        return ERXUtilities.deletedObjectsPKeys(self);
    }

    public static NSDictionary primaryKeyDictionaryForEntity(EOEditingContext self,
                                                             String entityName) {
        return ERXUtilities.primaryKeyDictionaryForEntity(self, entityName);
    }


    //
    // evaluating
    //

    public static NSArray rawRowsForSQL(EOEditingContext self,
                                        String modelName,
                                        String sqlString,
                                        NSArray keys) {
        return EOUtilities.rawRowsForSQL(self, modelName, sqlString, keys);
    }

    public static NSArray rawRowsForStoredProcedureNamed(EOEditingContext self,
                                                         String name,
                                                         NSDictionary args) {
        return EOUtilities.rawRowsForStoredProcedureNamed(self, name, args);
    }

    public static NSArray rawRowsMatchingKeyAndValue(EOEditingContext self,
                                                     String name,
                                                     String key,
                                                     Object value) {
        return EOUtilities.rawRowsMatchingKeyAndValue(self, name, key, value);
    }

    public static NSDictionary executeStoredProcedureNamed(EOEditingContext self,
                                                           String name,
                                                           NSDictionary args) {
        return EOUtilities.executeStoredProcedureNamed(self, name, args);
    }

    public static void evaluateSQLWithEntityNamed(EOEditingContext self,
                                                  String entityName,
                                                  String exp) {
        ERXEOAccessUtilities.evaluateSQLWithEntityNamed(self, entityName, exp);
    }


    //
    // fetching
    //

    public static EOEnterpriseObject objectFromRawRow(EOEditingContext self,
                                                      String name, NSDictionary row) {
        return EOUtilities.objectFromRawRow(self, name, row);
    }

    public static EOEnterpriseObject objectMatchingKeyAndValue(EOEditingContext self,
                                                               String name,
                                                               String key,
                                                               Object value) {
        return EOUtilities.objectMatchingKeyAndValue(self, name, key, value);
    }

    public static EOEnterpriseObject objectMatchingValues(EOEditingContext self,
                                                          String name,
                                                          NSDictionary values) {
        return EOUtilities.objectMatchingValues(self, name, values);
    }

    public static NSArray objectsForEntityNamed(EOEditingContext self, String name) {
        return EOUtilities.objectsForEntityNamed(self, name);
    }

    public static NSArray objectsMatchingKeyAndValue(EOEditingContext self,
                                                     String name,
                                                     String key,
                                                     Object value) {
        return EOUtilities.objectsMatchingKeyAndValue(self, name, key, value);
    }

    public static NSArray objectsMatchingValues(EOEditingContext self,
                                                String name,
                                                NSDictionary values) {
        return EOUtilities.objectsMatchingValues(self, name, values);
    }

    public static NSArray objectsOfClass(EOEditingContext self, Class aClass) {
        return EOUtilities.objectsOfClass(self, aClass);
    }

    public static NSArray
        objectsWithFetchSpecificationAndBindings(EOEditingContext self,
                                                 String entityName,
                                                 String fetchSpecName,
                                                 NSDictionary bindings) {
        return EOUtilities.objectsWithFetchSpecificationAndBindings(self,
                                                                    entityName,
                                                                    fetchSpecName,
                                                                    bindings);
    }

    public static NSArray objectsWithQualifierFormat(EOEditingContext self,
                                                     String name,
                                                     String format,
                                                     NSArray args) {
        return EOUtilities.objectsWithQualifierFormat(self, name, format, args);
    }

    public static EOEnterpriseObject
        objectWithFetchSpecificationAndBindings(EOEditingContext self,
                                                String entityName,
                                                String fetchSpecName,
                                                NSDictionary bindings) {
        return EOUtilities.objectWithFetchSpecificationAndBindings(self,
                                                                   entityName,
                                                                   fetchSpecName,
                                                                   bindings);
    }

    public static EOEnterpriseObject objectWithPrimaryKey(EOEditingContext self,
                                                          String entityName,
                                                          NSDictionary pkDict) {
        return EOUtilities.objectWithPrimaryKey(self, entityName, pkDict);
    }

    public static EOEnterpriseObject objectWithPrimaryKeyValue(EOEditingContext self,
                                                               String entityName,
                                                               Object value) {
        return EOUtilities.objectWithPrimaryKeyValue(self, entityName, value);
    }

    public static EOEnterpriseObject objectWithQualifierFormat(EOEditingContext self,
                                                               String name,
                                                               String format,
                                                               NSArray args) {
        return EOUtilities.objectWithQualifierFormat(self, name, format, args);
    }


    //
    // decoding
    //

    public static NSArray objectsByDecodingFromFormValues(EOEditingContext self,
                                                          NSDictionary values) {
        return ERXEOEncodingUtilities.decodeEnterpriseObjectsFromFormValues(self,
                                                                            values);
    }

}
