#!/bin/sh

# ====================
# CompileGroovyScripts
# ====================
#
# This scripts compiles groovy scripts with suffix ".groovy" or ".gy".
#
# Setting:
# 1. Open edit window of "Application Server" target.
# 2. Add a "New Shell Script Build Phase" to after "Sources" build phase.
# 3. Write the following script.
#
#    sh /Library/Frameworks/WOGroovy.framework/Resources/CompileGroovyScripts.sh
#    
#    If you want to compile Groovy scripts only when building for deployment,
#    check "Run only when installing".
#

frameworks=$LINKED_CLASS_ARCHIVES:
javac_flags=$JAVA_COMPILER_FLAGS:
GROOVYC=groovyc
GROOVY_HOME=/Library/Frameworks/WOGroovy.framework/Resources
JAVA_HOME=/Library/Java/Home
GROOVY_COMPILE_DIR=_groovy_compile


# generate class path from linked frameworks
while [ $frameworks ]
do
  framework=${frameworks%%:*}
  frameworks=${frameworks#*:}

  if [ "$framework" != "" ]; then
    for jar in $framework/*.jar
    do
      CLASSPATH="$CLASSPATH:$jar"
    done
  fi
done


# generate class path from java compiler flags
javac_flags=${javac_flags#-extdirs }
while [ $javac_flags ]
do
  javac_flag=${javac_flags%%:*}
  javac_flags=${javac_flags#*:}

  if [ "$javac_flag" != "" ]; then
    for jar in $javac_flag/*.jar
    do
      CLASSPATH="$CLASSPATH:$jar"
    done
  fi
done


. $GROOVY_HOME/bin/groovyc --classpath $CLASSPATH *.groovy -d $GROOVY_COMPILE_DIR
. $GROOVY_HOME/bin/groovyc --classpath $CLASSPATH *.gy -d $GROOVY_COMPILE_DIR
cp -R $GROOVY_COMPILE_DIR/* "$CLASS_FILE_DIR"

