/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.classgen.AsmClassGenerator2;

public class ListExpression
extends Expression {
    private List expressions;

    public ListExpression() {
        this(new ArrayList());
    }

    public ListExpression(List expressions) {
        this.expressions = expressions;
    }

    public void addExpression(Expression expression) {
        this.expressions.add(expression);
    }

    public List getExpressions() {
        return this.expressions;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitListExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return new ListExpression(this.transformExpressions(this.getExpressions(), transformer));
    }

    protected void resolveType(AsmClassGenerator2 resolver) {
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression expression = (Expression)this.expressions.get(i);
            expression.resolve(resolver);
        }
        super.setTypeClass(List.class);
    }

    public Expression getExpression(int i) {
        return (Expression)this.expressions.get(i);
    }

    public String getText() {
        StringBuffer buffer = new StringBuffer("[");
        boolean first = true;
        Iterator iter = this.expressions.iterator();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(((Expression)iter.next()).getText());
        }
        buffer.append("]");
        return buffer.toString();
    }

    public String toString() {
        return super.toString() + this.expressions;
    }

    public Class getComponentTypeClass() {
        boolean first = true;
        Class cls = null;
        Iterator iter = this.expressions.iterator();
        while (iter.hasNext()) {
            Expression exp = (Expression)iter.next();
            if (cls == null) {
                cls = exp.getTypeClass();
                continue;
            }
            if (cls == exp.getTypeClass()) continue;
            return null;
        }
        return cls;
    }
}

