/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import java.beans.IntrospectionException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;

public class MetaClassRegistry {
    private Map metaClasses = Collections.synchronizedMap(new HashMap());
    private boolean useAccessible;
    private GroovyClassLoader loader = (GroovyClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return new GroovyClassLoader(this.getClass().getClassLoader());
        }
    });
    public static final int LOAD_DEFAULT = 0;
    public static final int DONT_LOAD_DEFAULT = 1;
    private static MetaClassRegistry instanceInclude;
    private static MetaClassRegistry instanceExclude;

    public MetaClassRegistry() {
        this(true);
    }

    public MetaClassRegistry(int loadDefault) {
        if (loadDefault == 0) {
            this.useAccessible = true;
            this.lookup(DefaultGroovyMethods.class).registerInstanceMethods();
            this.lookup(DefaultGroovyStaticMethods.class).registerStaticMethods();
            this.checkInitialised();
        } else {
            this.useAccessible = true;
        }
    }

    public MetaClassRegistry(boolean useAccessible) {
        this.useAccessible = useAccessible;
        this.lookup(DefaultGroovyMethods.class).registerInstanceMethods();
        this.lookup(DefaultGroovyStaticMethods.class).registerStaticMethods();
        this.checkInitialised();
    }

    public MetaClass getMetaClass(Class theClass) {
        MetaClass answer = (MetaClass)this.metaClasses.get(theClass);
        if (answer == null) {
            try {
                answer = new MetaClass(this, theClass);
                answer.checkInitialised();
            }
            catch (IntrospectionException e) {
                throw new GroovyRuntimeException("Could not introspect class: " + theClass.getName() + ". Reason: " + e, e);
            }
            this.metaClasses.put(theClass, answer);
        }
        return answer;
    }

    public void setMetaClass(Class theClass, MetaClass theMetaClass) {
        this.metaClasses.put(theClass, theMetaClass);
    }

    public boolean useAccessible() {
        return this.useAccessible;
    }

    public Class loadClass(final String name, final byte[] bytecode) throws ClassNotFoundException {
        return (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return MetaClassRegistry.this.loader.defineClass(name, bytecode, this.getClass().getProtectionDomain());
            }
        });
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loader.loadClass(name);
    }

    void checkInitialised() {
        ArrayList list = new ArrayList(this.metaClasses.values());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            MetaClass metaClass = (MetaClass)iter.next();
            metaClass.checkInitialised();
        }
    }

    MetaClass lookup(Class theClass) {
        MetaClass answer = (MetaClass)this.metaClasses.get(theClass);
        if (answer == null) {
            try {
                answer = new MetaClass(this, theClass);
            }
            catch (IntrospectionException e) {
                throw new GroovyRuntimeException("Could not introspect class: " + theClass.getName() + ". Reason: " + e, e);
            }
            this.metaClasses.put(theClass, answer);
        }
        return answer;
    }

    public MetaMethod getDefinedMethod(Class theClass, String methodName, Class[] args, boolean isStatic) {
        MetaClass metaclass = this.getMetaClass(theClass);
        if (metaclass == null) {
            return null;
        }
        if (isStatic) {
            return metaclass.retrieveStaticMethod(methodName, args);
        }
        return metaclass.retrieveMethod(methodName, args);
    }

    public Constructor getDefinedConstructor(Class theClass, Class[] args) {
        MetaClass metaclass = this.getMetaClass(theClass);
        if (metaclass == null) {
            return null;
        }
        return metaclass.retrieveConstructor(args);
    }

    public static MetaClassRegistry getIntance(int includeExtension) {
        if (includeExtension != 1) {
            if (instanceInclude == null) {
                instanceInclude = new MetaClassRegistry();
            }
            return instanceInclude;
        }
        if (instanceExclude == null) {
            instanceExclude = new MetaClassRegistry(1);
        }
        return instanceExclude;
    }
}

