/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import [Ljava.lang.Object;;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaArrayLengthProperty;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaFieldProperty;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.ReadOnlyPropertyException;
import groovy.lang.Tuple;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.ReflectorGenerator;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.runtime.ClosureListener;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GroovyCategorySupport;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.runtime.MethodHelper;
import org.codehaus.groovy.runtime.NewInstanceMetaMethod;
import org.codehaus.groovy.runtime.NewStaticMetaMethod;
import org.codehaus.groovy.runtime.ReflectionMetaMethod;
import org.codehaus.groovy.runtime.Reflector;
import org.codehaus.groovy.runtime.TemporaryMethodKey;
import org.codehaus.groovy.runtime.TransformMetaMethod;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class MetaClass {
    private static final Logger log = Logger.getLogger(MetaClass.class.getName());
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static Class[] EMPTY_TYPE_ARRAY = new Class[0];
    protected static final Object[] ARRAY_WITH_NULL = new Object[]{null};
    private static boolean useReflection = false;
    private MetaClassRegistry registry;
    private Class theClass;
    private ClassNode classNode;
    private Map methodIndex = new HashMap();
    private Map staticMethodIndex = new HashMap();
    private List newGroovyMethodsList = new ArrayList();
    private Map propertyMap = Collections.synchronizedMap(new HashMap());
    private Map listeners = new HashMap();
    private Map methodCache = Collections.synchronizedMap(new HashMap());
    private Map staticMethodCache = Collections.synchronizedMap(new HashMap());
    private MetaMethod genericGetMethod;
    private MetaMethod genericSetMethod;
    private List constructors;
    private List allMethods = new ArrayList();
    private List interfaceMethods;
    private Reflector reflector;
    private boolean initialised;
    private MetaProperty arrayLengthProperty = new MetaArrayLengthProperty();
    static /* synthetic */ Class class$java$math$BigInteger;

    public MetaClass(MetaClassRegistry registry, final Class theClass) throws IntrospectionException {
        this.registry = registry;
        this.theClass = theClass;
        this.constructors = Arrays.asList(theClass.getDeclaredConstructors());
        this.addMethods(theClass);
        BeanInfo info = null;
        try {
            info = (BeanInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IntrospectionException {
                    return Introspector.getBeanInfo(theClass);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            if (pae.getException() instanceof IntrospectionException) {
                throw (IntrospectionException)pae.getException();
            }
            throw new RuntimeException(pae.getException());
        }
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        this.setupProperties(descriptors);
        EventSetDescriptor[] eventDescriptors = info.getEventSetDescriptors();
        for (int i = 0; i < eventDescriptors.length; ++i) {
            EventSetDescriptor descriptor = eventDescriptors[i];
            Method[] listenerMethods = descriptor.getListenerMethods();
            for (int j = 0; j < listenerMethods.length; ++j) {
                Method listenerMethod = listenerMethods[j];
                MetaMethod metaMethod = this.createMetaMethod(descriptor.getAddListenerMethod());
                this.listeners.put(listenerMethod.getName(), metaMethod);
            }
        }
    }

    public static boolean isUseReflection() {
        return useReflection;
    }

    public static void setUseReflection(boolean useReflection) {
        MetaClass.useReflection = useReflection;
    }

    private void addInheritedMethods(Class theClass) {
        Class c = theClass;
        if (c != Object.class) {
            while ((c = c.getSuperclass()) != (class$java$lang$Object == null ? MetaClass.class$("java.lang.Object") : class$java$lang$Object) && c != null) {
                this.addMethods(c);
                this.addNewStaticMethodsFrom(c);
            }
        }
        Class<?>[] interfaces = theClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.addNewStaticMethodsFrom(interfaces[i]);
        }
        if (theClass != Object.class) {
            this.addMethods(Object.class);
            this.addNewStaticMethodsFrom(Object.class);
        }
        if (theClass.isArray() && !theClass.equals(Object;.class)) {
            this.addNewStaticMethodsFrom(Object;.class);
        }
    }

    public List getMethods(String name) {
        List answer = (List)this.methodIndex.get(name);
        List used = GroovyCategorySupport.getCategoryMethods(this.theClass, name);
        if (used != null) {
            if (answer != null) {
                answer.addAll(used);
            } else {
                answer = used;
            }
        }
        if (answer == null) {
            answer = Collections.EMPTY_LIST;
        }
        return answer;
    }

    public List getStaticMethods(String name) {
        List answer = (List)this.staticMethodIndex.get(name);
        if (answer == null) {
            return Collections.EMPTY_LIST;
        }
        return answer;
    }

    protected void addNewInstanceMethod(Method method) {
        if (this.initialised) {
            throw new RuntimeException("Already initialized, cannot add new method: " + method);
        }
        NewInstanceMetaMethod newMethod = new NewInstanceMetaMethod(this.createMetaMethod(method));
        this.addMethod(newMethod);
        this.addNewInstanceMethod(newMethod);
    }

    protected void addNewInstanceMethod(MetaMethod method) {
        this.newGroovyMethodsList.add(method);
    }

    protected void addNewStaticMethod(Method method) {
        if (this.initialised) {
            throw new RuntimeException("Already initialized, cannot add new method: " + method);
        }
        NewStaticMetaMethod newMethod = new NewStaticMetaMethod(this.createMetaMethod(method));
        this.addMethod(newMethod);
        this.addNewStaticMethod(newMethod);
    }

    protected void addNewStaticMethod(MetaMethod method) {
        this.newGroovyMethodsList.add(method);
    }

    public Object invokeMethod(Object object, String methodName, Object arguments) {
        return this.invokeMethod(object, methodName, this.asArray(arguments));
    }

    public Object invokeMethod(Object object, String methodName, Object[] arguments) {
        if (object == null) {
            throw new NullPointerException("Cannot invoke method: " + methodName + " on null object");
        }
        MetaMethod method = this.retrieveMethod(object, methodName, arguments);
        if (method != null) {
            return this.doMethodInvoke(object, method, arguments);
        }
        try {
            Object value = this.getProperty(object, methodName);
            if (value instanceof Closure) {
                Closure closure = (Closure)value;
                closure.setDelegate(this);
                return closure.call(arguments);
            }
            throw new MissingMethodException(methodName, this.theClass, arguments);
        }
        catch (Exception e) {
            throw new MissingMethodException(methodName, this.theClass, arguments);
        }
    }

    protected MetaMethod retrieveMethod(Object owner, String methodName, Object[] arguments) {
        TemporaryMethodKey methodKey = new TemporaryMethodKey(methodName, arguments);
        MetaMethod method = (MetaMethod)this.methodCache.get(methodKey);
        if (method == null && (method = this.pickMethod(owner, methodName, arguments)) != null && method.isCacheable()) {
            this.methodCache.put(methodKey.createCopy(), method);
        }
        return method;
    }

    public MetaMethod retrieveMethod(String methodName, Class[] arguments) {
        TemporaryMethodKey methodKey = new TemporaryMethodKey(methodName, arguments);
        MetaMethod method = (MetaMethod)this.methodCache.get(methodKey);
        if (method == null && (method = this.pickMethod(methodName, arguments)) != null && method.isCacheable()) {
            this.methodCache.put(methodKey.createCopy(), method);
        }
        return method;
    }

    public Constructor retrieveConstructor(Class[] arguments) {
        Constructor constructor = (Constructor)this.chooseMethod("<init>", this.constructors, arguments, false);
        if (constructor != null) {
            return constructor;
        }
        constructor = (Constructor)this.chooseMethod("<init>", this.constructors, arguments, true);
        if (constructor != null) {
            return constructor;
        }
        return null;
    }

    public MetaMethod retrieveStaticMethod(String methodName, Class[] arguments) {
        TemporaryMethodKey methodKey = new TemporaryMethodKey(methodName, arguments);
        MetaMethod method = (MetaMethod)this.staticMethodCache.get(methodKey);
        if (method == null && (method = this.pickStaticMethod(methodName, arguments)) != null) {
            this.staticMethodCache.put(methodKey.createCopy(), method);
        }
        return method;
    }

    protected MetaMethod pickMethod(Object object, String methodName, Object[] arguments) {
        Class[] argClasses;
        MetaMethod method = null;
        List methods = this.getMethods(methodName);
        if (!methods.isEmpty() && (method = (MetaMethod)this.chooseMethod(methodName, methods, argClasses = this.convertToTypeArray(arguments), false)) == null && (method = (MetaMethod)this.chooseMethod(methodName, methods, argClasses, true)) == null) {
            Object firstArgument;
            int size;
            int n = size = arguments != null ? arguments.length : 0;
            if (size == 1 && (firstArgument = arguments[0]) instanceof List) {
                List list = (List)firstArgument;
                arguments = list.toArray();
                argClasses = this.convertToTypeArray(arguments);
                method = (MetaMethod)this.chooseMethod(methodName, methods, argClasses, true);
                return new TransformMetaMethod(method){

                    public Object invoke(Object object, Object[] arguments) throws Exception {
                        Object firstArgument = arguments[0];
                        List list = (List)firstArgument;
                        arguments = list.toArray();
                        return super.invoke(object, arguments);
                    }
                };
            }
        }
        return method;
    }

    protected MetaMethod pickMethod(String methodName, Class[] arguments) {
        MetaMethod method = null;
        List methods = this.getMethods(methodName);
        if (!methods.isEmpty()) {
            method = (MetaMethod)this.chooseMethod(methodName, methods, arguments, false);
        }
        return method;
    }

    public Object invokeStaticMethod(Object object, String methodName, Object[] arguments) {
        TemporaryMethodKey methodKey = new TemporaryMethodKey(methodName, arguments);
        MetaMethod method = (MetaMethod)this.staticMethodCache.get(methodKey);
        if (method == null && (method = this.pickStaticMethod(object, methodName, arguments)) != null) {
            this.staticMethodCache.put(methodKey.createCopy(), method);
        }
        if (method != null) {
            return this.doMethodInvoke(object, method, arguments);
        }
        throw new MissingMethodException(methodName, this.theClass, arguments);
    }

    protected MetaMethod pickStaticMethod(Object object, String methodName, Object[] arguments) {
        MetaMethod method = null;
        List methods = this.getStaticMethods(methodName);
        if (!methods.isEmpty()) {
            method = (MetaMethod)this.chooseMethod(methodName, methods, this.convertToTypeArray(arguments), false);
        }
        if (method == null && this.theClass != Class.class) {
            MetaClass classMetaClass = this.registry.getMetaClass(Class.class);
            method = classMetaClass.pickMethod(object, methodName, arguments);
        }
        return method;
    }

    protected MetaMethod pickStaticMethod(String methodName, Class[] arguments) {
        MetaMethod method = null;
        List methods = this.getStaticMethods(methodName);
        if (!methods.isEmpty()) {
            method = (MetaMethod)this.chooseMethod(methodName, methods, arguments, false);
        }
        if (method == null && this.theClass != Class.class) {
            MetaClass classMetaClass = this.registry.getMetaClass(Class.class);
            method = classMetaClass.pickMethod(methodName, arguments);
        }
        return method;
    }

    public Object invokeConstructor(Object[] arguments) {
        Object firstArgument;
        Class[] argClasses = this.convertToTypeArray(arguments);
        Constructor constructor = (Constructor)this.chooseMethod("<init>", this.constructors, argClasses, false);
        if (constructor != null) {
            return this.doConstructorInvoke(constructor, arguments);
        }
        constructor = (Constructor)this.chooseMethod("<init>", this.constructors, argClasses, true);
        if (constructor != null) {
            return this.doConstructorInvoke(constructor, arguments);
        }
        if (arguments.length == 1 && (firstArgument = arguments[0]) instanceof Map && (constructor = (Constructor)this.chooseMethod("<init>", this.constructors, EMPTY_TYPE_ARRAY, false)) != null) {
            Object bean = this.doConstructorInvoke(constructor, EMPTY_ARRAY);
            this.setProperties(bean, (Map)firstArgument);
            return bean;
        }
        throw new GroovyRuntimeException("Could not find matching constructor for: " + this.theClass.getName() + "(" + InvokerHelper.toTypeString(arguments) + ")");
    }

    public void setProperties(Object bean, Map map) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = entry.getKey().toString();
            if (this.propertyMap.get(key) == null) continue;
            Object value = entry.getValue();
            try {
                this.setProperty(bean, key, value);
            }
            catch (GroovyRuntimeException e) {}
        }
    }

    public Object getProperty(Object object, String property) {
        MetaMethod addListenerMethod;
        List methods;
        MetaProperty mp = (MetaProperty)this.propertyMap.get(property);
        if (mp != null) {
            try {
                return mp.getProperty(object);
            }
            catch (Exception e) {
                throw new GroovyRuntimeException("Cannot read property: " + property);
            }
        }
        if (this.genericGetMethod == null) {
            List possibleGenericMethods = this.getMethods("get");
            if (possibleGenericMethods != null) {
                Iterator i = possibleGenericMethods.iterator();
                while (i.hasNext()) {
                    MetaMethod mmethod = (MetaMethod)i.next();
                    Class[] paramTypes = mmethod.getParameterTypes();
                    if (paramTypes.length != 1 || paramTypes[0] != (class$java$lang$String == null ? MetaClass.class$("java.lang.String") : class$java$lang$String)) continue;
                    Object[] arguments = new Object[]{property};
                    Object answer = this.doMethodInvoke(object, mmethod, arguments);
                    return answer;
                }
            }
        } else {
            Object[] arguments = new Object[]{property};
            Object answer = this.doMethodInvoke(object, this.genericGetMethod, arguments);
            if (answer != null) {
                return answer;
            }
        }
        if (!(methods = this.getMethods(property)).isEmpty()) {
            return new MethodClosure(object, property);
        }
        GroovyRuntimeException lastException = null;
        try {
            MetaMethod method = this.findGetter(object, "get" + this.capitalize(property));
            if (method != null) {
                return this.doMethodInvoke(object, method, EMPTY_ARRAY);
            }
        }
        catch (GroovyRuntimeException e) {
            lastException = e;
        }
        if (this.genericGetMethod != null) {
            return null;
        }
        if (object instanceof Class) {
            return this.getStaticProperty((Class)object, property);
        }
        if (object instanceof Collection) {
            return DefaultGroovyMethods.getAt((Collection)object, property);
        }
        if (object instanceof Object[]) {
            return DefaultGroovyMethods.getAt(Arrays.asList((Object[])object), property);
        }
        if (object instanceof Object) {
            try {
                Field field = object.getClass().getDeclaredField(property);
                return field.get(object);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        if ((addListenerMethod = (MetaMethod)this.listeners.get(property)) != null) {
            return null;
        }
        if (lastException == null) {
            throw new MissingPropertyException(property, this.theClass);
        }
        throw new MissingPropertyException(property, this.theClass, lastException);
    }

    public List getProperties() {
        return new ArrayList(this.propertyMap.values());
    }

    protected void setupProperties(PropertyDescriptor[] propertyDescriptors) {
        MetaProperty mp;
        Method method;
        Class klass;
        MetaMethod getter = null;
        MetaMethod setter = null;
        for (klass = this.theClass; klass != null; klass = klass.getSuperclass()) {
            Field[] fields = klass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if ((fields[i].getModifiers() & 1) == 0 || this.propertyMap.get(fields[i].getName()) != null) continue;
                this.propertyMap.put(fields[i].getName(), new MetaFieldProperty(fields[i]));
            }
        }
        if (this.theClass.isArray()) {
            this.propertyMap.put("length", this.arrayLengthProperty);
        }
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor pd = propertyDescriptors[i];
            if (this.propertyMap.get(pd.getName()) != null || pd.getPropertyType() == null) continue;
            method = pd.getReadMethod();
            getter = method != null ? this.findMethod(method) : null;
            method = pd.getWriteMethod();
            setter = method != null ? this.findMethod(method) : null;
            mp = new MetaBeanProperty(pd.getName(), pd.getPropertyType(), getter, setter);
            this.propertyMap.put(pd.getName(), mp);
        }
        for (klass = this.theClass; klass != null; klass = klass.getSuperclass()) {
            Method[] methods = klass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                MetaBeanProperty mbp;
                String propName;
                if (!Modifier.isPublic(methods[i].getModifiers())) continue;
                method = methods[i];
                String methodName = method.getName();
                if (methodName.startsWith("get") && methodName.length() > 3 && method.getParameterTypes().length == 0) {
                    propName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                    mp = (MetaProperty)this.propertyMap.get(propName);
                    if (mp != null) {
                        if (!(mp instanceof MetaBeanProperty) || ((MetaBeanProperty)mp).getGetter() != null) continue;
                        ((MetaBeanProperty)mp).setGetter(this.findMethod(method));
                        continue;
                    }
                    mbp = new MetaBeanProperty(propName, method.getReturnType(), this.findMethod(method), null);
                    this.propertyMap.put(propName, mbp);
                    continue;
                }
                if (!methodName.startsWith("set") || methodName.length() <= 3 || method.getParameterTypes().length != 1) continue;
                propName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                mp = (MetaProperty)this.propertyMap.get(propName);
                if (mp != null) {
                    if (!(mp instanceof MetaBeanProperty) || ((MetaBeanProperty)mp).getSetter() != null) continue;
                    ((MetaBeanProperty)mp).setSetter(this.findMethod(method));
                    continue;
                }
                mbp = new MetaBeanProperty(propName, method.getParameterTypes()[0], null, this.findMethod(method));
                this.propertyMap.put(propName, mbp);
            }
        }
    }

    public void setProperty(Object object, String property, Object newValue) {
        MetaProperty mp = (MetaProperty)this.propertyMap.get(property);
        if (mp != null) {
            try {
                mp.setProperty(object, newValue);
                return;
            }
            catch (ReadOnlyPropertyException e) {
                throw e;
            }
            catch (Exception e) {
                Class parameterType;
                if (newValue instanceof List) {
                    List list = (List)newValue;
                    int params = list.size();
                    Constructor<?>[] constructors = mp.getType().getConstructors();
                    for (int i = 0; i < constructors.length; ++i) {
                        Constructor<?> constructor = constructors[i];
                        if (constructor.getParameterTypes().length != params) continue;
                        Object value = this.doConstructorInvoke(constructor, list.toArray());
                        mp.setProperty(object, value);
                        return;
                    }
                    parameterType = mp.getType();
                    if (parameterType.isArray()) {
                        Object objArray = this.asPrimitiveArray(list, parameterType);
                        mp.setProperty(object, objArray);
                        return;
                    }
                }
                if (newValue.getClass().isArray() && mp instanceof MetaBeanProperty) {
                    MetaBeanProperty mbp = (MetaBeanProperty)mp;
                    List<Object> list = Arrays.asList((Object[])newValue);
                    MetaMethod setter = mbp.getSetter();
                    parameterType = setter.getParameterTypes()[0];
                    Class<?> arrayType = parameterType.getComponentType();
                    Object objArray = Array.newInstance(arrayType, list.size());
                    for (int i = 0; i < list.size(); ++i) {
                        List<Object> list2 = Arrays.asList((Object[])list.get(i));
                        Object objArray2 = this.asPrimitiveArray(list2, arrayType);
                        Array.set(objArray, i, objArray2);
                    }
                    this.doMethodInvoke(object, setter, new Object[]{objArray});
                    return;
                }
                throw new MissingPropertyException(property, this.theClass, e);
            }
        }
        try {
            MetaMethod addListenerMethod = (MetaMethod)this.listeners.get(property);
            if (addListenerMethod != null && newValue instanceof Closure) {
                Object proxy = this.createListenerProxy(addListenerMethod.getParameterTypes()[0], property, (Closure)newValue);
                this.doMethodInvoke(object, addListenerMethod, new Object[]{proxy});
                return;
            }
            if (this.genericSetMethod == null) {
                List possibleGenericMethods = this.getMethods("set");
                if (possibleGenericMethods != null) {
                    Iterator i = possibleGenericMethods.iterator();
                    while (i.hasNext()) {
                        MetaMethod mmethod = (MetaMethod)i.next();
                        Class[] paramTypes = mmethod.getParameterTypes();
                        if (paramTypes.length != 2 || paramTypes[0] != (class$java$lang$String == null ? MetaClass.class$("java.lang.String") : class$java$lang$String)) continue;
                        Object[] arguments = new Object[]{property, newValue};
                        Object answer = this.doMethodInvoke(object, mmethod, arguments);
                        return;
                    }
                }
            } else {
                Object[] arguments = new Object[]{property, newValue};
                this.doMethodInvoke(object, this.genericSetMethod, arguments);
                return;
            }
            String method = "set" + this.capitalize(property);
            try {
                this.invokeMethod(object, method, new Object[]{newValue});
            }
            catch (MissingMethodException e1) {
                try {
                    Field field = object.getClass().getDeclaredField(property);
                    field.set(object, newValue);
                }
                catch (Exception e2) {
                    throw new MissingPropertyException(property, this.theClass, e2);
                }
            }
        }
        catch (GroovyRuntimeException e) {
            throw new MissingPropertyException(property, this.theClass, e);
        }
        throw new MissingPropertyException(property, this.theClass);
    }

    private Object asPrimitiveArray(List list, Class parameterType) {
        Class<?> arrayType = parameterType.getComponentType();
        Object objArray = Array.newInstance(arrayType, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (arrayType.isPrimitive()) {
                if (obj instanceof Integer) {
                    Array.setInt(objArray, i, (Integer)obj);
                    continue;
                }
                if (obj instanceof Double) {
                    Array.setDouble(objArray, i, (Double)obj);
                    continue;
                }
                if (obj instanceof Boolean) {
                    Array.setBoolean(objArray, i, (Boolean)obj);
                    continue;
                }
                if (obj instanceof Long) {
                    Array.setLong(objArray, i, (Long)obj);
                    continue;
                }
                if (obj instanceof Float) {
                    Array.setFloat(objArray, i, ((Float)obj).floatValue());
                    continue;
                }
                if (obj instanceof Character) {
                    Array.setChar(objArray, i, ((Character)obj).charValue());
                    continue;
                }
                if (obj instanceof Byte) {
                    Array.setByte(objArray, i, (Byte)obj);
                    continue;
                }
                if (!(obj instanceof Short)) continue;
                Array.setShort(objArray, i, (Short)obj);
                continue;
            }
            Array.set(objArray, i, obj);
        }
        return objArray;
    }

    public ClassNode getClassNode() {
        if (this.classNode == null && GroovyObject.class.isAssignableFrom(this.theClass)) {
            String className = this.theClass.getName();
            String groovyFile = className;
            int idx = groovyFile.indexOf(36);
            if (idx > 0) {
                groovyFile = groovyFile.substring(0, idx);
            }
            groovyFile = groovyFile.replace('.', '/') + ".groovy";
            URL url = this.theClass.getClassLoader().getResource(groovyFile);
            if (url == null) {
                url = Thread.currentThread().getContextClassLoader().getResource(groovyFile);
            }
            if (url != null) {
                try {
                    CompilationUnit.ClassgenCallback search = new CompilationUnit.ClassgenCallback(){

                        public void call(ClassVisitor writer, ClassNode node) {
                            if (node.getName().equals(MetaClass.this.theClass.getName())) {
                                MetaClass.this.classNode = node;
                            }
                        }
                    };
                    CompilationUnit unit = new CompilationUnit(this.getClass().getClassLoader());
                    unit.setClassgenCallback(search);
                    unit.addSource(url);
                    unit.compile(7);
                }
                catch (Exception e) {
                    throw new GroovyRuntimeException("Exception thrown parsing: " + groovyFile + ". Reason: " + e, e);
                }
            }
        }
        return this.classNode;
    }

    public String toString() {
        return super.toString() + "[" + this.theClass + "]";
    }

    protected Object[] asArray(Object arguments) {
        if (arguments == null) {
            return EMPTY_ARRAY;
        }
        if (arguments instanceof Tuple) {
            Tuple tuple = (Tuple)arguments;
            return tuple.toArray();
        }
        if (arguments instanceof Object[]) {
            return (Object[])arguments;
        }
        return new Object[]{arguments};
    }

    protected Object createListenerProxy(Class listenerType, String listenerMethodName, Closure closure) {
        ClosureListener handler = new ClosureListener(listenerMethodName, closure);
        return Proxy.newProxyInstance(listenerType.getClassLoader(), new Class[]{listenerType}, (InvocationHandler)handler);
    }

    protected void addMethods(Class theClass) {
        Method[] methodArray = theClass.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method reflectionMethod = methodArray[i];
            if (reflectionMethod.getName().indexOf(43) >= 0) continue;
            MetaMethod method = this.createMetaMethod(reflectionMethod);
            this.addMethod(method);
        }
    }

    protected void addMethod(MetaMethod method) {
        ArrayList<MetaMethod> list;
        String name = method.getName();
        if (this.isGenericGetMethod(method) && this.genericGetMethod == null) {
            this.genericGetMethod = method;
        } else if (this.isGenericSetMethod(method) && this.genericSetMethod == null) {
            this.genericSetMethod = method;
        }
        if (method.isStatic()) {
            list = (ArrayList<MetaMethod>)this.staticMethodIndex.get(name);
            if (list == null) {
                list = new ArrayList<MetaMethod>();
                this.staticMethodIndex.put(name, list);
                list.add(method);
            } else if (!this.containsMatchingMethod(list, method)) {
                list.add(method);
            }
        }
        if ((list = (List)this.methodIndex.get(name)) == null) {
            list = new ArrayList();
            this.methodIndex.put(name, list);
            list.add(method);
        } else if (!this.containsMatchingMethod(list, method)) {
            list.add(method);
        }
    }

    protected boolean containsMatchingMethod(List list, MetaMethod method) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Class[] params2;
            MetaMethod aMethod = (MetaMethod)iter.next();
            Class[] params1 = aMethod.getParameterTypes();
            if (params1.length != (params2 = method.getParameterTypes()).length) continue;
            boolean matches = true;
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }

    protected void addNewStaticMethodsFrom(Class theClass) {
        MetaClass interfaceMetaClass = this.registry.getMetaClass(theClass);
        Iterator iter = interfaceMetaClass.newGroovyMethodsList.iterator();
        while (iter.hasNext()) {
            MetaMethod method = (MetaMethod)iter.next();
            this.addMethod(method);
            this.newGroovyMethodsList.add(method);
        }
    }

    protected Object getStaticProperty(Class aClass, String property) {
        Exception lastException = null;
        try {
            Field field = aClass.getField(property);
            if (field != null && (field.getModifiers() & 8) != 0) {
                return field.get(null);
            }
        }
        catch (Exception e) {
            lastException = e;
        }
        try {
            MetaMethod method = this.findStaticGetter(aClass, "get" + this.capitalize(property));
            if (method != null) {
                return this.doMethodInvoke(aClass, method, EMPTY_ARRAY);
            }
        }
        catch (GroovyRuntimeException e) {
            throw new MissingPropertyException(property, aClass, e);
        }
        if (lastException == null) {
            throw new MissingPropertyException(property, aClass);
        }
        throw new MissingPropertyException(property, aClass, lastException);
    }

    protected MetaMethod findMethod(Method aMethod) {
        List methods = this.getMethods(aMethod.getName());
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            MetaMethod method = (MetaMethod)iter.next();
            if (!method.isMethod(aMethod)) continue;
            return method;
        }
        return new ReflectionMetaMethod(aMethod);
    }

    protected MetaMethod findGetter(Object object, String name) {
        List methods = this.getMethods(name);
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            MetaMethod method = (MetaMethod)iter.next();
            if (method.getParameterTypes().length != 0) continue;
            return method;
        }
        return null;
    }

    protected MetaMethod findStaticGetter(Class type, String name) {
        List methods = this.getStaticMethods(name);
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            MetaMethod method = (MetaMethod)iter.next();
            if (method.getParameterTypes().length != 0) continue;
            return method;
        }
        try {
            Method method = type.getMethod(name, EMPTY_TYPE_ARRAY);
            if ((method.getModifiers() & 8) != 0) {
                return this.findMethod(method);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Object doMethodInvoke(Object object, MetaMethod method, Object[] argumentArray) {
        try {
            if (argumentArray == null) {
                argumentArray = EMPTY_ARRAY;
            } else if (method.getParameterTypes().length == 1 && argumentArray.length == 0) {
                argumentArray = ARRAY_WITH_NULL;
            }
            return method.invoke(object, argumentArray);
        }
        catch (ClassCastException e) {
            if (MetaClass.coerceGStrings(argumentArray)) {
                try {
                    return this.doMethodInvoke(object, method, argumentArray);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            throw new GroovyRuntimeException("failed to invoke method: " + method + " on: " + object + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Error) {
                Error error = (Error)t;
                throw error;
            }
            if (t instanceof RuntimeException) {
                RuntimeException runtimeEx = (RuntimeException)t;
                throw runtimeEx;
            }
            throw new InvokerInvocationException(e);
        }
        catch (IllegalAccessException e) {
            throw new GroovyRuntimeException("could not access method: " + method + " on: " + object + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, e);
        }
        catch (IllegalArgumentException e) {
            Object[] args;
            if (MetaClass.coerceGStrings(argumentArray)) {
                try {
                    return this.doMethodInvoke(object, method, argumentArray);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            if ((args = MetaClass.coerceNumbers(method, argumentArray)) != null) {
                try {
                    return this.doMethodInvoke(object, method, args);
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
            throw new GroovyRuntimeException("failed to invoke method: " + method + " on: " + object + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("failed to invoke method: " + method + " on: " + object + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, e);
        }
    }

    private static Object[] coerceNumbers(MetaMethod method, Object[] arguments) {
        Object[] ans = null;
        boolean coerced = false;
        Class[] params = method.getParameterTypes();
        if (params.length != arguments.length) {
            return null;
        }
        ans = new Object[arguments.length];
        int size = arguments.length;
        for (int i = 0; i < size; ++i) {
            Class<?> paramElem;
            Class param;
            Object argument = arguments[i];
            if (((class$java$lang$Number == null ? MetaClass.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(param = params[i]) || param.isPrimitive()) && argument instanceof Number) {
                if (param == (class$java$lang$Byte == null ? MetaClass.class$("java.lang.Byte") : class$java$lang$Byte) || param == Byte.TYPE) {
                    ans[i] = new Byte(((Number)argument).byteValue());
                    coerced = true;
                    continue;
                }
                if (param == (class$java$lang$Double == null ? MetaClass.class$("java.lang.Double") : class$java$lang$Double) || param == Double.TYPE) {
                    ans[i] = new Double(((Number)argument).doubleValue());
                    coerced = true;
                    continue;
                }
                if (param == (class$java$lang$Float == null ? MetaClass.class$("java.lang.Float") : class$java$lang$Float) || param == Float.TYPE) {
                    ans[i] = new Float(((Number)argument).floatValue());
                    coerced = true;
                    continue;
                }
                if (param == (class$java$lang$Integer == null ? MetaClass.class$("java.lang.Integer") : class$java$lang$Integer) || param == Integer.TYPE) {
                    ans[i] = new Integer(((Number)argument).intValue());
                    coerced = true;
                    continue;
                }
                if (param == (class$java$lang$Long == null ? MetaClass.class$("java.lang.Long") : class$java$lang$Long) || param == Long.TYPE) {
                    ans[i] = new Long(((Number)argument).longValue());
                    coerced = true;
                    continue;
                }
                if (param == (class$java$lang$Short == null ? MetaClass.class$("java.lang.Short") : class$java$lang$Short) || param == Short.TYPE) {
                    ans[i] = new Short(((Number)argument).shortValue());
                    coerced = true;
                    continue;
                }
                if (param == (class$java$math$BigDecimal == null ? MetaClass.class$("java.math.BigDecimal") : class$java$math$BigDecimal)) {
                    ans[i] = new BigDecimal(((Number)argument).doubleValue());
                    coerced = true;
                    continue;
                }
                if (param != (class$java$math$BigInteger == null ? MetaClass.class$("java.math.BigInteger") : class$java$math$BigInteger)) continue;
                ans[i] = new BigInteger(String.valueOf(((Number)argument).longValue()));
                coerced = true;
                continue;
            }
            if (!param.isArray() || !argument.getClass().isArray() || !(paramElem = param.getComponentType()).isPrimitive()) continue;
            if (paramElem == Boolean.TYPE && argument.getClass().getName().equals("[Ljava.lang.Boolean;")) {
                ans[i] = InvokerHelper.convertToBooleanArray(argument);
                coerced = true;
                continue;
            }
            if (paramElem == Byte.TYPE && argument.getClass().getName().equals("[Ljava.lang.Byte;")) {
                ans[i] = InvokerHelper.convertToByteArray(argument);
                coerced = true;
                continue;
            }
            if (paramElem == Character.TYPE && argument.getClass().getName().equals("[Ljava.lang.Character;")) {
                ans[i] = InvokerHelper.convertToCharArray(argument);
                coerced = true;
                continue;
            }
            if (paramElem == Short.TYPE && argument.getClass().getName().equals("[Ljava.lang.Short;")) {
                ans[i] = InvokerHelper.convertToShortArray(argument);
                coerced = true;
                continue;
            }
            if (paramElem == Integer.TYPE && argument.getClass().getName().equals("[Ljava.lang.Integer;")) {
                ans[i] = InvokerHelper.convertToIntArray(argument);
                coerced = true;
                continue;
            }
            if (paramElem == Long.TYPE && argument.getClass().getName().equals("[Ljava.lang.Long;") && argument.getClass().getName().equals("[Ljava.lang.Integer;")) {
                ans[i] = InvokerHelper.convertToLongArray(argument);
                coerced = true;
                continue;
            }
            if (paramElem == Float.TYPE && argument.getClass().getName().equals("[Ljava.lang.Float;") && argument.getClass().getName().equals("[Ljava.lang.Integer;")) {
                ans[i] = InvokerHelper.convertToFloatArray(argument);
                coerced = true;
                continue;
            }
            if (paramElem != Double.TYPE || !argument.getClass().getName().equals("[Ljava.lang.Double;") || !argument.getClass().getName().equals("[Ljava.lang.BigDecimal;") || !argument.getClass().getName().equals("[Ljava.lang.Float;")) continue;
            ans[i] = InvokerHelper.convertToDoubleArray(argument);
            coerced = true;
        }
        return coerced ? ans : null;
    }

    protected Object doConstructorInvoke(Constructor constructor, Object[] argumentArray) {
        try {
            return constructor.newInstance(argumentArray);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Error) {
                Error error = (Error)t;
                throw error;
            }
            if (t instanceof RuntimeException) {
                RuntimeException runtimeEx = (RuntimeException)t;
                throw runtimeEx;
            }
            throw new InvokerInvocationException(e);
        }
        catch (IllegalArgumentException e) {
            if (MetaClass.coerceGStrings(argumentArray)) {
                try {
                    return constructor.newInstance(argumentArray);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            throw new GroovyRuntimeException("failed to invoke constructor: " + constructor + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, e);
        }
        catch (IllegalAccessException e) {
            throw new GroovyRuntimeException("could not access constructor: " + constructor + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, e);
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("failed to invoke constructor: " + constructor + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, e);
        }
    }

    protected Object chooseMethod(String methodName, List methods, Class[] arguments, boolean coerce) {
        int methodCount = methods.size();
        if (methodCount <= 0) {
            return null;
        }
        if (methodCount == 1) {
            Object method = methods.get(0);
            if (this.isValidMethod(method, arguments, coerce)) {
                return method;
            }
            return null;
        }
        Object answer = null;
        if (arguments == null || arguments.length == 0) {
            answer = this.chooseEmptyMethodParams(methods);
        } else if (arguments.length == 1 && arguments[0] == null) {
            answer = this.chooseMostGeneralMethodWith1Param(methods);
        } else {
            ArrayList matchingMethods = new ArrayList();
            Iterator iter = methods.iterator();
            while (iter.hasNext()) {
                Object method = iter.next();
                if (!this.isValidMethod(method, arguments, coerce)) continue;
                matchingMethods.add(method);
            }
            if (matchingMethods.isEmpty()) {
                return null;
            }
            if (matchingMethods.size() == 1) {
                return matchingMethods.get(0);
            }
            return this.chooseMostSpecificParams(methodName, matchingMethods, arguments);
        }
        if (answer != null) {
            return answer;
        }
        throw new GroovyRuntimeException("Could not find which method to invoke from this list: " + methods + " for arguments: " + InvokerHelper.toString(arguments));
    }

    protected boolean isValidMethod(Object method, Class[] arguments, boolean includeCoerce) {
        Class[] paramTypes = this.getParameterTypes(method);
        return MetaClass.isValidMethod(paramTypes, arguments, includeCoerce);
    }

    public static boolean isValidMethod(Class[] paramTypes, Class[] arguments, boolean includeCoerce) {
        if (arguments == null) {
            return true;
        }
        int size = arguments.length;
        boolean validMethod = false;
        if (paramTypes.length == size) {
            validMethod = true;
            for (int i = 0; i < size; ++i) {
                if (MetaClass.isCompatibleClass(paramTypes[i], arguments[i], includeCoerce)) continue;
                validMethod = false;
            }
        } else if (paramTypes.length == 1 && size == 0) {
            return true;
        }
        return validMethod;
    }

    protected Object chooseMostSpecificParams(String name, List matchingMethods, Class[] arguments) {
        Object answer = null;
        int size = arguments.length;
        Class[] mostSpecificTypes = null;
        Iterator iter = matchingMethods.iterator();
        while (iter.hasNext()) {
            Object method = iter.next();
            Class[] paramTypes = this.getParameterTypes(method);
            if (answer == null) {
                answer = method;
                mostSpecificTypes = paramTypes;
                continue;
            }
            boolean useThisMethod = false;
            for (int i = 0; i < size; ++i) {
                Class mostSpecificType = mostSpecificTypes[i];
                Class type = paramTypes[i];
                if (this.isAssignableFrom(mostSpecificType, type)) continue;
                useThisMethod = true;
                break;
            }
            if (!useThisMethod) continue;
            if (size > 1) {
                this.checkForInvalidOverloading(name, mostSpecificTypes, paramTypes);
            }
            answer = method;
            mostSpecificTypes = paramTypes;
        }
        return answer;
    }

    protected void checkForInvalidOverloading(String name, Class[] baseTypes, Class[] derivedTypes) {
        int size = baseTypes.length;
        for (int i = 0; i < size; ++i) {
            Class derivedType = derivedTypes[i];
            Class baseType = baseTypes[i];
            if (this.isAssignableFrom(derivedType, baseType)) continue;
            throw new GroovyRuntimeException("Ambiguous method overloading for method: " + name + ". Cannot resolve which method to invoke due to overlapping prototypes between: " + InvokerHelper.toString(baseTypes) + " and: " + InvokerHelper.toString(derivedTypes));
        }
    }

    protected Class[] getParameterTypes(Object methodOrConstructor) {
        if (methodOrConstructor instanceof MetaMethod) {
            MetaMethod method = (MetaMethod)methodOrConstructor;
            return method.getParameterTypes();
        }
        if (methodOrConstructor instanceof Method) {
            Method method = (Method)methodOrConstructor;
            return method.getParameterTypes();
        }
        if (methodOrConstructor instanceof Constructor) {
            Constructor constructor = (Constructor)methodOrConstructor;
            return constructor.getParameterTypes();
        }
        throw new IllegalArgumentException("Must be a Method or Constructor");
    }

    protected Object chooseMostGeneralMethodWith1Param(List methods) {
        Class closestClass = null;
        Object answer = null;
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Object method = iter.next();
            Class[] paramTypes = this.getParameterTypes(method);
            int paramLength = paramTypes.length;
            if (paramLength != 1) continue;
            Class theType = paramTypes[0];
            if (closestClass != null && !this.isAssignableFrom(closestClass, theType)) continue;
            closestClass = theType;
            answer = method;
        }
        return answer;
    }

    protected Object chooseEmptyMethodParams(List methods) {
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Object method = iter.next();
            Class[] paramTypes = this.getParameterTypes(method);
            int paramLength = paramTypes.length;
            if (paramLength != 0) continue;
            return method;
        }
        return null;
    }

    protected static boolean isCompatibleInstance(Class type, Object value, boolean includeCoerce) {
        boolean answer;
        boolean bl = answer = value == null || type.isInstance(value);
        if (!answer) {
            if (type.isPrimitive()) {
                if (type == Integer.TYPE) {
                    return value instanceof Integer;
                }
                if (type == Double.TYPE) {
                    return value instanceof Double || value instanceof Float || value instanceof Integer || value instanceof BigDecimal;
                }
                if (type == Boolean.TYPE) {
                    return value instanceof Boolean;
                }
                if (type == Long.TYPE) {
                    return value instanceof Long || value instanceof Integer;
                }
                if (type == Float.TYPE) {
                    return value instanceof Float || value instanceof Integer;
                }
                if (type == Character.TYPE) {
                    return value instanceof Character;
                }
                if (type == Byte.TYPE) {
                    return value instanceof Byte;
                }
                if (type == Short.TYPE) {
                    return value instanceof Short;
                }
            } else {
                if (type.isArray() && value.getClass().isArray()) {
                    return MetaClass.isCompatibleClass(type.getComponentType(), value.getClass().getComponentType(), false);
                }
                if (includeCoerce) {
                    if (type == String.class && value instanceof GString) {
                        return true;
                    }
                    if (value instanceof Number) {
                        return Number.class.isAssignableFrom(type);
                    }
                }
            }
        }
        return answer;
    }

    protected static boolean isCompatibleClass(Class type, Class value, boolean includeCoerce) {
        boolean answer;
        boolean bl = answer = value == null || type.isAssignableFrom(value);
        if (!answer) {
            if (type.isPrimitive()) {
                if (type == Integer.TYPE) {
                    return value == Integer.class;
                }
                if (type == Double.TYPE) {
                    return value == Double.class || value == Float.class || value == Integer.class || value == BigDecimal.class;
                }
                if (type == Boolean.TYPE) {
                    return value == Boolean.class;
                }
                if (type == Long.TYPE) {
                    return value == Long.class || value == Integer.class;
                }
                if (type == Float.TYPE) {
                    return value == Float.class || value == Integer.class;
                }
                if (type == Character.TYPE) {
                    return value == Character.class;
                }
                if (type == Byte.TYPE) {
                    return value == Byte.class;
                }
                if (type == Short.TYPE) {
                    return value == Short.class;
                }
            } else {
                if (type.isArray() && value.isArray()) {
                    return MetaClass.isCompatibleClass(type.getComponentType(), value.getComponentType(), false);
                }
                if (includeCoerce) {
                    if (type == String.class && GString.class.isAssignableFrom(value)) {
                        return true;
                    }
                    if (value == Number.class) {
                        return Number.class.isAssignableFrom(type);
                    }
                }
            }
        }
        return answer;
    }

    protected boolean isAssignableFrom(Class mostSpecificType, Class type) {
        if (mostSpecificType.isPrimitive() && type.isPrimitive()) {
            if (mostSpecificType == type) {
                return true;
            }
            if (type == Integer.TYPE) {
                return mostSpecificType == Integer.TYPE || mostSpecificType == Short.TYPE || mostSpecificType == Byte.TYPE;
            }
            if (type == Double.TYPE) {
                return mostSpecificType == Double.TYPE || mostSpecificType == Integer.TYPE || mostSpecificType == Long.TYPE || mostSpecificType == Short.TYPE || mostSpecificType == Byte.TYPE || mostSpecificType == Float.TYPE;
            }
            if (type == Long.TYPE) {
                return mostSpecificType == Long.TYPE || mostSpecificType == Integer.TYPE || mostSpecificType == Short.TYPE || mostSpecificType == Byte.TYPE;
            }
            if (type == Float.TYPE) {
                return mostSpecificType == Float.TYPE || mostSpecificType == Integer.TYPE || mostSpecificType == Long.TYPE || mostSpecificType == Short.TYPE || mostSpecificType == Byte.TYPE;
            }
            if (type == Short.TYPE) {
                return mostSpecificType == Short.TYPE || mostSpecificType == Byte.TYPE;
            }
            return false;
        }
        boolean answer = type.isAssignableFrom(mostSpecificType);
        if (!answer) {
            answer = this.autoboxType(type).isAssignableFrom(this.autoboxType(mostSpecificType));
        }
        return answer;
    }

    private Class autoboxType(Class type) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Double.TYPE) {
                return Double.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type == Float.TYPE) {
                return Float.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
            if (type == Byte.TYPE) {
                return Byte.class;
            }
            if (type == Short.TYPE) {
                return Short.class;
            }
        }
        return type;
    }

    protected static boolean coerceGStrings(Object[] arguments) {
        boolean coerced = false;
        int size = arguments.length;
        for (int i = 0; i < size; ++i) {
            Object argument = arguments[i];
            if (!(argument instanceof GString)) continue;
            arguments[i] = argument.toString();
            coerced = true;
        }
        return coerced;
    }

    protected boolean isGenericSetMethod(MetaMethod method) {
        return method.getName().equals("set") && method.getParameterTypes().length == 2;
    }

    protected boolean isGenericGetMethod(MetaMethod method) {
        if (method.getName().equals("get")) {
            Class[] parameterTypes = method.getParameterTypes();
            return parameterTypes.length == 1 && parameterTypes[0] == String.class;
        }
        return false;
    }

    private void registerMethods(boolean instanceMethods) {
        Method[] methods = this.theClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] paramTypes;
            Method method = methods[i];
            if (!MethodHelper.isStatic(method) || (paramTypes = method.getParameterTypes()).length <= 0) continue;
            Class<?> owner = paramTypes[0];
            if (instanceMethods) {
                this.registry.lookup(owner).addNewInstanceMethod(method);
                continue;
            }
            this.registry.lookup(owner).addNewStaticMethod(method);
        }
    }

    protected void registerStaticMethods() {
        this.registerMethods(false);
    }

    protected void registerInstanceMethods() {
        this.registerMethods(true);
    }

    protected String capitalize(String property) {
        return property.substring(0, 1).toUpperCase() + property.substring(1, property.length());
    }

    protected synchronized void onMethodChange() {
        this.reflector = null;
    }

    protected synchronized void checkInitialised() {
        if (!this.initialised) {
            this.initialised = true;
            this.addInheritedMethods(this.theClass);
        }
        if (this.reflector == null) {
            this.generateReflector();
        }
    }

    protected MetaMethod createMetaMethod(final Method method) {
        if (this.registry.useAccessible()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    method.setAccessible(true);
                    return null;
                }
            });
        }
        if (useReflection) {
            return new ReflectionMetaMethod(method);
        }
        MetaMethod answer = new MetaMethod(method);
        if (this.isValidReflectorMethod(answer)) {
            this.allMethods.add(answer);
            answer.setMethodIndex(this.allMethods.size());
        } else {
            answer = new ReflectionMetaMethod(method);
        }
        return answer;
    }

    protected boolean isValidReflectorMethod(MetaMethod method) {
        if (!method.isPublic()) {
            return false;
        }
        Class declaringClass = method.getDeclaringClass();
        if (!Modifier.isPublic(declaringClass.getModifiers())) {
            List list = this.getInterfaceMethods();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                MetaMethod aMethod = (MetaMethod)iter.next();
                if (!method.isSame(aMethod)) continue;
                method.setInterfaceClass(aMethod.getDeclaringClass());
                return true;
            }
            return false;
        }
        return true;
    }

    protected void generateReflector() {
        this.reflector = this.loadReflector(this.allMethods);
        if (this.reflector == null) {
            throw new RuntimeException("Should have a reflector!");
        }
        Iterator iter = this.allMethods.iterator();
        while (iter.hasNext()) {
            MetaMethod metaMethod = (MetaMethod)iter.next();
            metaMethod.setReflector(this.reflector);
        }
    }

    protected Reflector loadReflector(List methods) {
        ReflectorGenerator generator = new ReflectorGenerator(methods);
        String className = this.theClass.getName();
        String packagePrefix = "gjdk.";
        String name = packagePrefix + className + "_GroovyReflector";
        if (this.theClass.isArray()) {
            String componentName = this.theClass.getComponentType().getName();
            name = packagePrefix + componentName + "_GroovyReflectorArray";
        }
        try {
            Class type = this.loadReflectorClass(name);
            return (Reflector)type.newInstance();
        }
        catch (AccessControlException ace) {
            throw ace;
        }
        catch (Exception e) {
            ClassWriter cw = new ClassWriter(true);
            generator.generate(cw, name);
            byte[] bytecode = cw.toByteArray();
            try {
                Class type = this.loadReflectorClass(name, bytecode);
                return (Reflector)type.newInstance();
            }
            catch (Exception e2) {
                throw new GroovyRuntimeException("Could not load the reflector for class: " + name + ". Reason: " + e2, e2);
            }
        }
    }

    protected Class loadReflectorClass(final String name, final byte[] bytecode) throws ClassNotFoundException {
        ClassLoader loader = this.theClass.getClassLoader();
        if (loader instanceof GroovyClassLoader) {
            final GroovyClassLoader gloader = (GroovyClassLoader)loader;
            return (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return gloader.defineClass(name, bytecode, this.getClass().getProtectionDomain());
                }
            });
        }
        return this.registry.loadClass(name, bytecode);
    }

    protected Class loadReflectorClass(String name) throws ClassNotFoundException {
        ClassLoader loader = this.theClass.getClassLoader();
        if (loader instanceof GroovyClassLoader) {
            GroovyClassLoader gloader = (GroovyClassLoader)loader;
            return gloader.loadClass(name);
        }
        return this.registry.loadClass(name);
    }

    public List getMethods() {
        return this.allMethods;
    }

    public List getMetaMethods() {
        return (List)((ArrayList)this.newGroovyMethodsList).clone();
    }

    protected synchronized List getInterfaceMethods() {
        if (this.interfaceMethods == null) {
            this.interfaceMethods = new ArrayList();
            for (Class type = this.theClass; type != null; type = type.getSuperclass()) {
                Class<?>[] interfaces = type.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    Class<?> iface = interfaces[i];
                    Method[] methods = iface.getMethods();
                    this.addInterfaceMethods(this.interfaceMethods, methods);
                }
            }
        }
        return this.interfaceMethods;
    }

    private void addInterfaceMethods(List list, Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            list.add(this.createMetaMethod(methods[i]));
        }
    }

    Class[] convertToTypeArray(Object[] args) {
        if (args == null) {
            return null;
        }
        int s = args.length;
        Class[] ans = new Class[s];
        for (int i = 0; i < s; ++i) {
            Object o = args[i];
            ans[i] = o != null ? o.getClass() : null;
        }
        return ans;
    }
}

