/*
 * Decompiled with CFR 0.152.
 */
package wogroovy;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver._private.WODirectActionRequestHandler;
import com.webobjects.appserver._private.WOProjectBundle;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation._NSStringUtilities;
import er.extensions.ERXLogger;
import er.extensions.ERXModelGroup;
import er.extensions.ERXPatcher;
import er.extensions.ERXProperties;
import er.extensions.ERXWOContext;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import org.codehaus.groovy.control.CompilerConfiguration;

public class WOGroovyCompilerProxy {
    protected static final ERXLogger log = ERXLogger.getERXLogger((String)(class$wogroovy$WOGroovyCompilerProxy == null ? (class$wogroovy$WOGroovyCompilerProxy = WOGroovyCompilerProxy.class$("wogroovy.WOGroovyCompilerProxy")) : class$wogroovy$WOGroovyCompilerProxy).getName());
    protected static final ERXLogger classLoaderLog = ERXLogger.getERXLogger((String)((class$wogroovy$WOGroovyCompilerProxy == null ? (class$wogroovy$WOGroovyCompilerProxy = WOGroovyCompilerProxy.class$("wogroovy.WOGroovyCompilerProxy")) : class$wogroovy$WOGroovyCompilerProxy).getName() + ".loading"));
    public static final String CompilerProxyDidCompileClassesNotification = "WOGroovyCompilerProxyDidCompileClasses";
    protected static final String CPFileList = "CPFileList.txt";
    protected static String _jikesPath = "/usr/bin/jikes";
    protected static WOGroovyCompilerProxy _defaultProxy;
    protected static String _classPath;
    protected static boolean _raiseOnError;
    protected boolean initialized = false;
    protected NSMutableDictionary _filesToWatch;
    protected String _className;
    protected String _destinationPath;
    protected NSMutableSet classFiles = new NSMutableSet();
    protected NSArray _projectSearchPath = ERXProperties.arrayForKeyWithDefault((String)"NSProjectSearchPath", (NSArray)NSArray.EmptyArray);
    CompilerClassLoader activeLoader = null;
    static /* synthetic */ Class class$wogroovy$WOGroovyCompilerProxy;
    static /* synthetic */ Class class$com$webobjects$foundation$NSNotification;
    static /* synthetic */ Class class$com$webobjects$appserver$WODirectAction;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$webobjects$appserver$WOComponent;
    static /* synthetic */ Class class$com$webobjects$eocontrol$EOEnterpriseObject;

    public static WOGroovyCompilerProxy defaultProxy() {
        if (_defaultProxy == null) {
            _defaultProxy = new WOGroovyCompilerProxy();
        }
        return _defaultProxy;
    }

    public static void setDefaultProxy(WOGroovyCompilerProxy p) {
        if (_defaultProxy != null) {
            NSNotificationCenter.defaultCenter().removeObserver((Object)_defaultProxy);
        }
        _defaultProxy = p;
        _defaultProxy.initialize();
    }

    protected String pathForCPFileList(String directory) {
        return directory + File.separator + CPFileList;
    }

    public String projectInSearchPath(String bundleName) {
        Enumeration e = this._projectSearchPath.objectEnumerator();
        while (e.hasMoreElements()) {
            String path = e.nextElement() + File.separator + bundleName;
            if (!new File(this.pathForCPFileList(path)).exists()) continue;
            return path;
        }
        return null;
    }

    protected NSArray projectPaths() {
        NSArray frameworkNames = (NSArray)NSBundle.frameworkBundles().valueForKey("name");
        NSMutableArray projectPaths = new NSMutableArray();
        String mainProject = null;
        String mainBundleName = NSBundle.mainBundle().name();
        WOProjectBundle mainBundle = WOProjectBundle.projectBundleForProject((String)mainBundleName, (boolean)false);
        if (mainBundle == null) {
            mainProject = this.projectInSearchPath(mainBundleName);
            if (mainProject == null) {
                mainProject = "../..";
            }
        } else {
            mainProject = mainBundle.projectPath();
        }
        if (mainProject == null || mainProject.equals("")) {
            mainProject = new File(mainBundle.bundlePath()).getParentFile().getParentFile().getAbsolutePath();
        }
        if (new File(this.pathForCPFileList(mainProject)).exists()) {
            log.info((Object)("Found open project for app at path " + mainProject));
            projectPaths.addObject((Object)mainProject);
        }
        Enumeration e = frameworkNames.objectEnumerator();
        while (e.hasMoreElements()) {
            File f;
            String path;
            String name = (String)e.nextElement();
            WOProjectBundle bundle = WOProjectBundle.projectBundleForProject((String)name, (boolean)true);
            if (bundle != null) {
                path = bundle.projectPath();
                if (path == null || path.equals("")) {
                    path = new File(bundle.bundlePath()).getParentFile().getParentFile().getAbsolutePath();
                }
            } else {
                path = this.projectInSearchPath(name);
            }
            if (path == null || !(f = new File(this.pathForCPFileList(path))).exists()) continue;
            log.info((Object)("Found open project for framework '" + name + "' at path " + path));
            projectPaths.addObject((Object)path);
        }
        return projectPaths;
    }

    public Class classForName(String className) {
        return ERXPatcher.classForName((String)className);
    }

    public void setClassForName(Class clazz, String className) {
        ERXPatcher.setClassForName((Class)clazz, (String)className);
    }

    public void initialize() {
        NSBundle b;
        String path;
        boolean isWindows;
        if (this.initialized) {
            return;
        }
        log.info((Object)"initialize start");
        this.initialized = true;
        if (WOApplication.application() != null && WOApplication.application().isCachingEnabled()) {
            log.info((Object)"I assume this is deployment mode, rapid-turnaround mode is disabled");
            this._filesToWatch = new NSMutableDictionary();
            return;
        }
        if (!ERXProperties.booleanForKeyWithDefault((String)"wogroovy.WOGroovyCompilerProxyEnabled", (boolean)false)) {
            log.info((Object)"Rapid-turnaround mode is disabled, set 'wogroovy.WOGroovyCompilerProxyEnabled=true' in your WebObjects.properties to enable it.");
            this._filesToWatch = new NSMutableDictionary();
            return;
        }
        boolean bl = isWindows = File.pathSeparatorChar == ';';
        if (isWindows) {
            _jikesPath = System.getProperty("NEXT_ROOT") + "/Local/Library/Executables/jikes.exe";
        }
        if (!new File(_jikesPath).exists()) {
            log.error((Object)("Can't use compiler proxy, no jikes found at path :<" + _jikesPath + ">"));
            return;
        }
        String classPathSeparator = ":";
        if (isWindows) {
            classPathSeparator = ";";
        }
        _classPath = System.getProperty("com.webobjects.classpath");
        _raiseOnError = ERXProperties.booleanForKey((String)"CPRaiseOnError");
        NSArray projectPaths = this.projectPaths();
        if (projectPaths.count() == 0) {
            log.info((Object)"No open projects found with a CPFileList.txt");
            this._filesToWatch = new NSMutableDictionary();
            return;
        }
        if (_classPath.indexOf(".woa") == -1) {
            log.info((Object)"Sorry, can't find the .woa wrapper of this application. There is no support for the CompilerProxy in servlet deployment, will try to get it via NSBundle.");
            log.info((Object)("java.class.path=" + _classPath));
        }
        if ((path = (b = NSBundle.mainBundle()).resourcePath()).indexOf(".woa") == -1) {
            log.info((Object)"Sorry, can't find the .woa wrapper of this application. There is no support for the CompilerProxy in servlet deployment.");
            log.info((Object)("mainBundle.resourcePath=" + path));
        }
        this._destinationPath = path.substring(0, path.indexOf(".woa")) + ".woa/Contents/Resources/Java/";
        this._filesToWatch = new NSMutableDictionary();
        Enumeration e = projectPaths.objectEnumerator();
        while (e.hasMoreElements()) {
            String sourcePath = (String)e.nextElement();
            String fileListPath = this.pathForCPFileList(sourcePath);
            String fileList = _NSStringUtilities.stringFromFile((String)fileListPath, (String)"US-ASCII");
            NSArray allFiles = NSArray.componentsSeparatedByString((String)fileList, (String)"\n");
            Enumeration sourceFiles = allFiles.objectEnumerator();
            while (sourceFiles.hasMoreElements()) {
                String line = (String)sourceFiles.nextElement();
                line = line.trim();
                String packageName = "";
                String sourceName = "";
                StringBuffer groovyName = null;
                try {
                    NSArray items = NSArray.componentsSeparatedByString((String)line, (String)":");
                    if (items.count() <= 1) continue;
                    groovyName = new StringBuffer((String)items.objectAtIndex(0));
                    if (groovyName.toString().endsWith(".java")) {
                        groovyName.replace(groovyName.length() - 4, groovyName.length(), "groovy");
                        sourceName = groovyName.toString();
                    } else {
                        sourceName = (String)items.objectAtIndex(0);
                    }
                    packageName = (String)items.objectAtIndex(1);
                    CacheEntry entry = new CacheEntry(sourcePath, sourceName, packageName);
                    this._filesToWatch.setObjectForKey((Object)entry, (Object)entry.classNameWithPackage());
                    if (entry.classFile() != null) {
                        this.classFiles.addObject((Object)entry);
                    }
                    if (!WOApplication.application().isDebuggingEnabled()) continue;
                    log.debug((Object)("fileToWatch:" + entry.classNameWithPackage()));
                }
                catch (Exception ex) {
                    log.debug((Object)("initializeOnNotification: error parsing " + fileListPath + " line '" + line + "':" + ex));
                }
            }
        }
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("checkAndCompileOnNotification", new Class[]{class$com$webobjects$foundation$NSNotification == null ? (class$com$webobjects$foundation$NSNotification = WOGroovyCompilerProxy.class$("com.webobjects.foundation.NSNotification")) : class$com$webobjects$foundation$NSNotification}), "ApplicationWillDispatchRequestNotification", null);
        log.info((Object)"initialize end");
    }

    public void checkAndCompileOnNotification(NSNotification theNotification) {
        WORequest r = (WORequest)theNotification.object();
        String key = "/" + WOApplication.application().resourceRequestHandlerKey();
        if (r.uri().indexOf(key) <= 0) {
            this.checkAndCompileAllClasses();
        }
    }

    void checkAndCompileAllClasses() {
        Compiler compiler;
        CacheEntry cacheEntry;
        Enumeration e = this._filesToWatch.objectEnumerator();
        NSMutableArray filesToCompile = new NSMutableArray();
        while (e.hasMoreElements()) {
            cacheEntry = (CacheEntry)e.nextElement();
            if (!cacheEntry.needsRefresh()) continue;
            filesToCompile.addObject((Object)cacheEntry);
        }
        if (filesToCompile.count() > 0 && (compiler = new Compiler(filesToCompile.objects(), this._destinationPath)).compile()) {
            e = filesToCompile.objectEnumerator();
            log.debug((Object)("after compile: classFiles=" + this.classFiles));
            while (e.hasMoreElements()) {
                cacheEntry = (CacheEntry)e.nextElement();
                this.classFiles.addObject((Object)cacheEntry);
            }
            boolean didReset = false;
            boolean didResetModelGroup = false;
            CompilerClassLoader cl = null;
            log.debug((Object)("classFiles=" + this.classFiles));
            e = this.classFiles.objectEnumerator();
            NSMutableDictionary kvcAccessors = new NSMutableDictionary();
            while (e.hasMoreElements()) {
                cacheEntry = (CacheEntry)e.nextElement();
                String className = cacheEntry.classNameWithPackage();
                try {
                    if (cl == null) {
                        cl = new CompilerClassLoader(this._destinationPath, this.activeLoader);
                    }
                    Class class_ = cl.loadClass(className, true);
                    Class oldClass_ = ERXPatcher.classForName((String)cacheEntry.className());
                    ERXPatcher.setClassForName((Class)class_, (String)className);
                    if (oldClass_ != null && !cacheEntry.className().equals(className)) {
                        ERXPatcher.setClassForName((Class)class_, (String)cacheEntry.className());
                    }
                    if (!didReset) {
                        WOApplication.application()._removeComponentDefinitionCacheContents();
                        NSKeyValueCoding.DefaultImplementation._flushCaches();
                        NSKeyValueCoding._ReflectionKeyBindingCreation._flushCaches();
                        NSKeyValueCoding.ValueAccessor._flushCaches();
                        didReset = true;
                    }
                    if (cacheEntry.packageName().length() > 0) {
                        // empty if block
                    }
                    if ((class$com$webobjects$appserver$WODirectAction == null ? WOGroovyCompilerProxy.class$("com.webobjects.appserver.WODirectAction") : class$com$webobjects$appserver$WODirectAction).isAssignableFrom(class_)) {
                        WOApplication app = WOApplication.application();
                        WORequestHandler currentDAHandler = app.requestHandlerForKey(app.directActionRequestHandlerKey());
                        WODirectActionRequestHandler handler = null;
                        try {
                            Class[] paramArray = new Class[]{class$java$lang$String == null ? WOGroovyCompilerProxy.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? WOGroovyCompilerProxy.class$("java.lang.String") : class$java$lang$String, Boolean.TYPE};
                            Constructor<?> constructor = currentDAHandler.getClass().getConstructor(paramArray);
                            handler = (WODirectActionRequestHandler)constructor.newInstance(cacheEntry.className(), "default", Boolean.FALSE);
                        }
                        catch (Exception ex) {
                            log.error((Object)("Failed to instantiate DA Handler: " + ex));
                        }
                        boolean directActionIsDefault = currentDAHandler == app.defaultRequestHandler();
                        app.registerRequestHandler(handler, app.directActionRequestHandlerKey());
                        if (directActionIsDefault) {
                            app.setDefaultRequestHandler(handler);
                        }
                        log.info((Object)("WODirectAction loaded: " + cacheEntry.className()));
                    }
                    if ((class$com$webobjects$appserver$WOComponent == null ? WOGroovyCompilerProxy.class$("com.webobjects.appserver.WOComponent") : class$com$webobjects$appserver$WOComponent).isAssignableFrom(class_)) {
                        WOContext context = ERXWOContext.newContext();
                        WOApplication.application().pageWithName(cacheEntry.className(), context)._componentDefinition().componentInstanceInContext(context);
                    }
                    if ((class$com$webobjects$eocontrol$EOEnterpriseObject == null ? WOGroovyCompilerProxy.class$("com.webobjects.eocontrol.EOEnterpriseObject") : class$com$webobjects$eocontrol$EOEnterpriseObject).isAssignableFrom(class_) && !didResetModelGroup) {
                        EOModelGroup.setDefaultGroup((EOModelGroup)ERXModelGroup.modelGroupForLoadedBundles());
                        didResetModelGroup = true;
                    }
                    if ((class$wogroovy$WOGroovyCompilerProxy == null ? WOGroovyCompilerProxy.class$("wogroovy.WOGroovyCompilerProxy") : class$wogroovy$WOGroovyCompilerProxy).getName().equals(className)) {
                        try {
                            WOGroovyCompilerProxy.setDefaultProxy((WOGroovyCompilerProxy)class_.newInstance());
                        }
                        catch (Exception ex) {
                            log.error((Object)"Can't reload compiler proxy", (Throwable)ex);
                        }
                    }
                    cacheEntry.update();
                }
                catch (InstantiationException ex) {
                    log.debug((Object)("Can't load " + className + ", it's probably abstract."));
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException("Could not load the class " + className + " with exception:" + ex.toString());
                }
            }
            NSNotificationCenter.defaultCenter().postNotification(CompilerProxyDidCompileClassesNotification, (Object)this.classFiles);
        }
    }

    public static boolean isClassContainedBySet(String classNameWithPackage, NSSet cacheEntries) {
        boolean isContained = false;
        Enumeration e = cacheEntries.objectEnumerator();
        while (e.hasMoreElements()) {
            CacheEntry cacheEntry = (CacheEntry)e.nextElement();
            if (!cacheEntry.classNameWithPackage().equals(classNameWithPackage)) continue;
            isContained = true;
            break;
        }
        return isContained;
    }

    private static URL[] mangleClasspathForClassLoader(String s) {
        String s1 = File.pathSeparatorChar != ';' ? "file://" : "file:///";
        NSArray paths = NSArray.componentsSeparatedByString((String)_classPath, (String)":");
        URL[] aurl = new URL[paths.count()];
        for (int i = 0; i < paths.count(); ++i) {
            try {
                aurl[i] = new URL(s1 + paths.objectAtIndex(i).toString());
                continue;
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Error creating URL " + throwable);
            }
        }
        return aurl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _raiseOnError = false;
        System.out.println("ok, loaded");
    }

    class CompilerClassLoader
    extends GroovyClassLoader {
        protected String _classpath;
        protected String _destinationPath;
        protected CompilerClassLoader _parent;

        public CompilerClassLoader(String destinationPath, CompilerClassLoader parent) {
            this._destinationPath = destinationPath;
            this._parent = parent;
            WOGroovyCompilerProxy.this.activeLoader = this;
        }

        public synchronized Class loadClass(String name, boolean resolveIt) throws ClassNotFoundException {
            try {
                return this.findClass(name);
            }
            catch (ClassNotFoundException ex) {
                if (this._parent == null) {
                    return super.loadClass(name, resolveIt);
                }
                return this._parent.loadClass(name, resolveIt);
            }
        }

        public File findClassFile(String name) {
            String fileName = name.replace('.', File.separatorChar) + ".class";
            File f = new File(this._destinationPath + File.separatorChar + fileName);
            if (f.exists() && f.isFile() && f.canRead()) {
                classLoaderLog.debug((Object)("CompilerClassLoader.findClassFile:" + name + " found"));
                return f;
            }
            classLoaderLog.debug((Object)("CompilerClassLoader.findClassFile:" + this._destinationPath + File.separatorChar + fileName + " NOT found"));
            return null;
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            boolean contains = false;
            Enumeration e = WOGroovyCompilerProxy.this.classFiles.objectEnumerator();
            while (e.hasMoreElements()) {
                CacheEntry ce = (CacheEntry)e.nextElement();
                if (!name.startsWith(ce.classNameWithPackage())) continue;
                classLoaderLog.debug((Object)("CompilerClassLoader.findClass:" + name + " is in array"));
                contains = true;
                break;
            }
            if (contains) {
                Class newClass;
                byte[] buffer = null;
                File classFile = this.findClassFile(name);
                if (classFile == null) {
                    throw new ClassNotFoundException(name);
                }
                try {
                    FileInputStream in = new FileInputStream(classFile);
                    int length = in.available();
                    if (length == 0) {
                        throw new ClassNotFoundException(name);
                    }
                    buffer = new byte[length];
                    in.read(buffer);
                    in.close();
                }
                catch (IOException iox) {
                    classLoaderLog.debug((Object)iox);
                    throw new ClassNotFoundException(iox.getMessage());
                }
                try {
                    newClass = this.defineClass(name, buffer, 0, buffer.length);
                    classLoaderLog.info((Object)("Did load class: " + name));
                }
                catch (Throwable t) {
                    classLoaderLog.debug((Object)t);
                    throw new RuntimeException(t.getMessage());
                }
                return newClass;
            }
            Class<?> clazz = null;
            clazz = Class.forName(name);
            if (clazz != null) {
                return clazz;
            }
            throw new IllegalStateException("could not get class " + name + " with classForName method!");
        }

        public URL getResource(String name) {
            return ClassLoader.getSystemResource(name);
        }

        public Class reloadClass(String className) {
            Class c = null;
            try {
                byte[] buffer = null;
                String fileName = className.replace('.', '/') + ".class";
                InputStream in = null;
                File classFile = this.findClassFile(className);
                in = classFile != null ? new FileInputStream(classFile) : this.getResource(fileName).openStream();
                int length = in.available();
                if (length != 0) {
                    buffer = new byte[length];
                    in.read(buffer);
                    in.close();
                }
                if (buffer != null) {
                    log.info((Object)(className + ":" + buffer.length + "," + buffer));
                    c = this.defineClass(className, buffer, 0, buffer.length);
                }
            }
            catch (Throwable t) {
                log.warn((Object)("Error reloading class " + className + ": " + t));
            }
            return c;
        }
    }

    class Compiler {
        Object[] _files;
        String _destinationPath;

        public Compiler(Object[] files, String destinationPath) {
            this._destinationPath = destinationPath;
            this._files = files;
        }

        String[] commandArray() {
            int i;
            String[] base = new String[]{_jikesPath, "+E", "-g", "-d", this._destinationPath, "-classpath", this._destinationPath + ":" + _classPath};
            String[] commandLine = new String[base.length + this._files.length];
            for (i = 0; i < base.length; ++i) {
                commandLine[i] = base[i];
            }
            for (i = base.length; i < base.length + this._files.length; ++i) {
                commandLine[i] = ((CacheEntry)this._files[i - base.length]).path();
            }
            return commandLine;
        }

        String commandLine() {
            int i;
            String[] base = new String[]{_jikesPath, "+E", "-g", "-d", this._destinationPath, "-classpath", this._destinationPath + ":" + _classPath};
            String commandLine = "";
            for (i = 0; i < base.length; ++i) {
                commandLine = commandLine + " " + base[i];
            }
            for (i = base.length; i < base.length + this._files.length; ++i) {
                commandLine = commandLine + " " + ((CacheEntry)this._files[i - base.length]).path();
            }
            return commandLine;
        }

        public boolean compile() throws IllegalArgumentException {
            try {
                CompilerConfiguration config = new CompilerConfiguration();
                config.setTargetDirectory(this._destinationPath);
                org.codehaus.groovy.tools.Compiler compiler = new org.codehaus.groovy.tools.Compiler(config);
                for (int i = 0; i < this._files.length; ++i) {
                    compiler.compile(new File(((CacheEntry)this._files[i]).path()));
                }
            }
            catch (Exception e) {
                if (_raiseOnError) {
                    throw new RuntimeException("Groovy returned an error: " + e.toString());
                }
                log.error((Object)e.toString());
                return false;
            }
            return true;
        }
    }

    class CacheEntry {
        String _path;
        String _className;
        String _packageName;
        long _lastModified;
        File _sourceFile;
        File _classFile;

        public CacheEntry(String basePath, String path, String packageName) {
            this._className = NSPathUtilities.lastPathComponent((String)path);
            this._className = this._className.substring(0, this._className.indexOf("."));
            this._path = path.startsWith("/") ? path : basePath + "/" + path;
            this._sourceFile = new File(this._path);
            this._packageName = packageName;
            this._lastModified = this._sourceFile.lastModified();
        }

        public void update() {
            this._lastModified = this._sourceFile.lastModified();
        }

        public File classFile() {
            String fileName = this._className.replace('.', File.separatorChar) + ".class";
            File f = new File(WOGroovyCompilerProxy.this._destinationPath + File.separatorChar + fileName);
            if (f.exists() && f.isFile() && f.canRead()) {
                return f;
            }
            return null;
        }

        public String className() {
            return this._className;
        }

        public String classNameWithPackage() {
            if (this._packageName.length() == 0) {
                return this._className;
            }
            return this._packageName + "." + this._className;
        }

        public String path() {
            return this._path;
        }

        public String packageName() {
            return this._packageName;
        }

        public boolean needsRefresh() {
            if (this._sourceFile.exists()) {
                if (this.classFile() != null && this.classFile().lastModified() < this._sourceFile.lastModified()) {
                    return true;
                }
                if (this._lastModified < this._sourceFile.lastModified()) {
                    return true;
                }
            }
            return false;
        }

        public void didRefresh() {
            this._lastModified = this._sourceFile.lastModified();
            log.info((Object)("Did refresh " + this._path));
        }

        public String toString() {
            return "( className = '" + this._className + "'; path = '" + this._path + "';)\n";
        }
    }
}

