/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import java.io.IOException;
import java.io.InputStream;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class ClassReader {
    public final byte[] b;
    private int[] items;
    private String[] strings;
    private int maxStringLength;
    private int header;

    public ClassReader(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ClassReader(byte[] byArray, int n, int n2) {
        this.b = byArray;
        this.items = new int[this.readUnsignedShort(n + 8)];
        this.strings = new String[this.items.length];
        int n3 = 0;
        int n4 = n + 10;
        for (int i = 1; i < this.items.length; ++i) {
            int n5;
            this.items[i] = n4 + 1;
            byte by = byArray[n4];
            switch (by) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n5 = 5;
                    break;
                }
                case 5: 
                case 6: {
                    n5 = 9;
                    ++i;
                    break;
                }
                case 1: {
                    n5 = 3 + this.readUnsignedShort(n4 + 1);
                    n3 = n5 > n3 ? n5 : n3;
                    break;
                }
                default: {
                    n5 = 3;
                }
            }
            n4 += n5;
        }
        this.maxStringLength = n3;
        this.header = n4;
    }

    public ClassReader(InputStream inputStream) throws IOException {
        this(ClassReader.readClass(inputStream));
    }

    public ClassReader(String string) throws IOException {
        this(ClassLoader.getSystemResourceAsStream(string.replace('.', '/') + ".class"));
    }

    private static byte[] readClass(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("Class not found");
        }
        byte[] byArray = new byte[inputStream.available()];
        int n = 0;
        while (true) {
            byte[] byArray2;
            int n2;
            if ((n2 = inputStream.read(byArray, n, byArray.length - n)) == -1) {
                if (n < byArray.length) {
                    byArray2 = new byte[n];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    byArray = byArray2;
                }
                return byArray;
            }
            if ((n += n2) != byArray.length) continue;
            byArray2 = new byte[byArray.length + 1000];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byArray = byArray2;
        }
    }

    public int[] getVersion() {
        return new int[]{this.readShort(6), this.readShort(4)};
    }

    public void accept(ClassVisitor classVisitor, boolean bl) {
        this.accept(classVisitor, new Attribute[0], bl);
    }

    public void accept(ClassVisitor classVisitor, Attribute[] attributeArray, boolean bl) {
        String[] stringArray;
        Attribute attribute;
        String string;
        Attribute attribute2;
        String string2;
        int n;
        int n2;
        byte[] byArray = this.b;
        char[] cArray = new char[this.maxStringLength];
        int n3 = this.header;
        int n4 = this.readUnsignedShort(n3);
        String string3 = this.readClass(n3 + 2, cArray);
        int n5 = this.items[this.readUnsignedShort(n3 + 4)];
        String string4 = n5 == 0 ? null : this.readUTF8(n5, cArray);
        String[] stringArray2 = new String[this.readUnsignedShort(n3 + 6)];
        String string5 = null;
        Attribute attribute3 = null;
        int n6 = 0;
        n3 += 8;
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            stringArray2[n2] = this.readClass(n3, cArray);
            n3 += 2;
        }
        n5 = n3;
        n2 = this.readUnsignedShort(n5);
        n5 += 2;
        while (n2 > 0) {
            n = this.readUnsignedShort(n5 + 6);
            n5 += 8;
            while (n > 0) {
                n5 += 6 + this.readInt(n5 + 2);
                --n;
            }
            --n2;
        }
        n2 = this.readUnsignedShort(n5);
        n5 += 2;
        while (n2 > 0) {
            n = this.readUnsignedShort(n5 + 6);
            n5 += 8;
            while (n > 0) {
                n5 += 6 + this.readInt(n5 + 2);
                --n;
            }
            --n2;
        }
        n2 = this.readUnsignedShort(n5);
        n5 += 2;
        while (n2 > 0) {
            string2 = this.readUTF8(n5, cArray);
            if (string2.equals("SourceFile")) {
                string5 = this.readUTF8(n5 + 6, cArray);
            } else if (string2.equals("Deprecated")) {
                n4 |= 0x20000;
            } else if (string2.equals("Synthetic")) {
                n4 |= 0x1000;
            } else if (string2.equals("InnerClasses")) {
                n6 = n5 + 6;
            } else {
                attribute2 = this.readAttribute(attributeArray, string2, n5 + 6, this.readInt(n5 + 2), cArray, -1, null);
                if (attribute2 != null) {
                    attribute2.next = attribute3;
                    attribute3 = attribute2;
                }
            }
            n5 += 6 + this.readInt(n5 + 2);
            --n2;
        }
        classVisitor.visit(n4, string3, string4, stringArray2, string5);
        if (n6 != 0) {
            n2 = this.readUnsignedShort(n6);
            n6 += 2;
            while (n2 > 0) {
                classVisitor.visitInnerClass(this.readUnsignedShort(n6) == 0 ? null : this.readClass(n6, cArray), this.readUnsignedShort(n6 + 2) == 0 ? null : this.readClass(n6 + 2, cArray), this.readUnsignedShort(n6 + 4) == 0 ? null : this.readUTF8(n6 + 4, cArray), this.readUnsignedShort(n6 + 6));
                n6 += 8;
                --n2;
            }
        }
        n2 = this.readUnsignedShort(n3);
        n3 += 2;
        while (n2 > 0) {
            n4 = this.readUnsignedShort(n3);
            string2 = this.readUTF8(n3 + 2, cArray);
            string = this.readUTF8(n3 + 4, cArray);
            attribute = null;
            int n7 = 0;
            n = this.readUnsignedShort(n3 + 6);
            n3 += 8;
            while (n > 0) {
                stringArray = this.readUTF8(n3, cArray);
                if (stringArray.equals("ConstantValue")) {
                    n7 = this.readUnsignedShort(n3 + 6);
                } else if (stringArray.equals("Synthetic")) {
                    n4 |= 0x1000;
                } else if (stringArray.equals("Deprecated")) {
                    n4 |= 0x20000;
                } else {
                    attribute2 = this.readAttribute(attributeArray, (String)stringArray, n3 + 6, this.readInt(n3 + 2), cArray, -1, null);
                    if (attribute2 != null) {
                        attribute2.next = attribute;
                        attribute = attribute2;
                    }
                }
                n3 += 6 + this.readInt(n3 + 2);
                --n;
            }
            stringArray = n7 == 0 ? null : this.readConst(n7, cArray);
            classVisitor.visitField(n4, string2, string, stringArray, attribute);
            --n2;
        }
        n2 = this.readUnsignedShort(n3);
        n3 += 2;
        while (n2 > 0) {
            n4 = this.readUnsignedShort(n3);
            string2 = this.readUTF8(n3 + 2, cArray);
            string = this.readUTF8(n3 + 4, cArray);
            attribute = null;
            Attribute attribute4 = null;
            n5 = 0;
            n6 = 0;
            n = this.readUnsignedShort(n3 + 6);
            n3 += 8;
            while (n > 0) {
                stringArray = this.readUTF8(n3, cArray);
                int n8 = this.readInt(n3 += 2);
                n3 += 4;
                if (stringArray.equals("Code")) {
                    n5 = n3;
                } else if (stringArray.equals("Exceptions")) {
                    n6 = n3;
                } else if (stringArray.equals("Synthetic")) {
                    n4 |= 0x1000;
                } else if (stringArray.equals("Deprecated")) {
                    n4 |= 0x20000;
                } else {
                    attribute2 = this.readAttribute(attributeArray, (String)stringArray, n3, n8, cArray, -1, null);
                    if (attribute2 != null) {
                        attribute2.next = attribute;
                        attribute = attribute2;
                    }
                }
                n3 += n8;
                --n;
            }
            if (n6 == 0) {
                stringArray = null;
            } else {
                stringArray = new String[this.readUnsignedShort(n6)];
                n6 += 2;
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray[n] = this.readClass(n6, cArray);
                    n6 += 2;
                }
            }
            CodeVisitor codeVisitor = classVisitor.visitMethod(n4, string2, string, stringArray, attribute);
            if (codeVisitor != null && n5 != 0) {
                int n9;
                int n10;
                int n11 = this.readUnsignedShort(n5);
                int n12 = this.readUnsignedShort(n5 + 2);
                int n13 = this.readInt(n5 + 4);
                int n14 = n5 += 8;
                int n15 = n5 + n13;
                Label[] labelArray = new Label[n13 + 1];
                block40: while (n5 < n15) {
                    int n16 = byArray[n5] & 0xFF;
                    switch (ClassWriter.TYPE[n16]) {
                        case 0: 
                        case 4: {
                            ++n5;
                            continue block40;
                        }
                        case 8: {
                            n10 = n5 - n14 + this.readShort(n5 + 1);
                            if (labelArray[n10] == null) {
                                labelArray[n10] = new Label();
                            }
                            n5 += 3;
                            continue block40;
                        }
                        case 9: {
                            n10 = n5 - n14 + this.readInt(n5 + 1);
                            if (labelArray[n10] == null) {
                                labelArray[n10] = new Label();
                            }
                            n5 += 5;
                            continue block40;
                        }
                        case 16: {
                            n16 = byArray[n5 + 1] & 0xFF;
                            if (n16 == 132) {
                                n5 += 6;
                                continue block40;
                            }
                            n5 += 4;
                            continue block40;
                        }
                        case 13: {
                            n6 = n5 - n14;
                            n5 = n5 + 4 - (n6 & 3);
                            n10 = n6 + this.readInt(n5);
                            n5 += 4;
                            if (labelArray[n10] == null) {
                                labelArray[n10] = new Label();
                            }
                            n = this.readInt(n5);
                            n5 += 4;
                            for (n = this.readInt(n5 += 4) - n + 1; n > 0; --n) {
                                n10 = n6 + this.readInt(n5);
                                n5 += 4;
                                if (labelArray[n10] != null) continue;
                                labelArray[n10] = new Label();
                            }
                            continue block40;
                        }
                        case 14: {
                            n6 = n5 - n14;
                            n5 = n5 + 4 - (n6 & 3);
                            n10 = n6 + this.readInt(n5);
                            n5 += 4;
                            if (labelArray[n10] == null) {
                                labelArray[n10] = new Label();
                            }
                            n = this.readInt(n5);
                            n5 += 4;
                            while (n > 0) {
                                n10 = n6 + this.readInt(n5 += 4);
                                n5 += 4;
                                if (labelArray[n10] == null) {
                                    labelArray[n10] = new Label();
                                }
                                --n;
                            }
                            continue block40;
                        }
                        case 1: 
                        case 3: 
                        case 10: {
                            n5 += 2;
                            continue block40;
                        }
                        case 2: 
                        case 5: 
                        case 6: 
                        case 11: 
                        case 12: {
                            n5 += 3;
                            continue block40;
                        }
                        case 7: {
                            n5 += 5;
                            continue block40;
                        }
                    }
                    n5 += 4;
                }
                n = this.readUnsignedShort(n5);
                n5 += 2;
                while (n > 0) {
                    n10 = this.readUnsignedShort(n5);
                    if (labelArray[n10] == null) {
                        labelArray[n10] = new Label();
                    }
                    if (labelArray[n10 = this.readUnsignedShort(n5 + 2)] == null) {
                        labelArray[n10] = new Label();
                    }
                    if (labelArray[n10 = this.readUnsignedShort(n5 + 4)] == null) {
                        labelArray[n10] = new Label();
                    }
                    n5 += 8;
                    --n;
                }
                n = this.readUnsignedShort(n5);
                n5 += 2;
                while (n > 0) {
                    String string6 = this.readUTF8(n5, cArray);
                    if (string6.equals("LocalVariableTable")) {
                        if (!bl) {
                            n6 = n5 + 8;
                            for (n9 = this.readUnsignedShort(n5 + 6); n9 > 0; --n9) {
                                n10 = this.readUnsignedShort(n6);
                                if (labelArray[n10] == null) {
                                    labelArray[n10] = new Label();
                                }
                                if (labelArray[n10 += this.readUnsignedShort(n6 + 2)] == null) {
                                    labelArray[n10] = new Label();
                                }
                                n6 += 10;
                            }
                        }
                    } else if (string6.equals("LineNumberTable")) {
                        if (!bl) {
                            n6 = n5 + 8;
                            for (n9 = this.readUnsignedShort(n5 + 6); n9 > 0; --n9) {
                                n10 = this.readUnsignedShort(n6);
                                if (labelArray[n10] == null) {
                                    labelArray[n10] = new Label();
                                }
                                n6 += 4;
                            }
                        }
                    } else {
                        for (n9 = 0; n9 < attributeArray.length; ++n9) {
                            if (!attributeArray[n9].type.equals(string6) || (attribute2 = attributeArray[n9].read(this, n5 + 6, this.readInt(n5 + 2), cArray, n14 - 8, labelArray)) == null) continue;
                            attribute2.next = attribute4;
                            attribute4 = attribute2;
                        }
                    }
                    n5 += 6 + this.readInt(n5 + 2);
                    --n;
                }
                n5 = n14;
                block48: while (n5 < n15) {
                    n6 = n5 - n14;
                    Label label = labelArray[n6];
                    if (label != null) {
                        codeVisitor.visitLabel(label);
                    }
                    int n17 = byArray[n5] & 0xFF;
                    switch (ClassWriter.TYPE[n17]) {
                        case 0: {
                            codeVisitor.visitInsn(n17);
                            ++n5;
                            continue block48;
                        }
                        case 4: {
                            if (n17 > 54) {
                                codeVisitor.visitVarInsn(54 + ((n17 -= 59) >> 2), n17 & 3);
                            } else {
                                codeVisitor.visitVarInsn(21 + ((n17 -= 26) >> 2), n17 & 3);
                            }
                            ++n5;
                            continue block48;
                        }
                        case 8: {
                            codeVisitor.visitJumpInsn(n17, labelArray[n6 + this.readShort(n5 + 1)]);
                            n5 += 3;
                            continue block48;
                        }
                        case 9: {
                            codeVisitor.visitJumpInsn(n17, labelArray[n6 + this.readInt(n5 + 1)]);
                            n5 += 5;
                            continue block48;
                        }
                        case 16: {
                            n17 = byArray[n5 + 1] & 0xFF;
                            if (n17 == 132) {
                                codeVisitor.visitIincInsn(this.readUnsignedShort(n5 + 2), this.readShort(n5 + 4));
                                n5 += 6;
                                continue block48;
                            }
                            codeVisitor.visitVarInsn(n17, this.readUnsignedShort(n5 + 2));
                            n5 += 4;
                            continue block48;
                        }
                        case 13: {
                            n5 = n5 + 4 - (n6 & 3);
                            n10 = n6 + this.readInt(n5);
                            int n18 = this.readInt(n5 += 4);
                            int n19 = this.readInt(n5 += 4);
                            n5 += 4;
                            Label[] labelArray2 = new Label[n19 - n18 + 1];
                            for (n = 0; n < labelArray2.length; ++n) {
                                labelArray2[n] = labelArray[n6 + this.readInt(n5)];
                                n5 += 4;
                            }
                            codeVisitor.visitTableSwitchInsn(n18, n19, labelArray[n10], labelArray2);
                            continue block48;
                        }
                        case 14: {
                            n5 = n5 + 4 - (n6 & 3);
                            n10 = n6 + this.readInt(n5);
                            n = this.readInt(n5 += 4);
                            n5 += 4;
                            int[] nArray = new int[n];
                            Label[] labelArray3 = new Label[n];
                            for (n = 0; n < nArray.length; ++n) {
                                nArray[n] = this.readInt(n5);
                                labelArray3[n] = labelArray[n6 + this.readInt(n5 += 4)];
                                n5 += 4;
                            }
                            codeVisitor.visitLookupSwitchInsn(labelArray[n10], nArray, labelArray3);
                            continue block48;
                        }
                        case 3: {
                            codeVisitor.visitVarInsn(n17, byArray[n5 + 1] & 0xFF);
                            n5 += 2;
                            continue block48;
                        }
                        case 1: {
                            codeVisitor.visitIntInsn(n17, byArray[n5 + 1]);
                            n5 += 2;
                            continue block48;
                        }
                        case 2: {
                            codeVisitor.visitIntInsn(n17, this.readShort(n5 + 1));
                            n5 += 3;
                            continue block48;
                        }
                        case 10: {
                            codeVisitor.visitLdcInsn(this.readConst(byArray[n5 + 1] & 0xFF, cArray));
                            n5 += 2;
                            continue block48;
                        }
                        case 11: {
                            codeVisitor.visitLdcInsn(this.readConst(this.readUnsignedShort(n5 + 1), cArray));
                            n5 += 3;
                            continue block48;
                        }
                        case 6: 
                        case 7: {
                            int n20 = this.items[this.readUnsignedShort(n5 + 1)];
                            String string7 = this.readClass(n20, cArray);
                            n20 = this.items[this.readUnsignedShort(n20 + 2)];
                            String string8 = this.readUTF8(n20, cArray);
                            String string9 = this.readUTF8(n20 + 2, cArray);
                            if (n17 < 182) {
                                codeVisitor.visitFieldInsn(n17, string7, string8, string9);
                            } else {
                                codeVisitor.visitMethodInsn(n17, string7, string8, string9);
                            }
                            if (n17 == 185) {
                                n5 += 5;
                                continue block48;
                            }
                            n5 += 3;
                            continue block48;
                        }
                        case 5: {
                            codeVisitor.visitTypeInsn(n17, this.readClass(n5 + 1, cArray));
                            n5 += 3;
                            continue block48;
                        }
                        case 12: {
                            codeVisitor.visitIincInsn(byArray[n5 + 1] & 0xFF, byArray[n5 + 2]);
                            n5 += 3;
                            continue block48;
                        }
                    }
                    codeVisitor.visitMultiANewArrayInsn(this.readClass(n5 + 1, cArray), byArray[n5 + 3] & 0xFF);
                    n5 += 4;
                }
                Label label = labelArray[n15 - n14];
                if (label != null) {
                    codeVisitor.visitLabel(label);
                }
                n = this.readUnsignedShort(n5);
                n5 += 2;
                while (n > 0) {
                    Label label2 = labelArray[this.readUnsignedShort(n5)];
                    Label label3 = labelArray[this.readUnsignedShort(n5 + 2)];
                    Label label4 = labelArray[this.readUnsignedShort(n5 + 4)];
                    int n21 = this.readUnsignedShort(n5 + 6);
                    if (n21 == 0) {
                        codeVisitor.visitTryCatchBlock(label2, label3, label4, null);
                    } else {
                        codeVisitor.visitTryCatchBlock(label2, label3, label4, this.readUTF8(this.items[n21], cArray));
                    }
                    n5 += 8;
                    --n;
                }
                n = this.readUnsignedShort(n5);
                n5 += 2;
                if (!bl) {
                    while (n > 0) {
                        String string10 = this.readUTF8(n5, cArray);
                        if (string10.equals("LocalVariableTable")) {
                            n6 = n5 + 8;
                            for (n9 = this.readUnsignedShort(n5 + 6); n9 > 0; --n9) {
                                n10 = this.readUnsignedShort(n6);
                                Label label5 = labelArray[n10];
                                Label label6 = labelArray[n10 += this.readUnsignedShort(n6 + 2)];
                                codeVisitor.visitLocalVariable(this.readUTF8(n6 + 4, cArray), this.readUTF8(n6 + 6, cArray), label5, label6, this.readUnsignedShort(n6 + 8));
                                n6 += 10;
                            }
                        } else if (string10.equals("LineNumberTable")) {
                            n6 = n5 + 8;
                            for (n9 = this.readUnsignedShort(n5 + 6); n9 > 0; --n9) {
                                codeVisitor.visitLineNumber(this.readUnsignedShort(n6 + 2), labelArray[this.readUnsignedShort(n6)]);
                                n6 += 4;
                            }
                        }
                        n5 += 6 + this.readInt(n5 + 2);
                        --n;
                    }
                }
                while (attribute4 != null) {
                    attribute2 = attribute4.next;
                    attribute4.next = null;
                    codeVisitor.visitAttribute(attribute4);
                    attribute4 = attribute2;
                }
                codeVisitor.visitMaxs(n11, n12);
            }
            --n2;
        }
        while (attribute3 != null) {
            classVisitor.visitAttribute(attribute3);
            attribute3 = attribute3.next;
        }
        classVisitor.visitEnd();
    }

    public int getItem(int n) {
        return this.items[n];
    }

    public int readByte(int n) {
        return this.b[n] & 0xFF;
    }

    public int readUnsignedShort(int n) {
        byte[] byArray = this.b;
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    public short readShort(int n) {
        byte[] byArray = this.b;
        return (short)((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
    }

    public int readInt(int n) {
        byte[] byArray = this.b;
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public long readLong(int n) {
        long l = this.readInt(n);
        long l2 = (long)this.readInt(n + 4) & 0xFFFFFFFFL;
        return l << 32 | l2;
    }

    public String readUTF8(int n, char[] cArray) {
        int n2 = this.readUnsignedShort(n);
        String string = this.strings[n2];
        if (string != null) {
            return string;
        }
        n = this.items[n2];
        int n3 = this.readUnsignedShort(n);
        int n4 = (n += 2) + n3;
        byte[] byArray = this.b;
        int n5 = 0;
        block4: while (n < n4) {
            byte by;
            int n6 = byArray[n++] & 0xFF;
            switch (n6 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n5++] = (char)n6;
                    continue block4;
                }
                case 12: 
                case 13: {
                    by = byArray[n++];
                    cArray[n5++] = (char)((n6 & 0x1F) << 6 | by & 0x3F);
                    continue block4;
                }
            }
            by = byArray[n++];
            byte by2 = byArray[n++];
            cArray[n5++] = (char)((n6 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
        }
        this.strings[n2] = string = new String(cArray, 0, n5);
        return string;
    }

    public String readClass(int n, char[] cArray) {
        return this.readUTF8(this.items[this.readUnsignedShort(n)], cArray);
    }

    public Object readConst(int n, char[] cArray) {
        int n2 = this.items[n];
        switch (this.b[n2 - 1]) {
            case 3: {
                return new Integer(this.readInt(n2));
            }
            case 4: {
                return new Float(Float.intBitsToFloat(this.readInt(n2)));
            }
            case 5: {
                return new Long(this.readLong(n2));
            }
            case 6: {
                return new Double(Double.longBitsToDouble(this.readLong(n2)));
            }
            case 7: {
                String string = this.readUTF8(n2, cArray);
                return Type.getType(string.charAt(0) == '[' ? string : "L" + string + ";");
            }
        }
        return this.readUTF8(n2, cArray);
    }

    protected Attribute readAttribute(Attribute[] attributeArray, String string, int n, int n2, char[] cArray, int n3, Label[] labelArray) {
        for (int i = 0; i < attributeArray.length; ++i) {
            if (!attributeArray[i].type.equals(string)) continue;
            return attributeArray[i].read(this, n, n2, cArray, n3, labelArray);
        }
        return null;
    }
}

