﻿using System;
using System.Collections.Generic;
using System.Text;

namespace com.ast8.fw.forms
{
    /// <summary>
    /// 対象のcharが1byte文字かを示すユニコード専用のマッパ
    /// </summary>
    public class SingleCharMapper
    {
        private System.Collections.Generic.Dictionary<char, byte> m_map;
        /// <summary>0x00～この値までがgetMapでとれる以外の1byte領域と判定される</summary>
        public const char FIXED_SINGLE_POINT = (char)0x17f;

        /// <summary>
        /// 半角カナ等のマップをセットしてインスタンスを生成する
        /// </summary>
        /// <remarks>
        /// 0x17fまでは自動的に半角カードとして認識されるのでメモリ上に配置されない。
        /// MEMO:
        /// 結局のところunicodeマップはフォントによってサイズも違うので、
        /// フォントそのものにアクセスしないと厳密なサイズはとれないんだけどね。
        /// </remarks>
        public SingleCharMapper()
        {
            m_map = new Dictionary<char, byte>(64);
            char c;
            // 半角カナ
            for (c = '｡'; c <= 'ﾟ'; c++)
                m_map[c] = 1;
            /*
            // あとはこんな感じで追加
            // 矢印半角
            for (c = '↖'; c <= '⇑'; c++)
                m_map[c] = 1;
            m_map['⇓'] = 1;
            for (c = '⇕'; c <= '⇪'; c++)
                m_map[c] = 1;
            */

        }

        public bool isSingleByte(char value)
        {
            if (value <= FIXED_SINGLE_POINT)
                return true;
            return m_map.ContainsKey(value);
        }

        public void addMap(char key)
        {
            if (m_map.ContainsKey(key) == false)
                m_map[key] = 1;
        }

        public void addMap(params char[] keys)
        {
            foreach (char key in keys)
                addMap(key);
        }

        public void setMap(Dictionary<char, byte>.KeyCollection value)
        {
            setMap(value.GetEnumerator());
        }

        public void setMap(params char[] value)
        {
            setMap(value.GetEnumerator());
        }

        protected void setMap(System.Collections.IEnumerator enm)
        {
            m_map.Clear();
            while (enm.MoveNext())
                m_map[(char)(enm.Current)] = 1;
        }

        public Dictionary<char, byte>.KeyCollection getMap()
        {
            return m_map.Keys;
        }
    }
}
