/* 

    TiMidity -- Experimental MIDI to WAVE converter
    Copyright (C) 1995 Tuukka Toivonen <toivonen@clinet.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
	Keishi Suenaga was modifyed this most recently in 2002.
    If need to contact me mail E-mail:skeishi@users.sourceforge.jp .

    plugin_c.c
    Interface with UMP plugin
    */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <windows.h>

#include <stdio.h>
#ifndef NO_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <stdlib.h>
#include <unistd.h>
#include <stdarg.h>

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#include "timidity.h"
#include "common.h"
#include "output.h"
#include "controls.h"
#include "instrum.h"
#include "playmidi.h"

static void ctl_total_time(int tt);
static void ctl_file_name(char *name);
static void ctl_current_time(int secs, int v);
static int ctl_open(int using_stdin, int using_stdout);
static void ctl_close(void);
static int ctl_read(int32 *valp);
static int cmsg(int type, int verbosity_level, char *fmt, ...);
static void ctl_event(CtlEvent *e);
extern HANDLE hThread;
DWORD	ExitCode;

#define MAPPING_MAX  1000                  //}bsOIuWFNg̍ōl(ύX\)
#define MAPPING_NAME "WinUMP shared memory" //}bsOIuWFNg(ύX\)
static HANDLE hFileMap2      ; //}bsOIuWFNg̃nh
static LPVOID MapAdress=NULL;

/**********************************/
/* export the interface functions */


#define ctl plugin_control_mode

ControlMode ctl=
{
    "plugin interface", 'p',
    1,0,0,
    0,
    ctl_open,
    ctl_close,
    dumb_pass_playing_list,
    ctl_read,
    cmsg,
    ctl_event
};

static FILE *outfp=NULL;
int dumb_error_count;


static int ctl_open(int using_stdin, int using_stdout)
{
  hFileMap2= CreateFileMapping((HANDLE)0xFFFFFFFF,NULL,PAGE_READWRITE,0,MAPPING_MAX,MAPPING_NAME);
  if (hFileMap2==NULL)
  {
     MessageBox(0,"TIM}bsOIuWFNg̍쐬Ɏs(^^;","G[",MB_ICONSTOP);
  }

//}bvꂽr[̊JnAhX擾
  	MapAdress=MapViewOfFile(hFileMap2,FILE_MAP_ALL_ACCESS,0,0,0); 
//  	((char *)MapAdress)[0]='1';
    if (MapAdress==NULL){
   		 MessageBox(0,"TIM}bsOIuWFNg̓eǍ߂܂ł(^^;","G[",MB_ICONSTOP);
   	}
	if(using_stdout)
    outfp=stderr;
  else
    outfp=stdout;
  ctl.opened=1;
  return 0;
}

static void ctl_close(void)
{ 
  fflush(outfp);
  ctl.opened=0;
}

#include <sys/types.h>
#include <sys/stat.h>

static int myPipe; 

static int ctl_read_blocked(int32 *valp)
{
  unsigned char c;

	c=((char*)MapAdress)[0]; ((char *)MapAdress)[0]='1';
    switch(c)
      {
      case 'h':
      case '?':
        /*ctl_help_mode();*/
        return RC_NONE;
        
      case 'V':
        *valp=10;
        return RC_CHANGE_VOLUME;
      case 'v':
        *valp=-10;
        return RC_CHANGE_VOLUME;
      case 'q':
      	   //}bvꂽr[A}bv
      		UnmapViewOfFile((LPVOID)MapAdress);
      	    if (hFileMap2!=NULL) CloseHandle(hFileMap2);
	    GetExitCodeThread(hThread,&ExitCode);
	    ExitThread(ExitCode);
        return RC_QUIT;
      case 'n':
        return RC_NEXT;
      case 'p':
        return RC_REALLY_PREVIOUS;
      case 'r':
        return RC_SYNC_RESTART;

      case 'f':
        *valp=play_mode->rate;
        return RC_FORWARD;
      case 'b':
        *valp=play_mode->rate;
        return RC_BACK;
      case ' ':
	return RC_TOGGLE_PAUSE; /* Now supported by this improved timidity */
      }

  return RC_NONE;
}

static int ctl_read(int32 *valp)
{
	myPipe=0; //stdin
    return ctl_read_blocked(valp);
}

static int cmsg(int type, int verbosity_level, char *fmt, ...)
{
  va_list ap;
  if ((type==CMSG_TEXT || type==CMSG_INFO || type==CMSG_WARNING) &&
      ctl.verbosity<verbosity_level)
    return 0;
  va_start(ap, fmt);
  if (!ctl.opened)
    {
      vfprintf(stderr, fmt, ap);
      fprintf(stderr, "\n");
    }
  else
    {
      vfprintf(outfp, fmt, ap);
      fprintf(outfp, "\n");
    }
  va_end(ap);
  return 0;
}

static void ctl_total_time(int tt)
{
  int mins, secs;
  if (ctl.trace_playing)
    {
      secs=tt/play_mode->rate;
      mins=secs/60;
      secs-=mins*60;
      fprintf(outfp, "Total playing time: %3d min %02d s\n", mins, secs);
    }
}

static void ctl_file_name(char *name)
{
  if (ctl.verbosity>=0 || ctl.trace_playing)
    fprintf(outfp, "Playing %s\n", name);
}

static void ctl_current_time(int secs, int v)
{
  int mins;
  if (ctl.trace_playing)
    {
      mins=secs/60;
      secs-=mins*60;
      fprintf(outfp, "\r%3d:%02d", mins, secs);
      fflush(outfp);
    }
}

static void ctl_event(CtlEvent *e)
{
    switch(e->type)
    {
      case CTLE_NOW_LOADING:
	ctl_file_name((char *)e->v1);
	break;
      case CTLE_PLAY_START:
	ctl_total_time((int)e->v1);
	break;
      case CTLE_CURRENT_TIME:
	ctl_current_time((int)e->v1, (int)e->v2);
	break;
    }
}

/*
 * interface_<id>_loader();
 */
ControlMode *interface_p_loader(void)
{
    return &ctl;
}

