/* WinUMP.c */

/*      WinUMP  Midi plugin for Mozilla  with TiMidity++
                               Ver 0.0.1 (Pre Alpha 1)
     ------------------------------------------------------------
     Copyright (C) 2002N Keishi Suenaga
                              ----------

     {vO̓t[E\tgEFAłBȂ́AFree Software Foundation 
     \GNU ʌLgṕuo[WQv͂ȍ~̊eo[W
     ̒炢ꂩIÃo[W߂ɏ]Ė{vO
     ĔЕz܂͕ύX邱Ƃł܂B

     {vO͗LpƂ͎v܂AЕzɂẮAsꐫyѓړIK
     ɂĂ̈Öق̕ۏ؂܂߂āAȂۏ؂sȂ܂BڍׂɂĂ
     GNU ʌLgpǂ݂B

     Ȃ́A{vOƈꏏGNU ʌLgp̎ʂ󂯎Ă
     ͂łBłȂꍇ́AFree Software Foundation, Inc., 675 Mass Ave,
     Cambridge, MA 02139, USA ֎莆ĂB

     Keishi Suenaga̘A     E-mail:skeishi@users.sourceforge.jp
*/
#if !defined(__GNUC__)
#define  strcasecmp stricmp
#endif

#include <windows.h>
#include <windowsx.h>
#include <stdio.h>                               /* sprintf(), fprintf(), etc. */
#include <fcntl.h>                               /* O_RDWR */
//#include "npapi.h"
#include "resource.h"


#define ID_STOP_BUTTON 1500
#define ID_PAUSE_BUTTON 1501
#define ID_PLAY_BUTTON 1502
#define ID_PLUS_BUTTON 1503
#define ID_MINUS_BUTTON 1504

#define BUFSIZE 4048
#define PIPE_R 0
#define PIPE_W 1

//L֘A
#define MAPPING_MAX  1000                  //}bsOIuWFNg̍ōl(ύX\)
#define MAPPING_NAME "WinUMP shared memory" //}bsOIuWFNg(ύX\)


HANDLE hThread=NULL;
static DWORD dwThreadId;
static STARTUPINFO StartupInfo;




typedef struct _WinUMPSM
{
	char command;
	short int PlayId;
} WinUMPSM;

static int useLC =1;

//摜𒆉ɂׂXW(LEFT)YW(TOP)Zo}N
#define CenterX(Width) ((0)<((Rect.right - Rect.left - Width) / 2) ? ((Rect.right - Rect.left - Width) / 2) :(0))
#define CenterY(Height) ((0)<((Rect.bottom - Rect.top - Height) / 2) ? ((Rect.bottom - Rect.top - Height) / 2) :(0))


// TIMIDITỸftHgl
#ifndef DEFAULT_PATH
#define DEFAULT_PATH "c:\\timidity"
#endif /* DEFAULT_PATH */
static const char *timdir = DEFAULT_PATH;

// xvZbT̂߂ɒxTvO[gftHg
static int eightKFlag = 0;
static int timid_ump_rate = 0;
static char *timid_ump_interface = "pqq";
static const char *filestub = "c:\\tmp\\midi";

#include "plugin.h"



extern "C" int timiditymain(int argc, char** argv);

DWORD WINAPI ThreadProc(LPVOID filename)
{
    char *argv[16];
	char opt_interface[8];
	char opt_rate[32];
	int argc = 0;


	argv[argc++] = "timidity";
	argv[argc++] = "-Od";

	if(timid_ump_rate <= 0){
		if(eightKFlag==0){	/* check if the user specified 8K rate */
			argv[argc++] = "-s8000";
		}else{
			argv[argc++] = "-s22050"; 
		}
	}else
	{
	  sprintf(opt_rate, "-s%d", timid_ump_rate);
	  argv[argc++] = opt_rate;
	}

	opt_interface[0] = '-';
	opt_interface[1] = 'i';
	strncpy(opt_interface + 2, timid_ump_interface, sizeof(opt_interface) - 3);
	opt_interface[sizeof(opt_interface) - 1] = '\0';
	argv[argc++] = opt_interface;

	argv[argc++] = (char *)filename;
	argv[argc] = NULL;

    /* change to the configuration directory */
    chdir(timdir);

                       
	timiditymain(argc, argv);


	return 0;
}




#include "plugin.h"

NPError
NPP_Initialize(void)
{	
  /* see if the user has specified an alternate directory for timidity */
  if(getenv("TIMID_DIR") != NULL) timdir = getenv("TIMID_DIR");
  
  /* see if the user has specified an alternate directory for timidity */
  if(getenv("TIMID_8K") != NULL) eightKFlag = 1;
  if(getenv("TIMID_INTERFACE") != NULL) timid_ump_interface = getenv("TIMID_INTERFACE");
  if(getenv("TIMID_RATE") != NULL) timid_ump_rate = atoi(getenv("TIMID_RATE"));


	return NPERR_NO_ERROR;
}

void
NPP_Shutdown(void)
{
}


NPError 
NPP_New(NPMIMEType pluginType,
                NPP instance,
                uint16 mode,
                int16 argc,
                char* argn[],
                char* argv[],
                NPSavedData* saved)
{   
  if(instance == NULL)
    return NPERR_INVALID_INSTANCE_ERROR;

  NPError rv = NPERR_NO_ERROR;

  CPlugin * pPlugin = new CPlugin(instance);
  if(pPlugin == NULL)
    return NPERR_OUT_OF_MEMORY_ERROR;

  instance->pdata = (void *)pPlugin;


  pPlugin->loop = 0;
  pPlugin->pluginState = PLUGIN_PLAYING; 
  {
    int i;
    for(i = 0; i < argc; i++) {
      	if(strcasecmp(argn[i], "loop") == 0){
			if(strcasecmp(argv[i], "true") == 0 ||
		   			strcasecmp(argv[i], "yes") == 0) {
		  		pPlugin->loop = ~0;
			}
     	}
     	else if(strcasecmp(argn[i], "autostart") == 0){
			if(strcasecmp(argv[i], "false") == 0 ||
	   				strcasecmp(argv[i], "no") == 0) {
	  			pPlugin->pluginState = PLUGIN_STOPPED;
	   		}
		}
    }

  	memset(&(StartupInfo),0,sizeof(STARTUPINFO));
	StartupInfo.cb = sizeof(STARTUPINFO);
    }
  return rv;
}


NPError 
NPP_Destroy (NPP instance, NPSavedData** save)
{
  if(instance == NULL)
    return NPERR_INVALID_INSTANCE_ERROR;

  NPError rv = NPERR_NO_ERROR;

  CPlugin * pPlugin = (CPlugin *)instance->pdata;
  if(pPlugin != NULL) {
    pPlugin->shut();
    delete pPlugin;
  }
	return rv;
}


// during this call we know when the plugin window is ready or
// is about to be destroyed so we can do some gui specific
// initialization and shutdown
NPError NPP_SetWindow (NPP instance, NPWindow* pNPWindow)
{    
  if(instance == NULL)
    return NPERR_INVALID_INSTANCE_ERROR;

  NPError rv = NPERR_NO_ERROR;

  if(pNPWindow == NULL)
    return NPERR_GENERIC_ERROR;

  CPlugin * pPlugin = (CPlugin *)instance->pdata;

  if(pPlugin == NULL) 
    return NPERR_GENERIC_ERROR;

  // window just created
  if(!pPlugin->isInitialized() && (pNPWindow->window != NULL)) { 
    if(!pPlugin->init(pNPWindow)) {
      delete pPlugin;
      pPlugin = NULL;
      return NPERR_MODULE_LOAD_FAILED_ERROR;
    }
  }

  // window goes away
  if((pNPWindow->window == NULL) && pPlugin->isInitialized())
    return NPERR_NO_ERROR;

  // window resized
  if(pPlugin->isInitialized() && (pNPWindow->window != NULL))
    return NPERR_NO_ERROR;

  // this should not happen, nothing to do
  if((pNPWindow->window == NULL) && !pPlugin->isInitialized())
    return NPERR_NO_ERROR;

  return rv;
}


NPError 
NPP_NewStream(NPP instance,
	      NPMIMEType type,
	      NPStream *stream, 
	      NPBool seekable,
	      uint16 *stype)
{

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	CPlugin * pPlugin = (CPlugin *)instance->pdata;
	
	{
	const char *ext, *p;
	ext = stream->url;
  	if((p = strrchr(ext, '/')) != NULL)
	  ext = p + 1;
  	if((p = strchr(ext, '.')) != NULL)
	  ext = p + 1;
	_snprintf(pPlugin->filename, sizeof(pPlugin->filename), "%s%x.%s", filestub, pPlugin, ext);
  	/* open the file to store data in */
  	unlink(pPlugin->filename);	/* for security. */
  	pPlugin->fd = open(pPlugin->filename, O_RDWR|O_CREAT|O_BINARY, 0666);
  	if(pPlugin->fd == -1) {
  		pPlugin->filename[0]='\0';
    	return NPERR_GENERIC_ERROR;
  	}
	}

	return NPERR_NO_ERROR;
}



int32 STREAMBUFSIZE = 0X0FFFFFFF; 




int32 
NPP_WriteReady(NPP instance, NPStream *stream)
{

	if (instance != NULL)
		CPlugin * pPlugin = (CPlugin *)instance->pdata;

	return STREAMBUFSIZE;
}




int32 
NPP_Write(NPP instance, NPStream *stream, int32 offset, int32 len, void *buffer)
{
	if (instance != NULL) {
		CPlugin * pPlugin = (CPlugin *)instance->pdata;
		len = write(pPlugin->fd, buffer, len);
      	if(len <0) close(pPlugin->fd);
	}
	return len;
}




NPError 
NPP_DestroyStream(NPP instance, NPStream *stream, NPError reason)
{

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;
    CPlugin * pPlugin = (CPlugin *)instance->pdata;

  close(pPlugin->fd);
  
  pPlugin->pluginState=PLUGIN_PLAYING;
  pPlugin->startMidiPlayer();
  
  NPN_Status(instance, "Playing MIDI file");


	return NPERR_NO_ERROR;
}




void 
NPP_StreamAsFile(NPP instance, NPStream *stream, const char* fname)
{
	if (instance != NULL){
		CPlugin * pPlugin = (CPlugin *)instance->pdata;
	}

}

void 
NPP_Print(NPP instance, NPPrint* printInfo)
{
	if(printInfo == NULL)
		return;

	if (instance != NULL) {
	
		if (printInfo->mode == NP_FULL) {
			printInfo->print.fullPrint.pluginPrinted = FALSE;
		}
	}
}


void
NPP_URLNotify(NPP instance, const char* url, NPReason reason, void* notifyData)
{
  if(instance == NULL)
    return;
}


int16	NPP_HandleEvent(NPP instance, void* event)
{
  if(instance == NULL)
    return 0;

  int16 rv = 0;
  CPlugin * pPlugin = (CPlugin *)instance->pdata;
  if (pPlugin)
    rv = pPlugin->handleEvent(event);

  return rv;
}

// ==============================
// ! Scriptability related code !
// ==============================
//
// here the plugin is asked by Mozilla to tell if it is scriptable
// we should return a valid interface id and a pointer to 
// nsScriptablePeer interface which we should have implemented
// and which should be defined in the corressponding *.xpt file
// in the bin/components folder
NPError	NPP_GetValue(NPP instance, NPPVariable variable, void *value)
{
  if(instance == NULL)
    return NPERR_INVALID_INSTANCE_ERROR;

  NPError rv = NPERR_NO_ERROR;

  if(instance == NULL)
    return NPERR_GENERIC_ERROR;

  CPlugin * pPlugin = (CPlugin *)instance->pdata;
  if(pPlugin == NULL)
    return NPERR_GENERIC_ERROR;

  if (variable == NPPVpluginScriptableInstance) {
    // addref happens in getter, so we don't addref here
    nsIWinumpPlugin * scriptablePeer = pPlugin->getScriptablePeer();
    if (scriptablePeer) {
      *(nsISupports **)value = scriptablePeer;
    } else {
      rv = NPERR_OUT_OF_MEMORY_ERROR;
    }
  }
  else if (variable == NPPVpluginScriptableIID) {
    static nsIID scriptableIID = NS_IWINUMPPLUGIN_IID;
    nsIID* ptr = (nsIID *)NPN_MemAlloc(sizeof(nsIID));
    if (ptr) {
        *ptr = scriptableIID;
        *(nsIID **)value = ptr;
    } else {
      rv = NPERR_OUT_OF_MEMORY_ERROR;
    }
  }

  return rv;
}

  	
NPError NPP_SetValue(NPP instance, NPNVariable variable, void *value)
{
  if(instance == NULL)
    return NPERR_INVALID_INSTANCE_ERROR;

  NPError rv = NPERR_NO_ERROR;
  return rv;
}


jref
NPP_GetJavaClass()
{
  return NULL;
}


CPlugin::CPlugin(NPP pNPInstance) :
  m_pNPInstance(pNPInstance),
  m_pNPStream(NULL),
  m_bInitialized(FALSE),
  m_pScriptablePeer(NULL)
{
  m_hWnd = NULL;

	filename[0]='\0';
    pluginState = PLUGIN_PLAYING;
	hMinusButton=NULL;
	hPauseButton=NULL;
	hPlayButton=NULL;
	hPlusButton=NULL;
	hStopButton=NULL;
	getmap();
}

CPlugin::~CPlugin()
{
  NS_IF_RELEASE(m_pScriptablePeer);
}

static LRESULT CALLBACK PluginWinProc(HWND, UINT, WPARAM, LPARAM);
static WNDPROC lpOldProc = NULL;

  	
NPBool CPlugin::init(NPWindow* pNPWindow)
{
  if(pNPWindow == NULL)
    return FALSE;

  m_hWnd = (HWND)pNPWindow->window;
  if(m_hWnd == NULL)
    return FALSE;

  // subclass window so we can intercept window messages and
  // do our drawing to it
  lpOldProc = SubclassWindow(m_hWnd, (WNDPROC)PluginWinProc);

  // associate window with our CPlugin object so we can access 
  // it in the window procedure
  SetWindowLong(m_hWnd, GWL_USERDATA, (LONG)this);

  m_Window = pNPWindow;

  m_bInitialized = TRUE;
  return TRUE;
}

void CPlugin::shut()
{
  stopMidiPlayer();
	remove(filename);
  DeleteObject(hBase);
  DeleteObject(hMinus);
  DeleteObject(hPause);
  DeleteObject(hPlay);
  DeleteObject(hPlus);
  DeleteObject(hStop);
  DeleteObject(hTitle);
  DeleteObject(hPauseOn);
  DeleteObject(hPlayOn);
  releasemap();
  // subclass it back
  SubclassWindow(m_hWnd, lpOldProc);
  m_hWnd = NULL;

  m_bInitialized = FALSE;
}

NPBool CPlugin::isInitialized()
{
  return m_bInitialized;
}

int16 CPlugin::handleEvent(void* event)
{
    return 0;
}

void CPlugin::getmap()
{
	///L̏
	//}bsOIuWFNg쐬 
	// ̖Ot}bsOIuWFNg̖Oƈvꍇ͂̃}bsOIuWFNgւ̃ANZXvB
  	hFileMap1= CreateFileMapping((HANDLE)0xFFFFFFFF,NULL,PAGE_READWRITE,0,MAPPING_MAX,MAPPING_NAME);
  	if (hFileMap1==NULL)
  	{
     	MessageBox(0,"}bsOIuWFNg̍쐬Ɏs(^^;","WinUMPG[",MB_ICONSTOP);
  	};

	MapAdress=MapViewOfFile(hFileMap1,FILE_MAP_WRITE,0,0,0); 
    if (MapAdress==NULL){
         MessageBox(0,"}bsOIuWFNg[hł܂ł(^^;","WinUMPG[",MB_ICONSTOP);
    }	
}

void CPlugin::releasemap()
{

		UnmapViewOfFile((LPVOID)MapAdress);
    	if (hFileMap1!=NULL) CloseHandle(hFileMap1);
  	
}


void CPlugin::loadBitmaps()
{
			BITMAP  BMPINFO ;
			HINSTANCE hInst; 

			hInst = LoadLibrary( "npWinUMP32.dll");
         	hBase =(HBITMAP)LoadImage(hInst, 
         		MAKEINTRESOURCE(BASE_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
         	hMinus =(HBITMAP)LoadImage(hInst, 
         		MAKEINTRESOURCE(MINUS_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
         	hPause =(HBITMAP)LoadImage(hInst, 
         		MAKEINTRESOURCE(PAUSE_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
         	hPlay =(HBITMAP)LoadImage(hInst, 
         		MAKEINTRESOURCE(PLAY_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
         	hPlus =(HBITMAP)LoadImage(hInst, 
         		MAKEINTRESOURCE(PLUS_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
         	hStop =(HBITMAP)LoadImage(hInst, 
         		MAKEINTRESOURCE(STOP_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
         	hTitle =(HBITMAP)LoadImage(hInst, 
         		MAKEINTRESOURCE(TITLE_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
	        hPauseOn =(HBITMAP)LoadImage(hInst, 
         		MAKEINTRESOURCE(PAUSEON_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
         	hPlayOn =(HBITMAP)LoadImage(hInst, 
         		MAKEINTRESOURCE(PLAYON_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
			
			GetObject(hBase, sizeof(BITMAP), &BMPINFO);
			X_Base=BMPINFO.bmWidth;
			Y_Base=BMPINFO.bmHeight;
			GetObject(hTitle, sizeof(BITMAP), &BMPINFO);
			X_Title=BMPINFO.bmWidth;
			Y_Title=BMPINFO.bmHeight;
			GetObject(hStop, sizeof(BITMAP), &BMPINFO);
			X_Stop=BMPINFO.bmWidth;
			Y_Stop=BMPINFO.bmHeight;
			GetObject(hPause, sizeof(BITMAP), &BMPINFO);
			X_Pause=BMPINFO.bmWidth;
			Y_Pause=BMPINFO.bmHeight;
			GetObject(hPlay, sizeof(BITMAP), &BMPINFO);
			X_Play=BMPINFO.bmWidth;
			Y_Play=BMPINFO.bmHeight;
			GetObject(hPlus, sizeof(BITMAP), &BMPINFO);
			X_Plus=BMPINFO.bmWidth;
			Y_Plus=BMPINFO.bmHeight;
			GetObject(hMinus, sizeof(BITMAP), &BMPINFO);
			X_Minus=BMPINFO.bmWidth;
			Y_Minus=BMPINFO.bmHeight;

}


void CPlugin::makebuttons(HWND hWnd)
{
			int     X,Y;


			if(hMinusButton!=NULL) DestroyWindow(hMinusButton);
			if(hPauseButton!=NULL) DestroyWindow(hPauseButton);
			if(hPlayButton!=NULL) DestroyWindow(hPlayButton);
			if(hPlusButton!=NULL) DestroyWindow(hPlusButton);
			if(hStopButton!=NULL) DestroyWindow(hStopButton);

				X=XO;
				Y=YO+Y_Title;
            	hStopButton = CreateWindow("BUTTON",
            	NULL,  //\
                WS_CHILD | WS_VISIBLE | BS_OWNERDRAW,
                X, Y, //ʒu
                X_Stop,Y_Stop, //E
                hWnd, //eEBhE
                (HMENU)ID_STOP_BUTTON, //{^ID
                (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE), //CX^Xnh
                NULL);
				
				X=XO+X_Stop;
				Y=YO+Y_Title;
            	hPauseButton = CreateWindow("BUTTON",
            	NULL,  //\
                WS_CHILD | WS_VISIBLE | BS_OWNERDRAW,
                X, Y, //ʒu
                X_Pause,Y_Pause, //E
                hWnd, //eEBhE
                (HMENU)ID_PAUSE_BUTTON, //{^ID
                (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE), //CX^Xnh
                NULL);
			
				X=XO+X_Stop+X_Pause;
				Y=YO+Y_Title;
            	hPlayButton = CreateWindow("BUTTON",
            	NULL,  //\
                WS_CHILD | WS_VISIBLE | BS_OWNERDRAW,
                X, Y, //ʒu
                X_Play,Y_Play, //E
                hWnd, //eEBhE
                (HMENU)ID_PLAY_BUTTON, //{^ID
                (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE), //CX^Xnh
                NULL);


				X=XO+X_Stop+X_Pause+X_Play;
				Y=YO+Y_Title;
            	hPlusButton = CreateWindow("BUTTON",
            	NULL,  //\
                WS_CHILD | WS_VISIBLE | BS_OWNERDRAW,
                X, Y, //ʒu
                X_Plus,Y_Plus, //E
                hWnd, //eEBhE
                (HMENU)ID_PLUS_BUTTON, //{^ID
                (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE), //CX^Xnh
                NULL);

				X=XO+X_Stop+X_Pause+X_Play+X_Plus;
				Y=YO+Y_Title;
            	hMinusButton = CreateWindow("BUTTON",
            	NULL,  //\
                WS_CHILD | WS_VISIBLE | BS_OWNERDRAW,
                X, Y, //ʒu
                X_Minus,Y_Minus, //E
                hWnd, //eEBhE
                (HMENU)ID_MINUS_BUTTON, //{^ID
                (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE), //CX^Xnh
                NULL);

}
  	
void CPlugin::DrawBase(HWND hWnd)
{
			PAINTSTRUCT paintStruct;
			HDC hMem,hDC;
			RECT Rect;
			HBRUSH  hOldBrush;
			int     X,Y;
	
			hDC = BeginPaint( hWnd, &paintStruct );
			
			hOldBrush = ( HBRUSH )SelectObject( hDC, ( HBRUSH )GetStockObject( WHITE_BRUSH ));
			GetClientRect(hWnd, &Rect);
			Rectangle( hDC, Rect.left, Rect.top, Rect.right, Rect.bottom );
			SelectObject( hDC, hOldBrush );
			
			EndPaint( hWnd, &paintStruct );
			ReleaseDC(hWnd,hDC);

			hDC=GetDC(hWnd);
			hMem = CreateCompatibleDC(hDC);
			SelectObject(hMem, hBase);
			BitBlt(hDC, XO, YO, \
							X_Base, \
                            Y_Base, \
                            hMem, 0, 0, SRCCOPY);
			DeleteDC(hMem);    
			ReleaseDC(hWnd,hDC);
			DeleteObject(hBase);


			hDC=GetDC(hWnd);
			hMem = CreateCompatibleDC(hDC);
			SelectObject(hMem, hTitle);
			BitBlt(hDC, XO, YO, \
							X_Title, \
                            Y_Title, \
                            hMem, 0, 0, SRCCOPY);
			DeleteDC(hMem);    ;
			ReleaseDC(hWnd,hDC);
			DeleteObject(hTitle);
}
	
void CPlugin::DrawButtons()
{
			HDC hMem,hDC;
	
			
			hDC=GetDC(hStopButton);
			hMem = CreateCompatibleDC(hDC);
			SelectObject(hMem, hStop);
			BitBlt(hDC, 0,0, \
							X_Stop, \
                            Y_Stop, \
                            hMem, 0, 0, SRCCOPY);
			DeleteDC(hMem);    
			ReleaseDC(m_hWnd,hDC);

			hDC=GetDC(hPauseButton);
			hMem = CreateCompatibleDC(hDC); 
			if(pluginState!=PLUGIN_PAUSED){
				SelectObject(hMem, hPause);
			}else{
				SelectObject(hMem, hPauseOn);
			}
			BitBlt(hDC, 0,0, \
							X_Pause, \
                            Y_Pause, \
                            hMem, 0, 0, SRCCOPY);
			DeleteDC(hMem);    
			ReleaseDC(m_hWnd,hDC);

	hDC=GetDC(hPlayButton);
			hMem = CreateCompatibleDC(hDC);
			if(pluginState==PLUGIN_STOPPED){
				SelectObject(hMem, hPlay);
			}else{
				SelectObject(hMem, hPlayOn);
			}
			BitBlt(hDC, 0,0, \
							X_Play, \
                            Y_Play, \
                            hMem, 0, 0, SRCCOPY);
			DeleteDC(hMem);    
			ReleaseDC(m_hWnd,hDC);	

			hDC=GetDC(hPlusButton);
			hMem = CreateCompatibleDC(hDC);
			SelectObject(hMem, hPlus);
			BitBlt(hDC, 0,0, \
							X_Plus, \
                            Y_Plus, \
                            hMem, 0, 0, SRCCOPY);
			DeleteDC(hMem);    
			ReleaseDC(m_hWnd,hDC);

			hDC=GetDC(hMinusButton);
			hMem = CreateCompatibleDC(hDC);
			SelectObject(hMem, hMinus);
			BitBlt(hDC, 0,0, \
							X_Minus, \
                            Y_Minus, \
                            hMem, 0, 0, SRCCOPY);
			DeleteDC(hMem);    
			ReleaseDC(m_hWnd,hDC);
}

void CPlugin::plusMidiPlayer()
{
	if(PlayId==((WinUMPSM *)MapAdress)->PlayId){
   		((char *)MapAdress)[0]='V';
	}
}

void CPlugin::minusMidiPlayer()
{
	if(PlayId==((WinUMPSM *)MapAdress)->PlayId){
 		((char *)MapAdress)[0]='v';
	}
}

void CPlugin::pauseMidiPlayer()
{
		if(PlayId==((WinUMPSM *)MapAdress)->PlayId){
   			((char *)MapAdress)[0]=' ';
		}
}

void CPlugin::stopMidiPlayer(){
	DWORD ExitCode;


	((char *)MapAdress)[0]='q';
//    do{
//    	GetExitCodeThread(hThread,&ExitCode);
//    }while(ExitCode==STILL_ACTIVE);
GetExitCodeThread(hThread, &ExitCode);
TerminateThread(hThread, ExitCode); //͊댯Ȃ̂Ȃłł͂܂Ƃ܂Ȃ
	WaitForSingleObject(hThread, INFINITE);
	CloseHandle(hThread);
	hThread=NULL;
}

void CPlugin::kstopMidiPlayer(){
		if(PlayId==((WinUMPSM *)MapAdress)->PlayId){
			stopMidiPlayer();
		}
}

void CPlugin::startMidiPlayer()
{  	
	if(hThread!=NULL){
		stopMidiPlayer();
	}
	 ((char *)MapAdress)[0]='1';
	
    chdir(timdir);
	hThread=CreateThread(NULL,0,ThreadProc,filename,0,&(dwThreadId));
	if(hThread==NULL){
			MessageBox(m_hWnd, "Timidity vZX̍쐬Ɏs܂", 
				"WinUMPG[", MB_OK | MB_ICONERROR);
		return;
	}
	((WinUMPSM *)MapAdress)->PlayId=((WinUMPSM *)MapAdress)->PlayId+1;
	if(((WinUMPSM *)MapAdress)->PlayId>=128){
		((WinUMPSM *)MapAdress)->PlayId=((WinUMPSM *)MapAdress)->PlayId-128;
	}
	PlayId=((WinUMPSM *)MapAdress)->PlayId;
	((char *)MapAdress)[0]='r';
}

void CPlugin::pausebutton(){
	if(pluginState==PLUGIN_PLAYING){
		pauseMidiPlayer();
		pluginState=PLUGIN_PAUSED;
	}else{
		if(pluginState==PLUGIN_PAUSED){
			pauseMidiPlayer();
			pluginState=PLUGIN_PLAYING;
		}
    }
}

void CPlugin::playbutton(){
	if(pluginState==PLUGIN_PAUSED){
		pauseMidiPlayer();
        pluginState=PLUGIN_PLAYING;;
	}else{
        if(pluginState==PLUGIN_STOPPED){
            startMidiPlayer();
            pluginState=PLUGIN_PLAYING;
        }
	}
}

void CPlugin::plusbutton(){
	plusMidiPlayer();
}

void CPlugin::minusbutton(){
	minusMidiPlayer();
}

void CPlugin::stopbutton(){
	if(pluginState!=PLUGIN_STOPPED){
		kstopMidiPlayer();
		pluginState=PLUGIN_STOPPED;
	}
}

// ==============================
// ! Scriptability related code !
// ==============================
//
// this method will return the scriptable object (and create it if necessary)
nsIWinumpPlugin* CPlugin::getScriptablePeer()
{
  if (!m_pScriptablePeer) {
    m_pScriptablePeer = new nsScriptablePeer(this);
    if(!m_pScriptablePeer)
      return NULL;

    NS_ADDREF(m_pScriptablePeer);
  }

  // add reference for the caller requesting the object
  NS_ADDREF(m_pScriptablePeer);
  return m_pScriptablePeer;
}


LRESULT CALLBACK PluginWinProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CPlugin * pPlugin = (CPlugin *)GetWindowLong(hWnd, GWL_USERDATA);

	switch( msg ) {
		
		case WM_DRAWITEM:  {//̃bZ[W߂܂I[i[h[ 
			
			pPlugin->DrawButtons();
			
            break;
		}


		case WM_COMMAND: {
/*			GetExitCodeThread(hThread,&ExitCode);
			if(ExitCode!=STILL_ACTIVE){
				pPlugin->stopMidiPlayer();
				pPlugin->pluginState=PLUGIN_STOPPED;
            }
*/
			if(pPlugin->PlayId!=((WinUMPSM *)pPlugin->MapAdress)->PlayId){
				pPlugin->pluginState=PLUGIN_STOPPED;
			}
            switch (LOWORD(wParam)) {
            	case ID_STOP_BUTTON: {
            		pPlugin->stopbutton();
                    break;
            	}
            	case ID_PAUSE_BUTTON:{
            		pPlugin->pausebutton();
                    break;
            	}
            	case ID_PLAY_BUTTON:{
            		pPlugin->playbutton();
            		break;
            	}
            	case ID_PLUS_BUTTON:{
            		pPlugin->plusbutton();
            		break;
            	}
				case ID_MINUS_BUTTON:{
					pPlugin->minusbutton();
					break;            			
            	}            		            			
            }
			pPlugin->DrawButtons();
            break;
		}

		case WM_PAINT: {
			PAINTSTRUCT paintStruct;
			HDC hMem,hDC;
			RECT Rect;
			HBRUSH  hOldBrush;
			int     X,Y;

			pPlugin->loadBitmaps();
			
			GetClientRect(hWnd, &Rect);
			pPlugin->XO=CenterX(pPlugin->X_Base);
			pPlugin->YO=CenterY(pPlugin->Y_Base);
			
			// {^̍쐬
			pPlugin->makebuttons(hWnd);

			// ʂ̏
			pPlugin->DrawBase(hWnd);
			pPlugin->DrawButtons();
			break;
		} 

		default: { 
			break;
		}              	

	} 
	return DefWindowProc(hWnd, msg, wParam, lParam);
}

