/* open URL stream */
extern URL url_open(tmdy_struct_ex_t *tmdy_struct, char *url_string);

/* close URL stream */
extern void url_close(tmdy_struct_ex_t *tmdy_struct, URL url);

/* read n bytes */
extern long url_read(tmdy_struct_ex_t *tmdy_struct, URL url, void *buff, long n);
extern long url_safe_read(tmdy_struct_ex_t *tmdy_struct, URL url, void *buff, long n);
extern long url_nread(tmdy_struct_ex_t *tmdy_struct, URL url, void *buff, long n);

/* read a line */
/* Like a fgets */
extern char *url_gets(tmdy_struct_ex_t *tmdy_struct, URL url, char *buff, int n);

/* Allow termination by CR or LF or both. Ignored empty lines.
 * CR or LF is truncated.
 * Success: length of the line.
 * EOF or Error: EOF
 */
extern int url_readline(tmdy_struct_ex_t *tmdy_struct, URL url, char *buff, int n);

/* read a byte */
extern int url_fgetc(tmdy_struct_ex_t *tmdy_struct, URL url);



/* seek position */
extern long url_seek(tmdy_struct_ex_t *tmdy_struct, URL url, long offset, int whence);

/* get the current position */
extern long url_tell(tmdy_struct_ex_t *tmdy_struct, URL url);

/* skip n bytes */
extern void url_skip(tmdy_struct_ex_t *tmdy_struct, URL url, long n);

/* seek to first position */
extern void url_rewind(tmdy_struct_ex_t *tmdy_struct, URL url);

/* dump */
void *url_dump(tmdy_struct_ex_t *tmdy_struct, URL url, long nbytes, long *real_read);

/* set read limit */
void url_set_readlimit(tmdy_struct_ex_t *tmdy_struct, URL url, long readlimit);

/* url_errno to error message */
extern char *url_strerror(tmdy_struct_ex_t *tmdy_struct, int no);

/* allocate URL structure */
extern URL alloc_url(tmdy_struct_ex_t *tmdy_struct, int size);

/* Check URL type. */
extern int url_check_type(tmdy_struct_ex_t *tmdy_struct, char *url_string);

/* replace `~' to user directory */
extern char *url_expand_home_dir(tmdy_struct_ex_t *tmdy_struct, char *filename);
extern char *url_unexpand_home_dir(tmdy_struct_ex_t *tmdy_struct, char *filename);

extern int url_errno;

extern void url_add_module(tmdy_struct_ex_t *tmdy_struct, struct URL_module *m);
extern void url_add_modules(tmdy_struct_ex_t *tmdy_struct, struct URL_module *m, ...);

extern URL url_file_open(tmdy_struct_ex_t *tmdy_struct, char *filename);
extern URL url_dir_open(tmdy_struct_ex_t *tmdy_struct, char *directory_name);
extern URL url_http_open(tmdy_struct_ex_t *tmdy_struct, char *url_string);
extern URL url_ftp_open(tmdy_struct_ex_t *tmdy_struct, char *url_string);
extern URL url_newsgroup_open(tmdy_struct_ex_t *tmdy_struct, char *url_string);
extern URL url_news_open(tmdy_struct_ex_t *tmdy_struct, char *url_string);
extern URL url_pipe_open(tmdy_struct_ex_t *tmdy_struct, char *command);

/* No URL_module */
extern URL url_mem_open(tmdy_struct_ex_t *tmdy_struct, char *memory, long memsiz, int autofree);
extern URL url_inflate_open(tmdy_struct_ex_t *tmdy_struct, URL instream, long compsize, int autoclose);
extern URL url_buff_open(tmdy_struct_ex_t *tmdy_struct, URL url, int autoclose);
extern URL url_cache_open(tmdy_struct_ex_t *tmdy_struct, URL url, int autoclose);
extern void url_cache_detach(tmdy_struct_ex_t *tmdy_struct, URL url);
extern void url_cache_disable(tmdy_struct_ex_t *tmdy_struct, URL url);
extern URL url_uudecode_open(tmdy_struct_ex_t *tmdy_struct, URL reader, int autoclose);
extern URL url_b64decode_open(tmdy_struct_ex_t *tmdy_struct, URL reader, int autoclose);
extern URL url_hqxdecode_open(tmdy_struct_ex_t *tmdy_struct, URL reader, int dataonly, int autoclose);
extern URL url_qsdecode_open(tmdy_struct_ex_t *tmdy_struct, URL reader, int autoclose);
extern URL url_cgi_escape_open(tmdy_struct_ex_t *tmdy_struct, URL reader, int autoclose);
extern URL url_cgi_unescape_open(tmdy_struct_ex_t *tmdy_struct, URL reader, int autoclose);

extern char *url_dir_name(tmdy_struct_ex_t *tmdy_struct, URL url);
extern char *url_newsgroup_name(tmdy_struct_ex_t *tmdy_struct, URL url);
extern int url_news_connection_cache(tmdy_struct_ex_t *tmdy_struct, int flag);

extern char *url_lib_version;
extern char *user_mailaddr;
extern char *url_user_agent;
extern char *url_http_proxy_host;
extern unsigned short url_http_proxy_port;
extern char *url_ftp_proxy_host;
extern unsigned short url_ftp_proxy_port;
extern int url_newline_code;
extern int uudecode_unquote_html;

extern struct URL_module URL_module_file;
#ifndef __MACOS__
extern struct URL_module URL_module_dir;
#endif /* __MACOS__ */
#ifdef SUPPORT_SOCKET
extern struct URL_module URL_module_http;
extern struct URL_module URL_module_ftp;
extern struct URL_module URL_module_news;
extern struct URL_module URL_module_newsgroup;
#endif /* SUPPORT_SOCKET */
#ifdef HAVE_POPEN
extern struct URL_module URL_module_pipe;
#endif /* HAVE_POPEN */

/*
#undef timidity_mutex_lock
#undef timidity_mutex_unlock
#define timidity_mutex_lock(_m)
#define timidity_mutex_unlock(_m)
*/
