/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef ___MBLOCK_H_
#define ___MBLOCK_H_


/* Memory block for decreasing malloc
 *
 * +------+    +------+             +-------+
 * |BLOCK1|--->|BLOCK2|---> ... --->|BLOCK N|---> NULL
 * +------+    +------+             +-------+
 *
 *
 * BLOCK:
 * +-----------------------+
 * | memory 1              |
 * |                       |
 * +-----------------------+
 * | memory 2              |
 * +-----------------------+
 * | memory 3              |
 * |                       |
 * |                       |
 * +-----------------------+
 * | unused ...            |
 * +-----------------------+
 */


#define MIN_MBLOCK_SIZE 8192
//#define MIN_MBLOCK_SIZE 0

typedef struct s_MBlockNode
{
    size_t block_size;
    size_t offset;
    struct s_MBlockNode *next;
#ifndef MBLOCK_NOPAD
    void *pad;
#endif /* MBLOCK_NOPAD */
    char buffer[1];
} MBlockNode;

typedef struct s_MBlockList
{
    MBlockNode *first;
    size_t allocated;
} MBlockList;

struct s_mblock_ex_t {

timidity_mutex_t  busy;
void (*init_mblock)(tmdy_struct_ex_t *tmdy_struct, MBlockList *mblock);
void *(*new_segment)(tmdy_struct_ex_t *tmdy_struct, MBlockList *mblock, size_t nbytes);
void (*reuse_mblock)(tmdy_struct_ex_t *tmdy_struct, MBlockList *mblock);
char *(*strdup_mblock)(tmdy_struct_ex_t *tmdy_struct, MBlockList *mblock, const char *str);
int (*free_global_mblock)(tmdy_struct_ex_t *tmdy_struct);

/**** private variables ****/
MBlockNode *free_mblock_list;

};


mblock_ex_t* new_mblock(tmdy_struct_ex_t *tmdy_struct);
void destroy_mblock(mblock_ex_t* mblock);

#endif /* ___MBLOCK_H_ */
