/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    utils_export.h - utils export struct.
Written by Keishi Suenaga(s_keishi@mutt.freemail.ne.jp)
*/

#ifndef ___UTILS_EXPORT_H_
#define ___UTILS_EXPORT_H_

typedef struct _memb_ex_t memb_ex_t;
typedef struct _mblock_ex_t mblock_ex_t;
typedef struct _strtab_ex_t strtab_ex_t;
typedef struct _timer_ex_t timer_ex_t;
#ifdef SUPPORT_SOUNDSPEC
typedef struct _fft_ex_t fft_ex_t;
#endif
typedef struct _fft4g_ex_t fft4g_ex_t;
#ifdef JAPANESE
typedef struct _nkflib_ex_t nkflib_ex_t;
#endif
#ifdef SUPPORT_SOCKET
typedef struct _net_ex_t net_ex_t;
#endif
typedef struct _bitset_ex_t bitset_ex_t;


struct _utils_ex_t {
	
	memb_ex_t *memb;
	mblock_ex_t *mblock;
	strtab_ex_t *strtab;
	timer_ex_t *timer;
#ifdef SUPPORT_SOUNDSPEC
	fft_ex_t *fft;
#endif 

	fft4g_ex_t *fft4g;
#ifdef JAPANESE

	nkflib_ex_t *nkflib;

#endif
#ifdef SUPPORT_SOCKET
	net_ex_t *net;
#endif

	bitset_ex_t *bitset;


};

utils_ex_t* new_utils(tmdy_struct_ex_t *tmdy_struct);
void destroy_utils(utils_ex_t* utils);
/*
if NEEDGETOPT
GETOPT_OBJS = getopt.o
endif

if ENABLE_NETWORK
NET_OBJS = net.o
endif
#ifdef SUPPORT_SOCKET

if ENABLE_SOUND_SPEC
SOUND_SPEC_OBJS = fft.o
endif

if W32READDIR
W32READDIR_OBJS = readdir_win.o
endif
*/
#endif /* ___UTILS_EXPORT_H_ */
