#include <stdio.h>
#include <windows.h>

#include "timidity.h"
#include "common.h"
#include "controls.h"
#include "instrum.h"
#include "playmidi.h"
#include "rtsyn.h"


HANDLE hThread=NULL;
static DWORD dwThreadId;
HANDLE hThread2=NULL;
static DWORD dwThreadId2;
	
DWORD WINAPI ThreadProc1(LPVOID synth)
{
	int i;
   	char *argv[16];
	int argc;
	DWORD	ExitCode;
   	argc=0;
	argv[argc++] = "timidity";
	argv[argc++] = "-Od";
	argv[argc++] = "-iD";
 	argv[argc] = NULL;

	timiditymain(argc, argv);

    GetExitCodeThread(hThread,&ExitCode);
	ExitThread(ExitCode);
}
DWORD WINAPI ThreadProc2(LPVOID synth)
{
	int i;
   	char *argv[16];
	int argc;
	DWORD	ExitCode;
   	argc=0;
	argv[argc++] = "timidity";
	argv[argc++] = "-Od";
	argv[argc++] = "-iD";
 	argv[argc] = NULL;

	timiditymain(argc, argv);

    GetExitCodeThread(hThread2,&ExitCode);
	ExitThread(ExitCode);
}
static void doit(tmdy_struct_ex_t *tmdy_struct,tmdy_struct_ex_t *tmdy_struct2)
{
	int seq_quit=0;
#ifndef __W32__
		init_keybord();
#endif

	while(seq_quit==0){
		if(TMDY_MAIN->intr) seq_quit=~0;
		TMDY_RTSYN->rtsyn_play_some_data(tmdy_struct);
		TMDY_RTSYN->rtsyn_play_calculate(tmdy_struct);
		TMDY_RTSYN->rtsyn_play_some_data(tmdy_struct2);
		TMDY_RTSYN->rtsyn_play_calculate(tmdy_struct2);
#if __W32__
		if(kbhit()){
			switch(getch()){
#else			
		if(kbhit()){
			switch(readch()){
#endif
				case 'Q':
				case 'q':
					seq_quit=~0;
				break;
				case 'm':
					TMDY_RTSYN->rtsyn_gm_reset(tmdy_struct);
				break;
				case 's':
					TMDY_RTSYN->rtsyn_gs_reset(tmdy_struct);
				break;
				case 'x':
					TMDY_RTSYN->rtsyn_xg_reset(tmdy_struct);
				break;
				case 'c':
					TMDY_RTSYN->rtsyn_normal_reset(tmdy_struct);
				break;
				case 'M':
					TMDY_RTSYN->rtsyn_gm_modeset(tmdy_struct);
				break;
				case 'S':
					TMDY_RTSYN->rtsyn_gs_modeset(tmdy_struct);
				break;
				case 'X':
					TMDY_RTSYN->rtsyn_xg_modeset(tmdy_struct);
				break;
				case 'N':
					TMDY_RTSYN->rtsyn_normal_modeset(tmdy_struct);
				break;
			}
		}
		sleep(0);
	}
#ifndef __W32__
	close_keybord();
#endif
}
int main(int argc, char **argv)
{
  tmdy_struct_ex_t *tmdy_struct;
  tmdy_struct_ex_t *tmdy_struct2;
  tmdy_struct_list_t *listbuf;
  int order, cutoff, reso , amp;
  char sf_file[]="e:/soundfont/2GMGSMT.SF2";
  char sf_file2[]="e:/soundfont/Simple.sf2";

	
  tmdy_base_init();
  listbuf = tmdy_struct_list->next;
  hThread=CreateThread(NULL,0,ThreadProc1,(LPVOID)NULL,0,&(dwThreadId));
  while(listbuf==tmdy_struct_list->next){sleep(10);};
  tmdy_struct=tmdy_struct_list->tmdy_struct;

  listbuf= tmdy_struct_list->next;
  hThread2=CreateThread(NULL,0,ThreadProc2,(LPVOID)NULL,0,&(dwThreadId2));
  while(listbuf==tmdy_struct_list->next){sleep(10);};
  tmdy_struct2=tmdy_struct_list->tmdy_struct;
	
	  order = cutoff = reso = amp = -1;
  TMDY_INSTRUM->add_soundfont(tmdy_struct, sf_file,order,cutoff,reso,amp);
  TMDY_INSTRUM->free_instruments(tmdy_struct, 0);
  TMDY_UTILS->mblock->free_global_mblock(tmdy_struct);

  order = cutoff = reso = amp = -1;
  TMDY_INSTRUM->add_soundfont(tmdy_struct2, sf_file2,order,cutoff,reso,amp);	
  Sleep(1000);
	TMDY_RTSYN->rtsyn_init(tmdy_struct);
	TMDY_RTSYN->rtsyn_synth_start(tmdy_struct);

	TMDY_RTSYN->rtsyn_init(tmdy_struct2);
	TMDY_RTSYN->rtsyn_synth_start(tmdy_struct2);



	

	TMDY_RTSYN->rtsyn_add_midi_port(tmdy_struct,4);
	TMDY_RTSYN->rtsyn_add_midi_port(tmdy_struct2,1);
//	TMDY_RTSYN->rtsyn_delete_midi_port(tmdy_struct,4);


	doit(tmdy_struct,tmdy_struct2);
	MidiEvent ev;
 	ev.channel=0x00;
	ev.a=0x3c;
	ev.b=0x7f;
	ev.type = ME_NOTEON;
	ev.time=0.0;
	TMDY_RTSYN->rtsyn_play_event(tmdy_struct,&ev);
	Sleep(500);
	ev.type = ME_NOTEOFF;
	ev.time=0.0;
	TMDY_RTSYN->rtsyn_play_event(tmdy_struct, &ev);
  	Sleep(5000);
	
	TMDY_RTSYN->rtsyn_synth_stop(tmdy_struct);
	TMDY_RTSYN->rtsyn_close(tmdy_struct);
	
	TMDY_RTSYN->rtsyn_synth_stop(tmdy_struct2);
	TMDY_RTSYN->rtsyn_close(tmdy_struct2);

  	TMDY_CONTROLS->ctl->close(tmdy_struct);
  	TMDY_CONTROLS->ctl->close(tmdy_struct2);
 
  	WaitForSingleObject(hThread, INFINITE);
	CloseHandle(hThread);
	WaitForSingleObject(hThread2, INFINITE);
	CloseHandle(hThread);
}
