/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   readmidi.h

   */
#ifndef ___STRTAB_H_
#include "strtab.h"
#endif

#ifndef ___READMIDI_H_
#define ___READMIDI_H_

/* MIDI file types */
#define IS_ERROR_FILE	-1	/* Error file */
#define IS_OTHER_FILE	0	/* Not a MIDI file */
#define IS_SMF_FILE	101	/* Standard MIDI File */
#define IS_MCP_FILE	201	/* MCP */
#define IS_RCP_FILE	202	/* Recomposer */
#define IS_R36_FILE	203	/* Recomposer */
#define IS_G18_FILE	204	/* Recomposer */
#define IS_G36_FILE	205	/* Recomposer */
#define IS_SNG_FILE	301
#define IS_MM2_FILE	401
#define IS_MML_FILE	501
#define IS_FM_FILE	601
#define IS_FPD_FILE	602
#define IS_MOD_FILE	701	/* Pro/Fast/Star/Noise Tracker */
#define IS_669_FILE	702	/* Composer 669, UNIS669 */
#define IS_MTM_FILE	703	/* MultiModuleEdit */
#define IS_STM_FILE	704	/* ScreamTracker 2 */
#define IS_S3M_FILE	705	/* ScreamTracker 3 */
#define IS_ULT_FILE	706	/* UltraTracker */
#define IS_XM_FILE	707	/* FastTracker 2 */
#define IS_FAR_FILE	708	/* Farandole Composer */
#define IS_WOW_FILE	709	/* Grave Composer */
#define IS_OKT_FILE	710	/* Oktalyzer */
#define IS_DMF_FILE	711	/* X-Tracker */
#define IS_MED_FILE	712	/* MED/OctaMED */
#define IS_IT_FILE	713	/* Impulse Tracker */
#define IS_PTM_FILE	714	/* Poly Tracker */
#define IS_MFI_FILE	800	/* Melody Format for i-mode */

enum play_system_modes
{
    DEFAULT_SYSTEM_MODE,
    GM_SYSTEM_MODE,
    GS_SYSTEM_MODE,
    XG_SYSTEM_MODE
};

enum {
    PCM_MODE_NON = 0,
    PCM_MODE_WAV,
    PCM_MODE_AIFF,
    PCM_MODE_AU,
    PCM_MODE_MP3
};

#define IS_CURRENT_MOD_FILE \
	(TMDY_READMIDI->current_file_info && \
	TMDY_READMIDI->current_file_info->file_type >= 700 && \
	TMDY_READMIDI->current_file_info->file_type < 800)

typedef struct {
  MidiEvent event;
  void *next;
  void *prev;
} MidiEventList;

struct midi_file_info
{
    int readflag;
    char *filename;
    char *seq_name;
    char *karaoke_title;
    char *first_text;
    uint8 mid;	/* Manufacture ID (0x41/Roland, 0x43/Yamaha, etc...) */
    int16 hdrsiz;
    int16 format;
    int16 tracks;
    int32 divisions;
    int time_sig_n, time_sig_d, time_sig_c, time_sig_b;	/* Time signature */
    int drumchannels_isset;
    ChannelBitMask drumchannels;
    ChannelBitMask drumchannel_mask;
    int32 samples;
    int max_channel;
    struct midi_file_info *next;
    int compressed; /* True if midi_data is compressed */
    char *midi_data;
    int32 midi_data_size;
    int file_type;
    
    int pcm_mode;
    char *pcm_filename;
    struct timidity_file *pcm_tf;
};

#define alloc_midi_event(_tmdy_struct) \
    (MidiEventList *)_tmdy_struct->utils->mblock->new_segment(_tmdy_struct, &(_tmdy_struct->readmidi->mempool), sizeof(MidiEventList))
    
/**** local structure definitions ****/
typedef struct _UserDrumset {
	int8 bank;
	int8 prog;
	int8 play_note;
	int8 level;
	int8 assign_group;
	int8 pan;
	int8 reverb_send_level;
	int8 chorus_send_level;
	int8 rx_note_off;
	int8 rx_note_on;
	int8 delay_send_level;
	int8 source_map;
	int8 source_prog;
	int8 source_note;
	struct _UserDrumset *next;
} UserDrumset;
typedef struct _UserInstrument {
	int8 bank;
	int8 prog;
	int8 source_map;
	int8 source_bank;
	int8 source_prog;
	int8 vibrato_rate;
	int8 vibrato_depth;
	int8 cutoff_freq;
	int8 resonance;
	int8 env_attack;
	int8 env_decay;
	int8 env_release;
	int8 vibrato_delay;
	struct _UserInstrument *next;
} UserInstrument;

/*rcp.c*/
#define USER_EXCLUSIVE_LENGTH 24
#define MAX_EXCLUSIVE_LENGTH 1024

#define TEMPO_GRADATION_SKIP		2
#define TEMPO_GRADATION_GRADE		600
/* smfconv.c */
typedef struct {
	int type;
    char *ext;
    char *header;
    int len;
}is_midifile_check_t;

struct _readmidi_ex_t {
timidity_mutex_t  busy;
	
ChannelBitMask quietchannels;
struct midi_file_info *current_file_info;
int opt_trace_text_meta_event;
int opt_default_mid;
int opt_system_mid;
int ignore_midi_error;
int readmidi_error_flag;
int readmidi_wrd_mode;
int play_system_mode;
FLOAT_T tempo_adjust;

void (*readmidi_read_init)(tmdy_struct_ex_t *tmdy_struct);
int32 (*readmidi_set_track)(tmdy_struct_ex_t *tmdy_struct, int trackno, int rewindp);
void (*readmidi_add_event)(tmdy_struct_ex_t *tmdy_struct, MidiEvent *newev);
void (*readmidi_add_ctl_event)(tmdy_struct_ex_t *tmdy_struct, int32 at, int ch, int control, int val);
int (*parse_sysex_event)(tmdy_struct_ex_t *tmdy_struct, uint8 *data, int32 datalen, MidiEvent *ev_ret);
int (*parse_sysex_event_multi)(tmdy_struct_ex_t *tmdy_struct, uint8 *data, int32 datalen, MidiEvent *ev_ret);
int (*convert_midi_control_change)(tmdy_struct_ex_t *tmdy_struct, int chn, int type, int val,
				       MidiEvent *ev_ret);
char *(*readmidi_make_string_event)(tmdy_struct_ex_t *tmdy_struct, int type, char *string, MidiEvent *ev,
					int cnv);
MidiEvent *(*read_midi_file)(tmdy_struct_ex_t *tmdy_struct, struct timidity_file *mtf,
				 int32 *count, int32 *sp, char *file_name);
struct midi_file_info *(*get_midi_file_info)(tmdy_struct_ex_t *tmdy_struct, char *filename,int newp);
struct midi_file_info *(*new_midi_file_info)(tmdy_struct_ex_t *tmdy_struct, const char *filename);
void (*free_all_midi_file_info)(tmdy_struct_ex_t *tmdy_struct);
int (*check_midi_file)(tmdy_struct_ex_t *tmdy_struct, char *filename);
char *(*get_midi_title)(tmdy_struct_ex_t *tmdy_struct, char *filename);
struct timidity_file *(*open_midi_file)(tmdy_struct_ex_t *tmdy_struct, char *name,
					    int decompress, int noise_mode);
int (*midi_file_save_as)(tmdy_struct_ex_t *tmdy_struct, char *in_name, char *out_name);
char *(*event2string)(tmdy_struct_ex_t *tmdy_struct, int id);
void (*change_system_mode)(tmdy_struct_ex_t *tmdy_struct, int mode);
int (*get_default_mapID)(tmdy_struct_ex_t *tmdy_struct, int ch);
int (*dump_current_timesig)(tmdy_struct_ex_t *tmdy_struct, MidiEvent *codes, int maxlen);

	
	
	
void (*recompute_delay_status)(tmdy_struct_ex_t *tmdy_struct);
void (*set_delay_macro)(tmdy_struct_ex_t *tmdy_struct, int macro);
void (*recompute_chorus_status)(tmdy_struct_ex_t *tmdy_struct);
void (*set_chorus_macro)(tmdy_struct_ex_t *tmdy_struct, int macro);
void (*recompute_reverb_status)(tmdy_struct_ex_t *tmdy_struct);
void (*set_reverb_macro)(tmdy_struct_ex_t *tmdy_struct, int macro);
void (*recompute_eq_status)(tmdy_struct_ex_t *tmdy_struct);
void (*set_insertion_effect_default_parameter)(tmdy_struct_ex_t *tmdy_struct);
void (*recompute_insertion_effect)(tmdy_struct_ex_t *tmdy_struct);

void (*recompute_userdrum)(tmdy_struct_ex_t *tmdy_struct, int bank, int prog);
void (*free_userdrum)(tmdy_struct_ex_t *tmdy_struct);

void (*recompute_userinst)(tmdy_struct_ex_t *tmdy_struct, int bank, int prog);
void (*free_userinst)(tmdy_struct_ex_t *tmdy_struct);

void (*init_channel_layer)(tmdy_struct_ex_t *tmdy_struct, int);
void (*add_channel_layer)(tmdy_struct_ex_t *tmdy_struct, int, int);
void (*remove_channel_layer)(tmdy_struct_ex_t *tmdy_struct, int);

/**** private valiables ****/
uint8 rhythm_part[2];
MidiEventList *evlist, *current_midi_point;
int32 event_count;
MBlockList mempool;
StringTable string_event_strtab;
int current_read_track;
int karaoke_format, karaoke_title_flag;
struct midi_file_info *midi_file_info;
char **string_event_table;
int    string_event_table_size;
int    default_channel_program[256];
MidiEvent timesig[256];
	
/* MIDI ports will be merged in several channels in the future. */
int midi_port_number;

/* These would both fit into 32 bits, but they are often added in
   large multiples, so it's simpler to have two roomy ints */
int32 sample_increment, sample_correction; /*samples per MIDI delta-t*/

UserDrumset *userdrum_first;
UserDrumset *userdrum_last;
UserInstrument *userinst_first;
UserInstrument *userinst_last;

/* rcp.c */
int (*read_rcp_file)(tmdy_struct_ex_t * tmdy_struct, struct timidity_file *tf, char *magic0, char *fn);
uint8 user_exclusive_data[8][USER_EXCLUSIVE_LENGTH];
int32 init_tempo;
int32 init_keysig;
int play_bias;
char rcp_name[16];
/* smfconv.c */
#ifdef SMFCONV
#ifdef __W32__
int (*is_midifile_filename)(tmdy_struct_ex_t *tmdy_struct, char *filename);
int (*smfconv_w32)(tmdy_struct_ex_t *tmdy_struct, struct timidity_file *tf,char *fn);
#endif /* __W32__ */
#endif /* SMFCONV */
is_midifile_check_t is_midifile_check[6];
/* mfi.c */
int (*read_mfi_file)(tmdy_struct_ex_t * tmdy_struct, struct timidity_file *tf);
char *(*get_mfi_file_title)(tmdy_struct_ex_t * tmdy_struct, struct timidity_file *tf);



};

readmidi_ex_t* new_readmidi(tmdy_struct_ex_t *tmdy_struct);
void destroy_readmidi(readmidi_ex_t* readmidi);


#define MAX_MIDI_EVENT ((MAX_SAFE_MALLOC_SIZE / sizeof(MidiEvent)) - 1)
#define MARKER_START_CHAR	'('
#define MARKER_END_CHAR		')'
#define REDUCE_CHANNELS		16





#endif /* ___READMIDI_H_ */
