/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ___MOD_H_
#define ___MOD_H_

#include "output.h"
#include "controls.h"
#include "unimod.h"
#include "unimod_priv.h"
//#include "mod2midi.h"

#define MOD_NUM_VOICES	MAX_CHANNELS

/***** private definitions ****/
#define POS_NONE        (-2)	/* no loop position defined */

typedef struct ENVPR
{
  UBYTE flg;			/* envelope flag */
  UBYTE pts;			/* number of envelope points */
  UBYTE susbeg;			/* envelope sustain index begin */
  UBYTE susend;			/* envelope sustain index end */
  UBYTE beg;			/* envelope loop begin */
  UBYTE end;			/* envelope loop end */
  SWORD p;			/* current envelope counter */
  UWORD a;			/* envelope index a */
  UWORD b;			/* envelope index b */
  ENVPT *env;			/* envelope points */
}
ENVPR;

typedef struct MP_CONTROL
  {
    INSTRUMENT *i;
    SAMPLE *s;
    UBYTE sample;		/* which sample number */
    UBYTE note;			/* the audible note as heard, direct rep of period */
    SWORD outvolume;		/* output volume (vol + sampcol + instvol) */
    SBYTE chanvol;		/* channel's "global" volume */
    UWORD fadevol;		/* fading volume rate */
    SWORD panning;		/* panning position */
    UBYTE kick;			/* if true = sample has to be restarted */
    UWORD period;		/* period to play the sample at */
    UBYTE nna;			/* New note action type + master/slave flags */

    UBYTE volflg;		/* volume envelope settings */
    UBYTE panflg;		/* panning envelope settings */
    UBYTE pitflg;		/* pitch envelope settings */

    UBYTE keyoff;		/* if true = fade out and stuff */
    SWORD *data;		/* which sample-data to play */
    UBYTE notedelay;		/* (used for note delay) */
    SLONG start;		/* The starting byte index in the sample */

    UWORD ultoffset;		/* fine sample offset memory */

    struct MP_VOICE *slave;	/* Audio Slave of current effects control channel */
    UBYTE slavechn;		/* Audio Slave of current effects control channel */
    UBYTE anote;		/* the note that indexes the audible */
    UBYTE oldnote;
    SWORD ownper;
    SWORD ownvol;
    UBYTE dca;			/* duplicate check action */
    UBYTE dct;			/* duplicate check type */
    UBYTE *row;			/* row currently playing on this channel */
    SBYTE retrig;		/* retrig value (0 means don't retrig) */
    ULONG speed;		/* what finetune to use */
    SWORD volume;		/* amiga volume (0 t/m 64) to play the sample at */

    SWORD tmpvolume;		/* tmp volume */
    UWORD tmpperiod;		/* tmp period */
    UWORD wantedperiod;		/* period to slide to (with effect 3 or 5) */

    UBYTE arpmem;		/* arpeggio command memory */
    UBYTE pansspd;		/* panslide speed */
    UWORD slidespeed;		/* */
    UWORD portspeed;		/* noteslide speed (toneportamento) */

    UBYTE s3mtremor;		/* s3m tremor (effect I) counter */
    UBYTE s3mtronof;		/* s3m tremor ontime/offtime */
    UBYTE s3mvolslide;		/* last used volslide */
    SBYTE sliding;
    UBYTE s3mrtgspeed;		/* last used retrig speed */
    UBYTE s3mrtgslide;		/* last used retrig slide */

    UBYTE glissando;		/* glissando (0 means off) */
    UBYTE wavecontrol;

    SBYTE vibpos;		/* current vibrato position */
    UBYTE vibspd;		/* "" speed */
    UBYTE vibdepth;		/* "" depth */

    SBYTE trmpos;		/* current tremolo position */
    UBYTE trmspd;		/* "" speed */
    UBYTE trmdepth;		/* "" depth */

    UBYTE fslideupspd;
    UBYTE fslidednspd;
    UBYTE fportupspd;		/* fx E1 (extra fine portamento up) data */
    UBYTE fportdnspd;		/* fx E2 (extra fine portamento dn) data */
    UBYTE ffportupspd;		/* fx X1 (extra fine portamento up) data */
    UBYTE ffportdnspd;		/* fx X2 (extra fine portamento dn) data */

    ULONG hioffset;		/* last used high order of sample offset */
    UWORD soffset;		/* last used low order of sample-offset (effect 9) */

    UBYTE sseffect;		/* last used Sxx effect */
    UBYTE ssdata;		/* last used Sxx data info */
    UBYTE chanvolslide;		/* last used channel volume slide */

    UBYTE panbwave;		/* current panbrello waveform */
    UBYTE panbpos;		/* current panbrello position */
    SBYTE panbspd;		/* "" speed */
    UBYTE panbdepth;		/* "" depth */

    UWORD newsamp;		/* set to 1 upon a sample / inst change */
    UBYTE voleffect;		/* Volume Column Effect Memory as used by IT */
    UBYTE voldata;		/* Volume Column Data Memory */

    SWORD pat_reppos;		/* patternloop position */
    UWORD pat_repcnt;		/* times to loop */
  }
MP_CONTROL;

/* Used by NNA only player (audio control.  MP_CONTROL is used for full effects
   control). */
typedef struct MP_VOICE
  {
    INSTRUMENT *i;
    SAMPLE *s;
    UBYTE sample;		/* which instrument number */

    SWORD volume;		/* output volume (vol + sampcol + instvol) */
    SWORD panning;		/* panning position */
    SBYTE chanvol;		/* channel's "global" volume */
    UWORD fadevol;		/* fading volume rate */
    UWORD period;		/* period to play the sample at */

    UBYTE volflg;		/* volume envelope settings */
    UBYTE panflg;		/* panning envelope settings */
    UBYTE pitflg;		/* pitch envelope settings */

    UBYTE keyoff;		/* if true = fade out and stuff */
    UBYTE kick;			/* if true = sample has to be restarted */
    UBYTE note;			/* the audible note (as heard, direct rep of period) */
    UBYTE nna;			/* New note action type + master/slave flags */
    SWORD *data;		/* which sample-data to play */
    SLONG start;		/* The start byte index in the sample */

/* Below here is info NOT in MP_CONTROL!! */
    ENVPR venv;
    ENVPR penv;
    ENVPR cenv;

    UWORD avibpos;		/* autovibrato pos */
    UWORD aswppos;		/* autovibrato sweep pos */

    ULONG totalvol;		/* total volume of channel (before global mixings) */

    BOOL mflag;
    SWORD masterchn;
    UWORD masterperiod;

    MP_CONTROL *master;		/* index of "master" effects channel */
  }
MP_VOICE;

typedef struct MP_STATUS
  {
    SWORD channel;		/* channel we're working on */
    UWORD oldsngspd;		/* old song speed */
    UWORD sngspd;		/* current song speed */
    SWORD volume;		/* song volume (0-128) (or user volume) */
    UWORD bpm;			/* current beats-per-minute speed */
    UWORD newbpm;		/* next beats-per-minute speed */

    UBYTE realchn;		/* real number of channels used */
    UBYTE totalchn;		/* total number of channels used (incl NNAs) */

    UWORD patpos;		/* current row number */
    SWORD sngpos;		/* current song position */

    UWORD numrow;		/* number of rows on current pattern */
    UWORD vbtick;		/* tick counter (counts from 0 to sngspd) */

    struct MP_CONTROL *control;	/* Effects Channel info (size pf->numchn) */
    struct MP_VOICE voice[MOD_NUM_VOICES];	/* Audio Voice information */

    UBYTE globalslide;		/* global volume slide rate */
    UBYTE pat_repcrazy;		/* module has just looped to position -1 */
    UWORD patbrk;		/* position where to start a new pattern */
    UBYTE patdly;		/* patterndelay counter (command memory) */
    UBYTE patdly2;		/* patterndelay counter (real one) */
    SWORD posjmp;		/* flag to indicate a jump is needed... */
    int explicitslides;
  }
MP_STATUS;

struct _mod_ex_t {
	timidity_mutex_t  busy;
	int (*get_module_type)(tmdy_struct_ex_t* tmdy_struct, char *fn);
	int (*load_module_file)(tmdy_struct_ex_t* tmdy_struct, struct timidity_file *tf, int mod_type);
	char *(*get_module_title )(tmdy_struct_ex_t* tmdy_struct, struct timidity_file *tf, int mod_type);

	/**** private variables ****/
	MODULE *pf;		/* modfile being played */
	MP_CONTROL *a;		/* current AUDTMP we're working on */
	MP_STATUS mp;		/* player status */

};


mod_ex_t* new_mod(tmdy_struct_ex_t *tmdy_struct);
void destroy_mod(mod_ex_t* mod);

#endif /* ___MOD_H_ */
