/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: NPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is 
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or 
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __PLUGIN_H__
#define __PLUGIN_H__

#include "npapi.h"
#include "nsScriptablePeer.h"

typedef enum { PLUGIN_PLAYING, PLUGIN_STOPPED, PLUGIN_PAUSED } pluginPlayState;
class CPlugin
{
private:
  NPP m_pNPInstance;
//  HWND m_hWnd;    moved to public
  NPWindow * m_Window;
  NPStream * m_pNPStream;
  NPBool m_bInitialized;
  nsIWinumpPlugin * m_pScriptablePeer;
	
public:
  HWND m_hWnd;   //    WinUMP added followings
  int fd; /* file descriptor for temp file */
  char filename[256]; /* name of same */
  pluginPlayState pluginState; /* stopped, paused, or playing */
  int loop; /* 0 means play only once, non-zero means loop forever */
  short int PlayId;
  int     XO,YO;
  int     X_Base,Y_Base;
  int     X_Minus,Y_Minus;
  int     X_Pause,Y_Pause;
  int     X_Play,Y_Play;
  int     X_Plus,Y_Plus;
  int     X_Stop,Y_Stop;
  int     X_Title,Y_Title;	
  HWND hMinusButton;
  HWND hPauseButton;
  HWND hPlayButton;
  HWND hPlusButton;
  HWND hStopButton;
  HBITMAP hBase;
  HBITMAP hMinus;
  HBITMAP hPause;
  HBITMAP hPlay;
  HBITMAP hPlus;
  HBITMAP hStop;
  HBITMAP hTitle;
  HBITMAP hPauseOn;
  HBITMAP hPlayOn;

  HANDLE hFileMap1; //}bsOIuWFNg̃nh
  LPVOID MapAdress;

public:
  CPlugin(NPP pNPInstance);
  ~CPlugin();

  NPBool init(NPWindow* pNPWindow);
  void shut();
  NPBool isInitialized();
  
  int16 handleEvent(void* event);
  void getmap();
  void releasemap();
  void loadBitmaps();
  void makebuttons(HWND);
  void DrawBase(HWND);
  void DrawButtons();
  void CPlugin::plusMidiPlayer();
  void CPlugin::minusMidiPlayer();
  void CPlugin::pauseMidiPlayer();
  void CPlugin::stopMidiPlayer();
  void CPlugin::kstopMidiPlayer();
  void CPlugin::startMidiPlayer();
  void CPlugin::pausebutton();
  void CPlugin::playbutton();
  void CPlugin::plusbutton();
  void CPlugin::minusbutton();
  void CPlugin::stopbutton();

  nsIWinumpPlugin* getScriptablePeer();
};

#endif // __PLUGIN_H__
