#ifndef _TIMIDITY_MAIN_H
#define _TIMIDITY_MAIN_H

#include "sysdep.h"
#ifdef __W32__
#include <windows.h>
#endif

#include "url.h"
#include "mblock.h"
#include "strtab.h"

struct _timidity_main_ex_t {

void (*timidity_start_initialize)(tmdy_struct_ex_t *timdy_struct);
int (*timidity_pre_load_configuration)(tmdy_struct_ex_t *timdy_struct);
int (*timidity_post_load_configuration)(tmdy_struct_ex_t *timdy_struct);
void (*timidity_init_player)(tmdy_struct_ex_t *timdy_struct);
int (*timidity_play_main)(tmdy_struct_ex_t *timdy_struct, int nfiles, char **files);

int got_a_configuration;
char *wrdt_open_opts;
char *opt_aq_max_buff;
char *opt_aq_fill_buff;
void (*timidity_init_aq_buff)(tmdy_struct_ex_t *timdy_struct);
int opt_control_ratio; /* Save -C option */

int (*set_extension_modes)(tmdy_struct_ex_t *timdy_struct,char *);
int (*set_ctl)(tmdy_struct_ex_t *timdy_struct,char *);
int (*set_play_mode)(tmdy_struct_ex_t *timdy_struct, char *);
int (*set_wrd)(tmdy_struct_ex_t *timdy_struct, char *);
int (*set_tim_opt_short)(tmdy_struct_ex_t *timdy_struct, int, char *);
int (*set_tim_opt_long)(tmdy_struct_ex_t *timdy_struct, int, char *, int);

#ifdef IA_DYNAMIC
char *(*dynamic_interface_module)(tmdy_struct_ex_t *timdy_struct, int);
#endif
int (*read_config_file)(tmdy_struct_ex_t *timdy_struct, char *name, int self);

#ifdef IA_DYNAMIC
char dynamic_interface_id;
#endif /* IA_DYNAMIC */

struct URL_module *url_module_list[16];

int free_instruments_afterwards;
int def_prog;
char def_instr_name[256];

#ifdef __W32__
CRITICAL_SECTION critSect;
#endif

int effect_lr_mode;
/* 0: left delay
 * 1: right delay
 * 2: rotate
 * -1: not use
 */
int effect_lr_delay_msec;

char* pcm_alternate_file;
/* NULL, "none": disabled (default)
 * "auto":       automatically selected
 * filename:     use the one.
 */


/**** private variables ****/
#ifdef IA_DYNAMIC
char *dynamic_lib_root;
#endif /* IA_DYNAMIC */
VOLATILE int intr;
int rcf_count;

#ifdef __W32__
int opt_evil_mode;
#ifdef SMFCONV
int opt_rcpcv_dll;
#endif	/* SMFCONV */
#endif	/* __W32__ */
int   try_config_again;
int32 opt_output_rate;
char *opt_output_name;
StringTable opt_config_string;
#ifdef SUPPORT_SOUNDSPEC
double spectrogram_update_sec;
#endif /* SUPPORT_SOUNDSPEC */
int opt_buffer_fragments;
char *help_args[3];
#ifdef IA_DYNAMIC
char dynamic_libinfo[MAXPATHLEN];
char dynamic_lib_shared_library[MAXPATHLEN];
#endif
int s_i_drums[MAX_CHANNELS]; 
int s_i_is_first;  

#if defined ( IA_W32GUI ) || defined ( IA_W32G_SYN )
int CoInitializeOK;
#endif
int maincnt;

};


timidity_main_ex_t* new_timidity_main(tmdy_struct_ex_t *tmdy_struct);
void destroy_timidity_main(timidity_main_ex_t* timidity_main);


#endif /* _TIMIDITY_MAIN_H */
