/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


   common.h
*/

#ifndef ___COMMON_H_
#define ___COMMON_H_


#include "url.h"
#include "mblock.h"
#include "strtab.h"

typedef struct {
  char *path;
  void *next;
} PathList;

struct timidity_file
{
    URL url;
    char *tmpname;
};

/* Noise modes for open_file */
#define OF_SILENT	0
#define OF_NORMAL	1
#define OF_VERBOSE	2

#define tf_getc(tf) ( TMDY_ARC->url->url_getc(tmdy_struct, (tf)->url) )

extern char *timidity_version; /*version.c*/

struct _common_ex_t {

char *program_name, current_filename[1024];
const char **note_name;

char *timidity_version;
MBlockList tmpbuffer;
char *output_text_code;


void (*add_to_pathlist)(tmdy_struct_ex_t * tmdy_struct, char *s);
void (*clean_up_pathlist)(tmdy_struct_ex_t * tmdy_struct);
struct timidity_file *(*open_file)(tmdy_struct_ex_t * tmdy_struct, char *name,
				       int decompress, int noise_mode);
struct timidity_file *(*open_with_mem)(tmdy_struct_ex_t * tmdy_struct, char *mem, int32 memlen,
					   int noise_mode);
void (*close_file)(tmdy_struct_ex_t * tmdy_struct, struct timidity_file *tf);
void (*skip)(tmdy_struct_ex_t * tmdy_struct, struct timidity_file *tf, size_t len);
char *(*tf_gets)(tmdy_struct_ex_t * tmdy_struct, char *buff, int n, struct timidity_file *tf);
long (*tf_read)(tmdy_struct_ex_t * tmdy_struct, void *buff, int32 size, int32 nitems,
		    struct timidity_file *tf);
long (*tf_seek)(tmdy_struct_ex_t * tmdy_struct, struct timidity_file *tf, long offset, int whence);
long (*tf_tell)(tmdy_struct_ex_t * tmdy_struct, struct timidity_file *tf);
int (*int_rand)(tmdy_struct_ex_t * tmdy_struct, int n);	/* random [0..n-1] */
int (*check_file_extension)(tmdy_struct_ex_t * tmdy_struct, char *filename, char *ext, int decompress);

void *(*safe_malloc)(tmdy_struct_ex_t * tmdy_struct, size_t count);
void *(*safe_realloc)(tmdy_struct_ex_t * tmdy_struct, void *old_ptr, size_t new_size);
void *(*safe_large_malloc)(tmdy_struct_ex_t * tmdy_struct, size_t count);
char *(*safe_strdup)(tmdy_struct_ex_t * tmdy_struct, const char *s);
void (*free_ptr_list)(tmdy_struct_ex_t * tmdy_struct, void *ptr_list, int count);
char **(*expand_file_archives)(tmdy_struct_ex_t * tmdy_struct, char **files, int *nfiles_in_out);
void (*randomize_string_list)(tmdy_struct_ex_t * tmdy_struct, char **strlist, int nstr);
int (*pathcmp)(tmdy_struct_ex_t * tmdy_struct, const char *path1, const char *path2, int ignore_case);
void (*sort_pathname)(tmdy_struct_ex_t * tmdy_struct, char **files, int nfiles);
int  (*load_table)(tmdy_struct_ex_t * tmdy_struct, char *file);
char *(*pathsep_strrchr)(tmdy_struct_ex_t * tmdy_struct, const char *path);
char *(*pathsep_strchr)(tmdy_struct_ex_t * tmdy_struct, const char *path);
int (*str2mID)(tmdy_struct_ex_t * tmdy_struct, char *str);


/* code:
 * "EUC"	- Extended Unix Code
 * NULL		- Auto conversion
 * "JIS"	- Japanese Industrial Standard code
 * "SJIS"	- shift-JIS code
 */
void (*code_convert)(tmdy_struct_ex_t * tmdy_struct, char *in, char *out, int outsiz,
			 char *in_code, char *out_code);

void (*safe_exit)(tmdy_struct_ex_t * tmdy_struct, int status);

/**** private valiables ***/
int open_file_noise_mode;
/*tmdy_mkstemp*/
uint32 value;
/*safe_malloc */
int safe_malloc_errflag;
/*safe_large_malloc*/
int safe_large_malloc_errflag;
/*safe_realloc*/
int safe_realloc_errflag;
/*safe_strdup*/
int safe_strdup_errflag;
/*code_convert_japan*/
char *mode, *wrd_mode;
/*expand_file_lists*/
StringTable e_f_l_st;
int error_outflag;
int depth;
	
/* The paths in this list will be tried whenever we're reading a file */
PathList defaultpathlist;
PathList *pathlist; /* This is a linked list */

};


common_ex_t* new_common(tmdy_struct_ex_t *tmdy_struct);
void destroy_common(common_ex_t* common);


#endif /* ___COMMON_H_ */
