/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    aq.h - Audio queue.
	   Written by Masanao Izumo <mo@goice.co.jp>
*/

#ifndef ___AQ_H_
#define ___AQ_H_

typedef struct _AudioBucket
{
    char *data;
    int len;
    struct _AudioBucket *next;
} AudioBucket;


struct _aq_ex_t {
timidity_mutex_t  busy;
	
/* interfaces */

int (*aq_calc_fragsize)(tmdy_struct_ex_t *tmdy_struct);
/* aq_calc_fragsize() calculates the best fragment size for audio device.
 */

void (*aq_setup)(tmdy_struct_ex_t *tmdy_struct);
/* aq_setup() allocates the buffer for software queue, and estimate
 * maxmum queue size of audio device.
 */

void (*aq_set_soft_queue)(tmdy_struct_ex_t *tmdy_struct, double soft_buff_time, double fill_start_time);
/* aq_set_soft_queue() makes software audio queue.
 * If fill_start_time is positive, TiMidity doesn't start playing immidiately
 * until the autio buffer is filled.
 */

int (*aq_add)(tmdy_struct_ex_t *tmdy_struct, int32 *samples, int32 count);
/* aq_add() adds new samples to software queue.  If samples is NULL,
 * aq_add() only updates internal software queue buffer.
 */

int32 (*aq_samples)(tmdy_struct_ex_t *tmdy_struct);
/* aq_samples() returns number of samples which is really played out.
 */

int32 (*aq_filled)(tmdy_struct_ex_t *tmdy_struct);
int32 (*aq_soft_filled)(tmdy_struct_ex_t *tmdy_struct);
/* aq_filled() returns filled queue length of audio device.
 * aq_soft_filled() returns filled queue length of software buffer.
 */

int32 (*aq_fillable)(tmdy_struct_ex_t *tmdy_struct);
/* aq_fillable() returns fillable queue length of qudio device. */

int (*aq_flush)(tmdy_struct_ex_t *tmdy_struct, int discard);
/* If discard is true, aq_flush() discards all audio queue and returns
 * immediately, otherwise aq_flush() waits until play all out.
 * aq_flush() returns RC_* message.
 */

int (*aq_soft_flush)(tmdy_struct_ex_t *tmdy_struct);
/* aq_soft_flush() transfers all buffer to device */

int (*aq_fill_nonblocking)(tmdy_struct_ex_t *tmdy_struct);
/* aq_fill_nonblocking() transfers software audio buffer to device.
 * This function doesn't block if (play_mode->flag&PF_CAN_TRACE) is true.
 */

double (*aq_filled_ratio)(tmdy_struct_ex_t *tmdy_struct);
/* aq_filled_ratio() returns filled ratio for audio device queue. */

int (*aq_get_dev_queuesize)(tmdy_struct_ex_t *tmdy_struct);
/* aq_get_dev_queuesize() returns device audio queue length
 */

int aq_fill_buffer_flag;
/* non-zero if aq_add() is in filling mode */

/* effect.c */
int noise_sharp_type;
void (*init_effect)(tmdy_struct_ex_t *tmdy_struct);
void (*do_effect)(tmdy_struct_ex_t *tmdy_struct, int32* buf, int32 count);
	
	
/**  local variables **/
int32 device_qsize;
int Bps;	/* Bytes per sample frame */
int bucket_size;
int nbuckets;
double bucket_time;
int32 aq_start_count;
int32 aq_add_count;

int32 play_counter, play_offset_counter;
double play_start_time;
AudioBucket *base_buckets;
AudioBucket *allocated_bucket_list;
AudioBucket *head;
AudioBucket *tail;

double last_soft_buff_time, last_fill_start_time;

/* effect.c */
int32 ns_z0[4];
int32 ns_z1[4];
int32 ns9_order;
int32 ns9_histposl, ns9_histposr;
int32 ns9_ehl[18];
int32 ns9_ehr[18];
uint32 ns9_r1l, ns9_r2l, ns9_r1r, ns9_r2r;

int32 ns9_c[9];

int32 elrd_prev[AUDIO_BUFFER_SIZE * 2];
int elrd_turn_counter, elrd_tc;
int elrd_status;
double elrd_rate0, elrd_rate1, elrd_dr;
};


aq_ex_t* new_aq(tmdy_struct_ex_t *tmdy_struct);
void destroy_aq(aq_ex_t* aq);

#endif /* ___AQ_H_ */
