/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ___WRD_H_
#define ___WRD_H_


#define WRD_MAXPARAM 32
#define WRD_MAXFADESTEP 12

#define WRD_GSCR_WIDTH 640	/* Graphics screen width in pixel */
#define WRD_GSCR_HEIGHT 400	/* Graphics screen height in pixcel */
#define WRD_TSCR_WIDTH 80	/* Text screen width in character */
#define WRD_TSCR_HEIGHT 25	/* Text screen height in character */

#define WRD_TEXT_COLOR0 "black"
#define WRD_TEXT_COLOR1 "red"
#define WRD_TEXT_COLOR2 "green"
#define WRD_TEXT_COLOR3 "yellow"
#define WRD_TEXT_COLOR4 "blue"
#define WRD_TEXT_COLOR5 "magenta"
#define WRD_TEXT_COLOR6 "cyan"
#define WRD_TEXT_COLOR7 "white"

/*sherry data is little endian*/
#define SRY_GET_SHORT(charp)  ( (charp)[0]+((charp)[1]<<8) ) 


enum wrd_token_type
{
    WRD_COMMAND,	/* Standart command */
    WRD_ECOMMAND,	/* Ensyutsukun */
    WRD_STEP,
    WRD_LYRIC,
    WRD_EOF,

    /* WRD Commands */
    WRD_COLOR, WRD_END, WRD_ESC, WRD_EXEC, WRD_FADE, WRD_GCIRCLE,
    WRD_GCLS, WRD_GINIT, WRD_GLINE, WRD_GMODE, WRD_GMOVE, WRD_GON,
    WRD_GSCREEN, WRD_INKEY, WRD_LOCATE, WRD_LOOP, WRD_MAG, WRD_MIDI,
    WRD_OFFSET, WRD_PAL, WRD_PALCHG, WRD_PALREV, WRD_PATH, WRD_PLOAD,
    WRD_REM, WRD_REMARK, WRD_REST, WRD_SCREEN, WRD_SCROLL, WRD_STARTUP,
    WRD_STOP, WRD_TCLS, WRD_TON, WRD_WAIT, WRD_WMODE,

    /* WRD Ensyutsukun Commands */
    WRD_eFONTM, WRD_eFONTP, WRD_eFONTR, WRD_eGSC, WRD_eLINE, WRD_ePAL,
    WRD_eREGSAVE, WRD_eSCROLL, WRD_eTEXTDOT, WRD_eTMODE, WRD_eTSCRL,
    WRD_eVCOPY, WRD_eVSGET, WRD_eVSRES, WRD_eXCOPY,

    /* WRD Extensionals */
    WRD_ARG,
    WRD_FADESTEP,
    WRD_OUTKEY,
    WRD_NL,
    WRD_MAGPRELOAD,
    WRD_PHOPRELOAD,
    WRD_START_SKIP,
    WRD_END_SKIP,
    WRD_SHERRY_UPDATE,		/* Update real screen of Sherry */

    WRD_NOARG = 0x7FFF
};

typedef struct _WRDTracer
{
    char *name;			/* Tracer name */
    int id;			/* ID */
    int opened;			/* 0:closed 1:opened */

    /* Initialize tracer environment
     * open() calls at first once.
     */
    int (* open)(tmdy_struct_ex_t *tmdy_struct, char *wrdt_opts);

    /* apply() evaluates MIMPI WRD command. */
    /* wrd_argv[0] means WRD command, and the rests means the arguments */
    void (* apply)(tmdy_struct_ex_t *tmdy_struct, int cmd, int wrd_argc, int wrd_argv[]);

    /* sherry() evaluates Sherry WRD command. */
    void (* sherry)(tmdy_struct_ex_t *tmdy_struct, uint8 *data, int len);

    /* Update window events */
    void (* update_events)(tmdy_struct_ex_t *tmdy_struct);

    /* start() calls at each end of MIDI reading.
     * If it is error, start() returns -1, otherwise return 0.
     * If start() returns -1, TiMidity strips all WRD command.
     */
    int (* start)(tmdy_struct_ex_t *tmdy_struct, int wrd_mode);
#define WRD_TRACE_NOTHING	0
#define WRD_TRACE_MIMPI		1
#define WRD_TRACE_SHERRY	2

    /* end() calls at each end of playing */
    void (* end)(tmdy_struct_ex_t *tmdy_struct);

    /* close() calls at last before exit */
    void (* close)(tmdy_struct_ex_t *tmdy_struct);
} WRDTracer;

typedef struct _sry_datapacket
{
    int32  len;
    uint8 *data;
} sry_datapacket;



/**** private difinitions ****/
#include "common.h"
#include "readmidi.h"

/* word_read.c */
/*#define DEBUG 1*/

#if  defined(JAPANESE) || defined(__MACOS__)
#define IS_MULTI_BYTE(c)	( ((c)&0x80) && ((0x1 <= ((c)&0x7F) && ((c)&0x7F) <= 0x1f) ||\
				 (0x60 <= ((c)&0x7F) && ((c)&0x7F) <= 0x7c)))
#define IS_SJIS_ZENKAKU_SPACE(p) ((p)[0] == 0x81 && (p)[1] == 0x40)
#else
#define IS_MULTI_BYTE(c)	0
#endif /* JAPANESE */

#define WRDENDCHAR 26 /* ^Z */
#define MAXTOKLEN 255
#define MAXTIMESIG 256

/* Current max code: 13 */

#define FADE_SPEED_BASE 24 /* 24 or 48?? */

struct wrd_delayed_event
{
    int32 waittime;
    int cmd, arg;
    struct wrd_delayed_event* next;
};

struct wrd_step_tracer
{
    int32 at;		/* total step count */
    int32 last_at;	/* estimated maxmum steps */
    int32 step_inc;	/* increment steps per newline or character */
    int bar;		/* total bar count */
    int step;		/* step in current bar */
    int barstep;	/* step count of current bar */
    MidiEvent timesig[MAXTIMESIG]; /* list of time signature code */
    int timeidx;	/* index of current timesig */
    int ntimesig;	/* number of time signatures */
    int timebase;	/* divisions */
    int offset;		/* @OFFSET */
    int wmode0, wmode1;	/* @WMODE */

    /* Delayed MIDI event list */
    struct wrd_delayed_event *de;
    struct wrd_delayed_event *free_de;

    MBlockList pool;	/* memory buffer */
};
/* wrdt.c */
extern WRDTracer dumb_wrdt_mode;

#ifdef __MACOS__
extern WRDTracer mac_wrdt_mode;
#endif

extern WRDTracer null_wrdt_mode; 

extern WRDTracer tty_wrdt_mode;

#ifdef WRDT_X
extern WRDTracer x_wrdt_mode;
#endif /* WRDT_X */

#if defined(__W32__) && !defined(IA_W32GUI) && !defined(IA_W32G_SYN)
extern WRDTracer wcon_wrdt_mode; /* wrdt_wcon.c */
#endif /* __W32__ */
#if defined(__W32__) && defined(IA_W32GUI)
extern WRDTracer w32g_wrdt_mode; /* wrdt_w32g.c */
#endif /* __W32__ */
#if defined(__W32__) && defined(IA_W32G_SYN)
extern WRDTracer null_wrdt_mode;
#endif /* __W32__ */


//extern int wrd_read_sherry;  /* I can't find this. */
//void *wrd_sherry_data;		 /* I can't find this. */

struct _wrd_ex_t {
/* wrdt.c */
WRDTracer *wrdt_list[16];
WRDTracer *wrdt;
int wrd_color_remap[8];
int wrd_plane_remap[8];
/* word_read.c */
sry_datapacket *datapacket;

/* word_read.c */
int (*import_wrd_file)(tmdy_struct_ex_t* tmdy_struct, char *fn);/*wrd_read.c*/

/*wrdt.c */
void (*wrd_init_path)(tmdy_struct_ex_t* tmdy_struct);
void (*wrd_add_path)(tmdy_struct_ex_t* tmdy_struct, char *path, int pathlen_opt);
void (*wrd_add_default_path)(tmdy_struct_ex_t* tmdy_struct, char *path);
struct timidity_file *(*wrd_open_file)(tmdy_struct_ex_t* tmdy_struct, char *filename);
void (*wrd_midi_event)(tmdy_struct_ex_t* tmdy_struct, int cmd, int arg);
void (*wrd_sherry_event)(tmdy_struct_ex_t* tmdy_struct, int addr);

//void (*sry_encode_bindata)( char *code, const char *org, int len);
//int (*sry_decode_bindata)( char *data );

/**** private variables ****/
/* word_read.c */
int mimpi_bug_emulation_level;
int wrd_bugstatus;
int wrd_wmode_prev_step;
StringTable wrd_read_opts;
int version;	
MBlockList sry_pool; /* data buffer */
#ifdef ENABLE_SHERRY
int datapacket_len, datapacket_cnt;
#endif /* ENABLE_SHERRY */

/*wrdt.c */
uint8 wrd_tokval[MAXTOKLEN + 1]; /* Token value */
uint8 wrd_tok;		/* Token type */
int lineno;		/* linenumber */
int32 last_event_time;

int sherry_started;	/* 0 - before start command 0x01*/
				/* 1 - after start command 0x01*/

int sry_timebase_mode; /* 0 is default */

int wrd_name_string_initflag;
char *wrd_name_string_default_wrd_file1; /* Default */
char	*wrd_name_string_default_wrd_file2; /* Always */
	
int wrd_nexttok_waitflag;
uint8 wrd_nexttok_linebuf[MAXTOKLEN + 16]; /* Token value */
int wrd_nexttok_tokp;

};


wrd_ex_t* new_wrd(tmdy_struct_ex_t *tmdy_struct);
void destroy_wrd(wrd_ex_t* wrd);


#endif /* ___WRD_H_ */
