#include <stdio.h>
#include <windows.h>
#include "./include/fluidsynth.h"
#include "./fluid_synth.h"

#include "timidity.h"
#include "common.h"
#include "controls.h"
#include "instrum.h"
#include "playmidi.h"
#include "rtsyn.h"

int main(int argc, char **argv)
{
  fluid_settings_t *settings;
  fluid_synth_t *synth;
  int order, cutoff, reso , amp;
  char sf_file[]="e:/soundfont/2GMGSMT.SF2";
  char sf_file2[]="e:/soundfont/8MBGMSFX.SF2";
  settings = new_fluid_settings ();
	
  synth = new_fluid_synth (settings);

// AT least one sound font is neetd to make timidity to ready 
  order = cutoff = reso = amp = -1;
  synth->instrum->add_soundfont(sf_file,order,cutoff,reso,amp);

//wait for ready
while(*(synth->rtsyn->rtsyn_seq_quit_p)==1) Sleep(1);

  order = cutoff = reso = amp = -1;
  synth->instrum->add_soundfont(sf_file2,order,cutoff,reso,amp);	
	
//   Sleep(2000);

	synth->rtsyn->rtsyn_add_midi_port(1);
	synth->rtsyn->rtsyn_add_midi_port(4);
	synth->rtsyn->rtsyn_delete_midi_port(4);

	MidiEvent ev;
 	ev.channel=0x00;
	ev.a=0x3c;
	ev.b=0x7f;
	ev.type = ME_NOTEON;
	ev.time=0.0;
	synth->rtsyn->rtsyn_play_event(&ev);
	Sleep(500);
	ev.type = ME_NOTEOFF;
	synth->rtsyn->rtsyn_play_event(&ev);
		fluid_synth_noteon(synth, 0x00, 0x3c, 0x7f);
	Sleep(500);
	fluid_synth_noteoff(synth, 0x00, 0x3c);
  while(1){sleep(1);};
}
