/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   playmidi_export.h

   */

#ifndef ___PLAYMIDI_EXPORT_H_
#define ___PLAYMIDI_EXPORT_H_



#include "timidity.h"
#include "common.h"
#include "playmidi.h"

typedef struct _playmidi_ex_t {

Channel (*channel);
Voice (*voice);

int32 *control_ratio_p, *amp_with_poly_p, *amplification_p;

ChannelBitMask *default_drumchannel_mask_p;
ChannelBitMask *drumchannel_mask_p;
ChannelBitMask *default_drumchannels_p;
ChannelBitMask *drumchannels_p;

int *adjust_panning_immediately_p;
int *voices_p, *upper_voices_p;
int *note_key_offset_p;
FLOAT_T *midi_time_ratio_p;
int *opt_modulation_wheel_p;
int *opt_portamento_p;
int *opt_nrpn_vibrato_p;
int *opt_reverb_control_p;
int *opt_chorus_control_p;
int *opt_surround_chorus_p;
int *opt_channel_pressure_p;
int *opt_lpf_def_p;
int *opt_overlap_voice_allow_p;
int *opt_temper_control_p;
int *opt_tva_attack_p;
int *opt_tva_decay_p;
int *opt_tva_release_p;
int *opt_delay_control_p;
int *opt_eq_control_p;
int *opt_insertion_effect_p;
int *opt_drum_effect_p;
int *opt_env_attack_p;
int *opt_modulation_envelope_p;
int *noise_sharp_type_p;
int32 *current_play_tempo_p;
int *opt_realtime_playing_p;
int *reduce_voice_threshold_p; /* msec */
int *check_eot_flag_p;
int *special_tonebank_p;
int *default_tonebank_p;
int *playmidi_seek_flag_p;
int *effect_lr_mode_p;
int *effect_lr_delay_msec_p;
int *auto_reduce_polyphony_p;
int *play_pause_flag_p;
int *reduce_quality_flag_p;
int *no_4point_interpolation_p;
ChannelBitMask *channel_mute_p;
int *temper_type_mute_p;
int8 *current_keysig_p;
int8 *current_temper_keysig_p;
int8 *opt_init_keysig_p;
int8 *opt_force_keysig_p;
int *key_adjust_p;
int *opt_pure_intonation_p;
int *current_freq_table_p;
int32 *opt_drum_power_p;
int *opt_amp_compensation_p;
int *opt_realtime_priority_p;	/* interface/alsaseq_c.c */
int *opt_sequencer_ports_p;		/* interface/alsaseq_c.c */

int (*play_midi_file)(char *fn);
void (*dumb_pass_playing_list)(int number_of_files, char *list_of_files[]);
void (*default_ctl_lyric)(int lyricid);
int (*check_apply_control)(void);
void (*recompute_freq)(int v);
int (*midi_drumpart_change)(int ch, int isdrum);
void (*ctl_note_event)(int noteID);
void (*ctl_mode_event)(int type, int trace, long arg1, long arg2);
char *(*channel_instrum_name)(int ch);
int (*get_reverb_level)(int ch);
int (*get_chorus_level)(int ch);
void (*playmidi_output_changed)(int play_state);
Instrument *(*play_midi_load_instrument)(int dr, int bk, int prog);
void (*midi_program_change)(int ch, int prog);
void (*free_voice)(int v);
void (*play_midi_setup_drums)(int ch,int note);

/* For stream player */
void (*playmidi_stream_init)(void);
void (*playmidi_tmr_reset)(void);
int (*play_event)(MidiEvent *ev);

void (*dup_tone_bank_element)(int,int,int);
void (*free_tone_bank_element)(int,int,int);

void (*recompute_voice_filter)(int);
	
}playmidi_ex_t;

extern playmidi_ex_t* playmidi_ex;

playmidi_ex_t* new_playmidi(void);
void destroy_playmidi(playmidi_ex_t* playmidi);



#endif /* ___PLAYMIDI_EXPORT_H_ */
