// Reads in the conf file and holds configuration information
// that is accessed by HLServer

#ifndef SERVERCONF_H
#define SERVERCONF_H

#include <list>
#include <string>
#include <stdexcept>

//2003/08/07 added by ortana.
#ifdef _WINTERRA_
#include <map>
#include <vector>
#include <boost/tokenizer.hpp>

struct RateList{
	int exRate;
	std::vector< std::string > exclude;
	std::map< std::string , int > rate;
};

const char RATE_CONF_PATH[] = "data\\rate.conf";

#endif//_WINTERRA_

using namespace std;

struct TrackerEntry
{
    TrackerEntry(const string &inAddr, const string &inPass)
        : addr(inAddr), pass(inPass) {}
    string addr;
    string pass;
};
typedef struct TrackerEntry TrackerEntry;

typedef list<TrackerEntry> TrackerList;

struct ServerConf
{
	ServerConf();
	
	bool ReadConf(const char *inConfFile) throw (runtime_error);
	bool WriteConf(const char *inConfFile);
	void ReloadConf();
	
	long dirPermissions;
	long filePermissions;
	u_int32_t maxDownloads;
	u_int32_t maxUploads;
	u_int32_t maxUsers;
	u_int32_t maxClientsPerAddress;
	time_t idleTimeout;
	time_t banTimeout;
	string serverName;
	string serverDescription;
	u_int16_t serverPort;
	u_int16_t serverVersion;
	bool databaseReadOnly;
	string databaseAddress;
	string databaseUser;
	string databasePassword;
	string databaseName;
	string rootPath;
	string agreementPath;
	string newsPath;
	string newsDirPath;
	string accountsPath;
	string logsPath;
	TrackerList trackerList;
	u_int8_t socksDetectLevel;
	string textEncoding;
	uid_t userID;
	gid_t groupID;
	string linkServer;

	string confFile;

//2003/08/07 added by ortana.
#ifdef _WINTERRA_
	int max_upload_speed;
	int max_download_speed;
	RateList rateList;
	void LoadRateConfig();
	void SaveRateConfig();
	bool use_rate;
	
	std::string raw_rate_conf;

	bool greeting_check;
#endif//_WINTERRA_
};

#endif // SERVERCONF_H


