// This is used by HLTransfer for calculating transfer stats
// for HLClient when it needs to create information on a user

#if !defined(WIN32)
#include <sys/time.h>
#endif //!WIN32

class NetworkSpeed
{
	public:
		NetworkSpeed();

		void Start(unsigned int inTotalBytes);
        
        void StartSendTimer();
        
		void Update(unsigned int inTransferedBytes);
	
        void LimitSpeed(unsigned int inTransferedBytes, unsigned int inMaxBps);
	
		float PercentageComplete()
		{
			float totalBytes = mTotalBytes;
			return ((mTransferedBytes / totalBytes) * 100.0);
		}

		unsigned int BytesPerSecond();
		
		unsigned int EstimatedTimeRemaining() // in seconds
		{
            unsigned int bytesPerSecond = BytesPerSecond();
            if (bytesPerSecond == 0)
                return (unsigned int)-1;
            else
                return ((mTotalBytes - mTransferedBytes) / bytesPerSecond);
		}
		
		unsigned int TotalBytes()
			{ return mTotalBytes; }
			
		unsigned int TransferedBytes()
			{ return mTransferedBytes; }
		
		bool IsStalled();

	private:
		unsigned int mTotalBytes;
		unsigned int mTransferedBytes;
		struct timeval mStartTime;
        struct timeval mSendBeginTime;
		struct timeval mUpdateTime;
};

