#include "HLChat.h"
#include <algorithm>
#include "HLProtocol.h"
#include "HLClient.h"

HLChat::HLChat(HLClient &inCreator, string &inName)
	: mName(inName)
{
	mClientList.push_back(&inCreator);
	gServer->mChatList.push_back(this);
}

HLChat::~HLChat()
{
	gServer->mChatList.remove(this);
}

void HLChat::AddClient(HLClient &inClient)
{
	mClientList.push_back(&inClient);
}

void HLChat::RemoveClient(HLClient &inClient)
{
	mClientList.remove(&inClient);
}

void HLChat::SendToClients(HLPacket &inPacket)
{
	ClientList::iterator iter = mClientList.begin();
	while (iter != mClientList.end())
	{
		(*iter)->SendPacket(inPacket);
		iter++;
	}
}

bool HLChat::IsClientInChat(HLClient &inClient)
{
	ClientList::iterator iter = find(mClientList.begin(), mClientList.end(), &inClient);
	return (iter != mClientList.end());
}

void HLChat::AddUserListToPacket(HLPacket &ioPacket)
{
	ClientList::iterator iter = mClientList.begin();
	u_int16_t dataSize;
	char dataBuf[sizeof(HL_USER) + USERNAME_MAXLEN + 2];
	HL_USER *userData = (HL_USER *)dataBuf;
	while (iter != mClientList.end())
	{
		dataSize = sizeof(HL_USER) + (*iter)->User().Name().length();
		(*iter)->User().GetHLUser(userData);
		ioPacket.AddObject(HTLS_DATA_USER_LIST, dataSize, (char *)userData);
		iter++;
	}
}

void HLChat::SetSubject(const string &inSubject)
{
	mSubject = inSubject;
}

void HLChat::GetSubject(string &outSubject)
{
	outSubject = mSubject;
}

