#include ".\cban.h"
#include "..\FileUtils.h"
#include <iostream>

using namespace NTF;
using namespace std;


const char BAN_LIST_PATH[18] = "data/ban_list.txt";

CBan::CBan(void)
{
}

CBan::~CBan(void)
{
}

std::string CBan::getList()
{
	string list;
	for( int i = 0 ; i < ban_list.size() ; i++ )
	{
		std::string s(ban_list[i]);
		std::string p("(.*)");
		std::string pr("*");
		s = FileUtils::replace_all_target( s , p , pr );

		list.append( s + "\r\n" );
	}
	return list;
}

void CBan::load()
{
	ban_list.clear();
	ifstream stream( BAN_LIST_PATH);
	if( !stream ){ return; }
	char buff[256];
	while( stream.getline( buff , 256 , '\n' ) )
	{
		std::string s( buff );
		if( s != "")
		{
				ban_list.push_back( s );
		}
	}
	stream.close();
}
void CBan::save(const char *s)
{
	ban_list.clear();
	std::string str( s );
	std::string p("*");
	std::string pr("(.*)");
	str = FileUtils::replace_all_target( str , p , pr );

	ofstream stream;
	stream.open(BAN_LIST_PATH ,ios::out | ios::trunc);
	if( !stream ){ return; }

	stream.write( str.c_str() , str.length() );

	stream.flush();

	load();
}

bool CBan::isBan(const char *source)
{
	for( int i = 0 ; i < ban_list.size() ; i++ )
	{
		try
		{

			std::string s = ban_list[i];

			if(s[0] == '#' )//comment out
			{
				continue;
			}
			
			boost::RegEx r( s.c_str() );


			if( r.Match( source ) )
			{
				return true;
			}

		}
		catch( ... )
		{
			continue;
		}
	}
	return false;
}