#include "ServerLog.h"
#include <stdarg.h>
#include <time.h>
#include "ServerConf.h"

#if !defined(WIN32)
#include <syslog.h>
#include <sys/param.h>
#else
#include <fstream>//2003/07/24 added by ortana
CEdit *log_Edit;//2003/07/24 added by ortana
#endif// !WIN32

void CurrentTimeString(char *outTimeString, unsigned int stringLen)
{
	struct tm tm;
	time_t currentTime = time(0);

	localtime_r(&currentTime, &tm);

	//2003/07/24 added by ortana.
#ifdef WIN32
	strftime(outTimeString, stringLen, "%H:%M:%S %r %m/%d/%Y %r", &tm);
#else
	strftime(outTimeString, stringLen, "%m/%d/%Y %r", &tm);
#endif
}

void LogToFile(const char *inPath, const char *inFormat, ...)
{
	char logPath[MAXPATHLEN];
	FILE *logFile = NULL;
	if (gServer)
	{
		snprintf(logPath, MAXPATHLEN - 1, "%s%s", gServer->Config().logsPath.c_str(), inPath);
		logFile = fopen(logPath, "a");
	}

	va_list ap;

	va_start(ap, inFormat);
	if (logFile)
	{
		vfprintf(logFile, inFormat, ap);
		fclose(logFile);
	}
#if !defined(_DEBUG_BUILD_) && !defined(WIN32)
	else
	{
		// for release builds, the log information will go to
		// the syslog if it can't be logged to the normal log file
		vsyslog(LOG_NOTICE, inFormat, ap);
	}
#else
	// for debug builds we send everything to stdout
	//vfprintf(stdout, inFormat, ap);
#endif
	va_end(ap);
}


	void ServerLog::AccountLog(HLClient &inClient, const char *inAction, const char *inAffectedAccount)
	{
		char timeString[256];
		CurrentTimeString(timeString, 255);
		LogToFile("account.log", "%s\t%s\t%s\t%s\t%s\t%s\n", timeString, inClient.Address().c_str(),
			inClient.User().Login().c_str(), inClient.User().Name().c_str(), inAction, inAffectedAccount);

		//2003/07/24 added by ortana.
#ifdef WIN32
		char log_buff[MAX_PATH + 50];
		sprintf( log_buff , "account\t%s\t%s\t%s\t%s\t%s\t%s\r\n", timeString, inClient.Address().c_str(),
			inClient.User().Login().c_str(), inClient.User().Name().c_str(), inAction, inAffectedAccount);

		ShowLog( log_buff , ::log_Edit );
#endif
	}

	void ServerLog::ConnectLog(HLClient &inClient)
	{
		char timeString[256];
		CurrentTimeString(timeString, 255);
		LogToFile("connect.log", "%s\t%s\t%s\t%s\n", timeString, inClient.Address().c_str(),
			inClient.User().Login().c_str(), inClient.User().Name().c_str());

		//2003/07/24 added by ortana.
#ifdef WIN32
		char log_buff[MAX_PATH + 50];
		sprintf( log_buff , "connect\t%s\t%s\t%s\t%s\r\n", timeString, inClient.Address().c_str(),
			inClient.User().Login().c_str(), inClient.User().Name().c_str());

		ShowLog( log_buff , ::log_Edit );
#endif
	}

	void ServerLog::DownloadLog(HLClient &inClient, const char *inFileName)
	{
		char timeString[256];
		CurrentTimeString(timeString, 255);
		LogToFile("download.log", "%s\t%s\t%s\t%s\t%s\n", timeString, inClient.Address().c_str(),
			inClient.User().Login().c_str(), inClient.User().Name().c_str(), inFileName);

		//2003/07/24 added by ortana.
#ifdef WIN32
		char log_buff[MAX_PATH + 50];
		sprintf( log_buff , "download\t%s\t%s\t%s\t%s\t%s\r\n", timeString, inClient.Address().c_str(),
			inClient.User().Login().c_str(), inClient.User().Name().c_str(), inFileName);

		ShowLog( log_buff , ::log_Edit );
#endif

	}

	void ServerLog::UploadLog(HLClient &inClient, const char *inFileName)
	{
		char timeString[256];
		CurrentTimeString(timeString, 255);
		LogToFile("upload.log", "%s\t%s\t%s\t%s\t%s\n", timeString, inClient.Address().c_str(),
			inClient.User().Login().c_str(), inClient.User().Name().c_str(), inFileName);

		//2003/07/24 added by ortana.
#ifdef WIN32
		char log_buff[MAX_PATH + 50];
		sprintf( log_buff , "upload\t%s\t%s\t%s\t%s\t%s\r\n", timeString, inClient.Address().c_str(),
			inClient.User().Login().c_str(), inClient.User().Name().c_str(), inFileName);

		ShowLog( log_buff , ::log_Edit );
#endif
	}

	void ServerLog::ErrorLog(char *inSourceFile, unsigned int inSourceLine, const char *inFormat, ...)
	{
		char timeString[256];
		CurrentTimeString(timeString, 255);

		char errorBuf[1024];
		va_list ap;

		va_start(ap, inFormat);
		vsnprintf(errorBuf, 1023, inFormat, ap);
		va_end(ap);

		LogToFile("error.log", "%s %s %u %s\n", timeString, inSourceFile, inSourceLine, errorBuf);

		//2003/07/24 added by ortana
#ifdef WIN32
		char log_buff[MAX_PATH + 50];
		sprintf( log_buff , "ERROR\t%s %s %u %s\r\n", timeString, inSourceFile, inSourceLine, errorBuf);

		ShowLog( log_buff , ::log_Edit );
#endif
	}


	//2003/07/24 added by ortana
#ifdef WIN32



	void ServerLog::OtherLog(const char* header , const char *log)
	{
		char timeString[256];
		CurrentTimeString(timeString, 255);
		char log_buff[MAX_PATH + 50];
		sprintf(log_buff , "%s\t%s\t%s\r\n" , header , timeString , log );

		ShowLog(  log_buff , ::log_Edit );
	}

	void ServerLog::ShowLog(const char *log , CEdit *edit)
	{
		int nLen = edit->GetWindowTextLength();
		edit->SetFocus();
		edit->SetSel(nLen, nLen);
		edit->ReplaceSel(log);

		{
			char path_buff[MAX_PATH];
			sprintf( path_buff , "%s%s" , gServer->Config().logsPath.c_str() , "winterra.log" );
			std::fstream fs( path_buff , ios::out | ios::app );
			if(!fs) return;

			fs.write( log , strlen( log ) );

			fs.close();
		}
	}
#endif