#include "DynamicBuffer.h"
#include <iostream>
#include <string.h>

using namespace std;

DynamicBuffer::DynamicBuffer(size_t inSize)
    : mSize(0), mPtr(NULL)
{
    Resize(inSize);
}

DynamicBuffer::~DynamicBuffer()
{
    Free();
}

char *DynamicBuffer::Resize(size_t inSize)
{
    if (mPtr != NULL && inSize == 0)
    {
        Free();
    }
    else if (inSize > 0 && inSize != mSize)
    {
        char *newPtr = (char *)realloc(mPtr, inSize);
        if (newPtr == NULL)
        {
            // throw an exception ?
            DEBUG_CALL(printf("realloc failed\n"); fflush(stdout));
            //newBuffer = malloc(inSize);
        }
        
        DEBUG_CALL(
            if (mPtr != newPtr && mPtr != NULL)
            {
                DEBUG_CALL(printf("buffer ptr changed for size: %u\n", (unsigned int)inSize); fflush(stdout));
            }
        );
        mPtr = newPtr;
        mSize = inSize;
    }
    return mPtr;
}

void DynamicBuffer::CopyInto(const char *inBytes, const size_t inSize)
{
    size_t tempSize = mSize;
    Resize(tempSize + inSize);
    memcpy(&mPtr[tempSize], inBytes, inSize);
}

void DynamicBuffer::RemoveFrom(const size_t inSize)
{
    size_t newSize = (mSize - inSize);
    if (newSize)
    {
        memcpy(mPtr, &mPtr[inSize], newSize);
        Resize(newSize);
    }
    else
    {
        Free();
    }
}

void DynamicBuffer::Free()
{
    mSize = 0;
    free(mPtr);
    mPtr = NULL;
}


