// Wrapper around pthread mutex. Used by HLServer to protect all its data and
// HLClient to protect around socket sends.

#ifndef MUTEX_H
#define MUTEX_H

#if defined(USE_PTHREADS)
#include <pthread.h>
#endif //USE_PTHREADS

class BMutex
{
	public:
		BMutex();
		~BMutex();
		
		void Lock();
		void Unlock();
		
		bool TryLock();
		
	protected:

#if defined(USE_PTHREADS)
		pthread_mutex_t mMutex;
#endif // USE_PTHREADS

#if defined(USE_WIN32THREADS)
		// On win32 systems, we can implement mutexes in the form of critical sections.
		// This is faster then kernel mutexes, but it won't work cross process
		CRITICAL_SECTION mCriticalSection;
#endif // USE_WIN32THREADS
};

class StMutexLock
{
	public:
		StMutexLock(BMutex &inMutex)
			: mMutex(&inMutex)
			{ mMutex->Lock(); }
		
		void Lock()
			{ mMutex->Lock(); }
		
		void Unlock()
			{ mMutex->Unlock(); }
		
		~StMutexLock()
			{ mMutex->Unlock(); }
	private:
		BMutex *mMutex;
};

#endif // MUTEX_H


