// AsyncTCPSocket is a wrapper around non-blocking TCP Sockets
// It works with SocketSelector, which calls the virtual On* functions
// It is subclassed by BufferedSocket to provide a base for HLSocket

#ifndef ASYNC_TCP_SOCKET_H
#define ASYNC_TCP_SOCKET_H

#include "TCPSocket.h"
#include "SocketSelector.h"
#include "AsyncDNS.h"

class AsyncTCPSocket : public TCPSocket, public AsyncDNSCallback
{
    public:
        AsyncTCPSocket();
        AsyncTCPSocket(int inDescriptor, struct sockaddr_in* inRemoteAddress);
        virtual ~AsyncTCPSocket();
        
        virtual void Shutdown();
        virtual void Close();
        
        int Recv(void *outBytes, u_int32_t inCount) throw (socket_error)
            { return TCPSocket::Recv(outBytes, inCount, 0); }
        virtual int Send(const void *inBytes, u_int32_t inCount) throw (socket_error);
		
		void Connect(const string &inAddress, u_int16_t inPort);
		void Connect(const u_int32_t inAddress, const u_int16_t inPort);
        void Bind(u_int16_t inPort = 0, u_int32_t inAddress = INADDR_ANY);
        void Listen(u_int32_t inMaxPendingConnections = 5);
        
        void SetSelector(SocketSelector &inSelector)
        {
            mSelector = &inSelector;
            mSelector->AddSocket(*this);
        }
        
        bool SetNonBlock(bool nonBlock);
        
    protected:
        SocketSelector *mSelector;
        
        bool mWaitRead;
        bool mWaitWrite;
		
		u_int16_t mSavedPort;
		void HostLookup(const string &inName, const struct in_addr *inAddr);
        
        virtual void OnConnect() {}
        virtual void OnAccept() {}
        virtual void OnRecv() {}
        virtual void OnSend() {}
        virtual void OnClose() {}

friend class SocketSelector;
};


#endif // ASYNC_TCP_SOCKET_H



