// HLUser stores information about a user.
// Each HLClient contains an HLUser.

#ifndef HL_USER_H
#define HL_USER_H

#include <string>
#include <time.h>
#include "HLAccount.h"

#define ADMIN_MASK	0x0002
#define IDLE_MASK	0x0001

typedef struct
{
	u_int16_t id;
	u_int16_t icon;
	u_int16_t status;
	u_int16_t nlen;
	char name[ZERO_SIZE_ARRAY_SIZE];
} HL_USER;

using namespace std;

class HLUser
{
	public:
		HLUser();
		~HLUser();
	
		bool IsLoggedIn() const
			{ return mLoggedIn; }
		
		void LoggedIn(bool inLoggedIn)
			{ mLoggedIn = inLoggedIn; }
			
		void GetHLUser(HL_USER *outUser) const;
		
		const string Name() const;
		const string RealName() const
			{ return mName; }
		
		const string Login() const
			{ return mAccount.Login(); }
		
		const u_int16_t ID() const
			{ return mID; }
			
		const u_int16_t Icon() const
			{ return mIcon; }
		
		const u_int16_t Status() const
			{ return mStatus; }
        
        const struct hl_access_bits &Access() const
            { return mAccount.Access(); }
            
        const time_t LoginTime() const
            { return mLoginTime; }
		
		const u_int32_t ConnectionID() const
			{ return mConnectionID; }
		
		const bool IsGuest() const
			{ return mAccount.IsGuest(); }
		
		void GetInfo(const string &inAddress, string &outInfoString, bool inFull);
        
        // the "Last Recv Time" is different from when the last packet arrived
        // that stored in the client and used for flood detection
        // LastRecvTime is used to detect when the user should go idle and it
        // ignores stuff such as the constant userlist requests from 1.8.5 clients
        const time_t LastRecvTime() const
            { return mLastRecvTime; }
        
        const string FilesPath() const
            { return mAccount.FilesPath(); }
        
        const u_int32_t MaxBps() const
            { return mAccount.MaxBps(); }
    
#if defined(CONFIG_LINKING)
		const u_int32_t GlobalID() const
			{ return mGlobalID; }
#endif

    protected:    
        void SetID(const u_int16_t inID)
            { mID = inID; }
        
        void SetIcon(const u_int16_t inIcon)
            { mIcon = inIcon; }
        
        void SetStatus(const u_int16_t inStatus)
            { mStatus = inStatus; }
        
        void SetName(const string &inName);
        
        void SetLastRecvTime(time_t inTime)
            { mLastRecvTime = inTime; }
        
        void SetConnectionID(const u_int32_t inConnectionID)
			{ mConnectionID = inConnectionID; }
        
#if defined(CONFIG_LINKING)
        void SetGlobalID(const u_int32_t inGlobalID)
			{ mGlobalID = inGlobalID; }
#endif
        
		void SetLoginTime()
            { mLoginTime = time(0); }
        
        void SetAccount(const HLAccount &inAccount)
            { mAccount = inAccount; }
        
        HLAccount &Account()
            { return mAccount; }
        
	private:
		HLAccount mAccount;
        string mName;
		u_int16_t mID;
		u_int16_t mIcon;
		u_int16_t mStatus;
		bool mLoggedIn;
		u_int32_t mConnectionID;
#if defined(CONFIG_LINKING)
		u_int32_t mGlobalID;
#endif
		time_t mLoginTime;
        time_t mLastRecvTime;

    friend class HLClient;
    friend class HLServer;
    friend class HLDataBase;
	friend class LinkManager;
};

#endif // HL_USER_H


