﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using WinTabDotnet;

namespace PressureTest {
    public partial class Form1 : Form {
        private WinTabMessenger m_wtMessenger;
        private WinTabContext   m_wtContext;
        private int             px,py,prs,maxprs;

        public Form1() {
            InitializeComponent();

            if (!WinTab.LoadWinTab()) {
                MessageBox.Show("ペンタブレットが見つかりません(WinTab32.dllが見つかりません)。","WinTab.NET");
                throw new WinTabException("WinTab.NETの初期化に失敗しました。");
            }

            m_wtMessenger = new WinTabMessenger();
            m_wtContext = new WinTabContext();

            m_wtMessenger.CursorMove += new CursorMoveHandler(m_wtMessenger_CursorMove);
            m_wtMessenger.NPressureChange += new NPressureChangeHandler(m_wtMessenger_NPressureChange);

            maxprs = WinTab.DeviceNPressure.axMax;
            this.Text = WinTab.DeviceName + " Sample";

            m_wtContext.Open(this.Handle,true,0,0,8192,8192,
                ContextOption.OFFMODE | ContextOption.SYSTEM,
                RelativeField.None);

            this.Paint += new PaintEventHandler(Form1_Paint);

            this.SetStyle(ControlStyles.DoubleBuffer,true);
            this.SetStyle(ControlStyles.UserPaint,true);
            this.SetStyle(ControlStyles.AllPaintingInWmPaint,true);
        }

        void m_wtMessenger_NPressureChange(PacketEventArgs e) {
            prs = e.pkts.pkNormalPressure;
            this.Invalidate();
        }

        void m_wtMessenger_CursorMove(PacketEventArgs e) {
            px = e.pkts.pkX;
            py = e.pkts.pkY;
            this.Invalidate();
        }

        void Form1_Paint(object sender,PaintEventArgs e) {
            Graphics  gph = e.Graphics;
            Brush  b = new SolidBrush(Color.White);
            Pen  p = new Pen(Color.Black);
            int  x = (px * ClientSize.Width) / 8192;
            int  y = (py * ClientSize.Height) / 8192;
            
            gph.FillRectangle(b,0,0,640,480);

            if (prs!=0) {
                Rectangle  r = new Rectangle(x,y,0,0);
                r.Inflate(prs*400/maxprs,prs*400/maxprs);
                Brush  eb = new SolidBrush(Color.LightGreen);
                gph.FillEllipse(eb,r);
            }

            gph.DrawLine(p,x,0,x,600);
            gph.DrawLine(p,0,y,800,y);
        }

        protected override void OnPaintBackground(PaintEventArgs e) {
        }

        protected override void WndProc(ref Message m) {
            if (!m_wtMessenger.WndProc(ref m)) { base.WndProc(ref m); }
        }
    }
}
