/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.Shadowable;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class ComponentRoseParticipant
extends AbstractTextualComponent {
    private final HColor back;
    private final HColor foregroundColor;
    private final double deltaShadow;
    private final double roundCorner;
    private final double diagonalCorner;
    private final UStroke stroke;
    private final double minWidth;
    private final boolean collections;
    private final double padding;

    public ComponentRoseParticipant(Style style, Style stereo, Display stringsToDisplay, ISkinSimple spriteContainer, double minWidth, boolean collections, double padding) {
        super(style, stereo, LineBreakStrategy.NONE, 7, 7, 7, spriteContainer, stringsToDisplay, false);
        this.roundCorner = style.value(PName.RoundCorner).asInt(false);
        this.diagonalCorner = style.value(PName.DiagonalCorner).asInt(false);
        SymbolContext biColor = style.getSymbolContext(this.getIHtmlColorSet());
        this.stroke = style.getStroke();
        this.padding = padding;
        this.minWidth = minWidth;
        this.collections = collections;
        this.back = biColor.getBackColor();
        this.deltaShadow = biColor.getDeltaShadow();
        this.foregroundColor = biColor.getForeColor();
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        StringBounder stringBounder = ug.getStringBounder();
        ug = ug.apply(UTranslate.dx(this.padding));
        if (this.foregroundColor != null) {
            ug = ug.apply(this.foregroundColor);
        }
        if (this.back != null) {
            ug = ug.apply(this.back.bg());
        }
        ug = ug.apply(this.stroke);
        Shadowable rect = new URectangle(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder)).rounded(this.roundCorner).diagonalCorner(this.diagonalCorner);
        rect.setDeltaShadow(this.deltaShadow);
        if (this.collections) {
            ug.apply(UTranslate.dx(this.getDeltaCollection())).draw(rect);
            ug = ug.apply(UTranslate.dy(this.getDeltaCollection()));
        }
        ug.draw(rect);
        ug = ug.apply(new UStroke());
        TextBlock textBlock = this.getTextBlock();
        textBlock.drawU(ug.apply(new UTranslate((double)this.getMarginX1() + this.suppWidth(stringBounder) / 2.0, this.getMarginY())));
    }

    private double getDeltaCollection() {
        if (this.collections) {
            return 4.0;
        }
        return 0.0;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + this.deltaShadow + 1.0 + this.getDeltaCollection();
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + this.deltaShadow + this.getDeltaCollection() + 2.0 * this.padding;
    }

    @Override
    protected double getPureTextWidth(StringBounder stringBounder) {
        return Math.max(super.getPureTextWidth(stringBounder), this.minWidth);
    }

    private final double suppWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) - super.getPureTextWidth(stringBounder);
    }
}

