/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterStartsub;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TLineType;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.utils.StringLocated;

public class Sub {
    private final String name;
    private final List<StringLocated> lines = new ArrayList<StringLocated>();

    public Sub(String name) {
        this.name = name;
    }

    public String toString() {
        return super.toString() + " " + this.name;
    }

    public void add(StringLocated s) {
        this.lines.add(s);
    }

    public final List<StringLocated> lines() {
        return Collections.unmodifiableList(this.lines);
    }

    public static Sub fromFile(ReadLine reader, String blocname, TContext context, TMemory memory) throws IOException, EaterException {
        Sub result = null;
        StringLocated s = null;
        boolean skip = false;
        while ((s = reader.readLine()) != null) {
            TLineType type = s.getTrimmed().getType();
            if (type == TLineType.STARTSUB) {
                EaterStartsub eater = new EaterStartsub(s.getTrimmed());
                eater.analyze(context, memory);
                if (!eater.getSubname().equals(blocname)) continue;
                skip = false;
                if (result != null) continue;
                result = new Sub(blocname);
                continue;
            }
            if (type == TLineType.ENDSUB && result != null) {
                skip = true;
            }
            if (result == null || skip) continue;
            result.add(s);
        }
        return result;
    }
}

