/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.utils.StringLocated;

public enum MultilinesStrategy {
    REMOVE_STARTING_QUOTE,
    KEEP_STARTING_QUOTE;


    public void cleanList(List<StringLocated> lines) {
        if (this == REMOVE_STARTING_QUOTE) {
            this.filterQuote(lines);
        }
    }

    private void filterQuote(List<StringLocated> lines) {
        Iterator<StringLocated> it = lines.iterator();
        while (it.hasNext()) {
            StringLocated s = it.next();
            if (!this.hasStartingQuote(s)) continue;
            it.remove();
        }
    }

    private boolean hasStartingQuote(StringLocated s) {
        return s.getTrimmed().getString().startsWith("'");
    }
}

