/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.UrlMode;
import net.sourceforge.plantuml.baraye.IGroup;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.NamespaceStrategy;
import net.sourceforge.plantuml.cucadiagram.Stereotag;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.USymbols;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandPackage
extends SingleLineCommand2<AbstractEntityDiagram> {
    public CommandPackage() {
        super(CommandPackage.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandPackage.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "(package)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME", "([%g][^%g]+[%g]|[^#%s{}]*)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("AS", "([%pLN_.]+)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS1", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS2", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), CommandPackage.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
    }

    @Override
    public boolean syntaxWithFinalBracket() {
        return true;
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractEntityDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        Ident code;
        String display;
        String idShort;
        String name = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("NAME", 0));
        boolean override1972 = false;
        if (arg.get("AS", 0) == null) {
            if (name.length() == 0) {
                idShort = "##" + diagram.getUniqueSequence();
                display = null;
            } else {
                display = idShort = name;
                override1972 = true;
            }
        } else {
            display = name;
            idShort = arg.get("AS", 0);
        }
        Ident ident = diagram.buildLeafIdent(idShort);
        Code code2 = code = diagram.V1972() ? ident : diagram.buildCode(idShort);
        if (diagram.V1972() && override1972) {
            display = ident.getLast();
        }
        IGroup currentPackage = diagram.getCurrentGroup();
        CommandExecutionResult status = diagram.gotoGroup(ident, code, Display.getWithNewlines(display), GroupType.PACKAGE, currentPackage, NamespaceStrategy.SINGLE);
        if (!status.isOk()) {
            return status;
        }
        IGroup p = diagram.getCurrentGroup();
        String stereotype = arg.get("STEREOTYPE", 0);
        if (stereotype != null) {
            USymbol usymbol = USymbols.fromString(stereotype, diagram.getSkinParam().actorStyle(), diagram.getSkinParam().componentStyle(), diagram.getSkinParam().packageStyle());
            if (usymbol == null) {
                p.setStereotype(Stereotype.build(stereotype));
            } else {
                p.setUSymbol(usymbol);
            }
        }
        CommandCreateClassMultilines.addTags(p, arg.getLazzy("TAGS", 0));
        String urlString = arg.get("URL", 0);
        if (urlString != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            p.addUrl(url);
        }
        Colors colors = CommandPackage.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        p.setColors(colors);
        return CommandExecutionResult.ok();
    }
}

