/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.UrlMode;
import net.sourceforge.plantuml.baraye.ILeaf;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotag;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.USymbols;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandCreateElementFull2
extends SingleLineCommand2<ClassDiagram> {
    private final Mode mode;

    public CommandCreateElementFull2(Mode mode) {
        super(CommandCreateElementFull2.getRegexConcat(mode));
        this.mode = mode;
    }

    private static RegexConcat getRegexConcat(Mode mode) {
        String regex = "(state|person|artifact|actor/|actor|folder|card|file|package|rectangle|hexagon|label|node|frame|cloud|database|queue|stack|storage|agent|usecase/|usecase|component|boundary|control|entity|interface|circle|collections|port|portin|portout)";
        if (mode == Mode.WITH_MIX_PREFIX) {
            return RegexConcat.build(CommandCreateElementFull2.class.getName() + (Object)((Object)mode), RegexLeaf.start(), new RegexLeaf("mix_"), new RegexLeaf("SYMBOL", regex), RegexLeaf.spaceOneOrMore(), new RegexOr(new RegexLeaf("CODE1", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\]|[%g].+?[%g])"), new RegexConcat(new RegexLeaf("DISPLAY2", "([%g].+?[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE2", "(\\<\\<.+\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE2", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS1", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(\\<\\<.+\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS2", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.end());
        }
        return RegexConcat.build(CommandCreateElementFull2.class.getName() + (Object)((Object)mode), RegexLeaf.start(), new RegexLeaf("SYMBOL", regex), RegexLeaf.spaceOneOrMore(), new RegexOr(new RegexLeaf("CODE1", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\]|[%g].+?[%g])"), new RegexConcat(new RegexLeaf("DISPLAY2", "([%g].+?[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE2", "(\\<\\<.+\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE2", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS1", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(\\<\\<.+\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS2", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.end());
    }

    @Override
    protected final boolean isForbidden(CharSequence line) {
        return line.toString().matches("^[\\p{L}0-9_.]+$");
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String s;
        USymbol usymbol;
        LeafType type;
        String symbol;
        if (this.mode == Mode.NORMAL_KEYWORD && !diagram.isAllowMixing()) {
            return CommandExecutionResult.error("Use 'allowmixing' if you want to mix classes and other UML elements.");
        }
        String codeRaw = arg.getLazzy("CODE", 0);
        String displayRaw = arg.getLazzy("DISPLAY", 0);
        char codeChar = this.getCharEncoding(codeRaw);
        char codeDisplay = this.getCharEncoding(displayRaw);
        if (codeRaw.startsWith("()")) {
            symbol = "interface";
            codeRaw = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(codeRaw.substring(2)));
        } else {
            symbol = codeChar == '(' || codeDisplay == '(' ? "usecase" : (codeChar == ':' || codeDisplay == ':' ? "actor" : (codeChar == '[' || codeDisplay == '[' ? "component" : arg.get("SYMBOL", 0)));
        }
        if (symbol == null) {
            type = LeafType.DESCRIPTION;
            usymbol = diagram.getSkinParam().actorStyle().toUSymbol();
        } else if (symbol.equalsIgnoreCase("port")) {
            type = LeafType.PORTIN;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("portin")) {
            type = LeafType.PORTIN;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("portout")) {
            type = LeafType.PORTOUT;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("usecase")) {
            type = LeafType.USECASE;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("usecase/")) {
            type = LeafType.USECASE_BUSINESS;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("state")) {
            type = LeafType.STATE;
            usymbol = null;
        } else {
            type = LeafType.DESCRIPTION;
            usymbol = USymbols.fromString(symbol, diagram.getSkinParam());
            if (usymbol == null) {
                throw new IllegalStateException();
            }
        }
        String idShort = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(codeRaw);
        Ident ident = diagram.buildLeafIdent(idShort);
        Ident code = diagram.V1972() ? ident : diagram.buildCode(idShort);
        String display = displayRaw;
        if (display == null) {
            display = code.getName();
        }
        display = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(display);
        String stereotype = arg.getLazzy("STEREOTYPE", 0);
        ILeaf entity = diagram.getOrCreateLeaf(ident, code, type, usymbol);
        entity.setDisplay(Display.getWithNewlines(display));
        entity.setUSymbol(usymbol);
        if (stereotype != null) {
            entity.setStereotype(Stereotype.build(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        CommandCreateClassMultilines.addTags(entity, arg.getLazzy("TAGS", 0));
        String urlString = arg.get("URL", 0);
        if (urlString != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            entity.addUrl(url);
        }
        entity.setSpecificColorTOBEREMOVED(ColorType.BACK, (s = arg.get("COLOR", 0)) == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s));
        return CommandExecutionResult.ok();
    }

    private char getCharEncoding(String codeRaw) {
        return codeRaw != null && codeRaw.length() > 2 ? codeRaw.charAt(0) : (char)'\u0000';
    }

    public static enum Mode {
        NORMAL_KEYWORD,
        WITH_MIX_PREFIX;

    }
}

