/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnection;
import net.sourceforge.plantuml.activitydiagram3.gtile.GPoint;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;

public abstract class AbstractGtileRoot
extends AbstractTextBlock
implements Gtile {
    protected final StringBounder stringBounder;
    private final ISkinParam skinParam;

    public AbstractGtileRoot(StringBounder stringBounder, ISkinParam skinParam) {
        this.stringBounder = stringBounder;
        this.skinParam = skinParam;
    }

    @Override
    public final StringBounder getStringBounder() {
        return this.stringBounder;
    }

    @Override
    public final ISkinParam skinParam() {
        if (this.skinParam == null) {
            throw new IllegalStateException();
        }
        return this.skinParam;
    }

    public final HColorSet getIHtmlColorSet() {
        return this.skinParam.getIHtmlColorSet();
    }

    @Override
    public final GPoint getGPoint(String name) {
        if (name.equals("NORTH_HOOK") || name.equals("SOUTH_HOOK") || name.equals("WEST_HOOK") || name.equals("EAST_HOOK") || name.equals("NORTH_BORDER") || name.equals("SOUTH_BORDER") || name.equals("WEST_BORDER") || name.equals("EAST_BORDER")) {
            return new GPoint(this, name);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final UTranslate getCoord(String name) {
        if (name.equals("NORTH_BORDER")) {
            UTranslate tmp = this.getCoordImpl("NORTH_HOOK");
            return new UTranslate(tmp.getDx(), 0.0);
        }
        if (name.equals("SOUTH_BORDER")) {
            UTranslate tmp = this.getCoordImpl("SOUTH_HOOK");
            return new UTranslate(tmp.getDx(), this.calculateDimension(this.stringBounder).getHeight());
        }
        if (name.equals("WEST_BORDER")) {
            UTranslate tmp = this.getCoordImpl("WEST_HOOK");
            return new UTranslate(0.0, tmp.getDy());
        }
        if (name.equals("EAST_BORDER")) {
            UTranslate tmp = this.getCoordImpl("EAST_HOOK");
            return new UTranslate(this.calculateDimension(this.stringBounder).getWidth(), tmp.getDy());
        }
        return this.getCoordImpl(name);
    }

    protected abstract UTranslate getCoordImpl(String var1);

    @Override
    public final void drawU(UGraphic ug) {
        this.drawUInternal(ug);
        for (GConnection connection : this.getInnerConnections()) {
            ug.draw(connection);
        }
    }

    protected abstract void drawUInternal(UGraphic var1);
}

