/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.SvgCharSizeHack;
import net.sourceforge.plantuml.TikzFontDistortion;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.braille.BrailleCharFactory;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderRaw;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.png.MetadataTag;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.debug.StringBounderDebug;

public enum FileFormat {
    PNG("image/png"),
    SVG("image/svg+xml"),
    EPS("application/postscript"),
    EPS_TEXT("application/postscript"),
    ATXT("text/plain"),
    UTXT("text/plain;charset=UTF-8"),
    XMI_STANDARD("application/vnd.xmi+xml"),
    XMI_STAR("application/vnd.xmi+xml"),
    XMI_ARGO("application/vnd.xmi+xml"),
    SCXML("application/scxml+xml"),
    GRAPHML("application/graphml+xml"),
    PDF("application/pdf"),
    MJPEG("video/x-msvideo"),
    ANIMATED_GIF("image/gif"),
    HTML("text/html"),
    HTML5("text/html"),
    VDX("application/vnd.visio.xml"),
    LATEX("application/x-latex"),
    LATEX_NO_PREAMBLE("application/x-latex"),
    BASE64("text/plain; charset=x-user-defined"),
    BRAILLE_PNG("image/png"),
    PREPROC("text/plain"),
    DEBUG("text/plain");

    private final String mimeType;
    private static final BufferedImage imDummy;
    public static final Graphics2D gg;

    private FileFormat(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFileSuffix() {
        if (this.name().startsWith("XMI")) {
            return ".xmi";
        }
        if (this == MJPEG) {
            return ".avi";
        }
        if (this == LATEX || this == LATEX_NO_PREAMBLE) {
            return ".tex";
        }
        if (this == ANIMATED_GIF) {
            return ".gif";
        }
        if (this == BRAILLE_PNG) {
            return ".braille.png";
        }
        if (this == EPS_TEXT) {
            return EPS.getFileSuffix();
        }
        return "." + StringUtils.goLowerCase(this.name());
    }

    public StringBounder getDefaultStringBounder() {
        return this.getDefaultStringBounder(TikzFontDistortion.getDefault(), SvgCharSizeHack.NO_HACK);
    }

    public StringBounder getDefaultStringBounder(TikzFontDistortion tikzFontDistortion, SvgCharSizeHack charSizeHack) {
        if (this == LATEX || this == LATEX_NO_PREAMBLE) {
            return this.getTikzStringBounder(tikzFontDistortion);
        }
        if (this == BRAILLE_PNG) {
            return this.getBrailleStringBounder();
        }
        if (this == SVG) {
            return this.getSvgStringBounder(charSizeHack);
        }
        if (this == DEBUG) {
            return new StringBounderDebug();
        }
        return this.getNormalStringBounder();
    }

    private StringBounder getSvgStringBounder(final SvgCharSizeHack charSizeHack) {
        return new StringBounderRaw(){

            public String toString() {
                return "FileFormat::getSvgStringBounder";
            }

            @Override
            protected XDimension2D calculateDimensionInternal(UFont font, String text) {
                text = charSizeHack.transformStringForSizeHack(text);
                return FileFormat.getJavaDimension(font, text);
            }
        };
    }

    private StringBounder getNormalStringBounder() {
        return new StringBounderRaw(){

            public String toString() {
                return "FileFormat::getNormalStringBounder";
            }

            @Override
            protected XDimension2D calculateDimensionInternal(UFont font, String text) {
                return FileFormat.getJavaDimension(font, text);
            }
        };
    }

    private static XDimension2D getJavaDimension(UFont font, String text) {
        Font javaFont = font.getUnderlayingFont();
        FontMetrics fm = gg.getFontMetrics(javaFont);
        Rectangle2D rect = fm.getStringBounds(text, gg);
        return new XDimension2D(rect.getWidth(), rect.getHeight());
    }

    private StringBounder getBrailleStringBounder() {
        return new StringBounderRaw(){

            public String toString() {
                return "FileFormat::getBrailleStringBounder";
            }

            @Override
            protected XDimension2D calculateDimensionInternal(UFont font, String text) {
                int nb = BrailleCharFactory.build(text).size();
                double quanta = 4.0;
                double height = 20.0;
                double width = (double)(3 * nb) * 4.0 + 1.0;
                return new XDimension2D(width, 20.0);
            }

            @Override
            public double getDescent(UFont font, String text) {
                return 4.0;
            }
        };
    }

    private StringBounder getTikzStringBounder(final TikzFontDistortion tikzFontDistortion) {
        return new StringBounderRaw(){

            public String toString() {
                return "FileFormat::getTikzStringBounder";
            }

            @Override
            protected XDimension2D calculateDimensionInternal(UFont font, String text) {
                text = text.replace("\t", "    ");
                XDimension2D w1 = FileFormat.getJavaDimension(font.goTikz(-1), text);
                XDimension2D w2 = FileFormat.getJavaDimension(font.goTikz(0), text);
                XDimension2D w3 = FileFormat.getJavaDimension(font.goTikz(1), text);
                double factor = (w3.getWidth() - w1.getWidth()) / w2.getWidth();
                double distortion = tikzFontDistortion.getDistortion();
                double magnify = tikzFontDistortion.getMagnify();
                double delta = (w2.getWidth() - w1.getWidth()) * factor * distortion;
                return w2.withWidth(Math.max(w1.getWidth(), magnify * w2.getWidth() - delta));
            }
        };
    }

    public boolean isEps() {
        if (this == EPS) {
            return true;
        }
        return this == EPS_TEXT;
    }

    public String changeName(String fileName, int cpt) {
        if (cpt == 0) {
            return this.changeName(fileName, this.getFileSuffix());
        }
        return this.changeName(fileName, OptionFlags.getInstance().getFileSeparator() + String.format("%03d", cpt) + this.getFileSuffix());
    }

    private SFile computeFilename(SFile pngFile, int i) {
        if (i == 0) {
            return pngFile;
        }
        SFile dir = pngFile.getParentFile();
        return dir.file(this.computeFilenameInternal(pngFile.getName(), i));
    }

    private String changeName(String fileName, String replacement) {
        String result = fileName.replaceAll("\\.\\w+$", replacement);
        if (result.equals(fileName)) {
            result = fileName + replacement;
        }
        return result;
    }

    private String computeFilenameInternal(String name, int i) {
        if (i == 0) {
            return name;
        }
        return name.replaceAll("\\" + this.getFileSuffix() + "$", OptionFlags.getInstance().getFileSeparator() + String.format("%03d", i) + this.getFileSuffix());
    }

    public boolean doesSupportMetadata() {
        return this == PNG || this == SVG;
    }

    public boolean equalsMetadata(String currentMetadata, SFile existingFile) {
        try {
            if (this == PNG) {
                MetadataTag tag = new MetadataTag(existingFile, "plantuml");
                String previousMetadata = tag.getData();
                boolean sameMetadata = currentMetadata.equals(previousMetadata);
                return sameMetadata;
            }
            if (this == SVG) {
                String svg = FileUtils.readSvg(existingFile);
                if (svg == null) {
                    return false;
                }
                String currentSignature = SvgGraphics.getMetadataHex(currentMetadata);
                int idx = svg.lastIndexOf("<!--SRC=[");
                if (idx != -1) {
                    String part = svg.substring(idx + "<!--SRC=[".length());
                    return part.startsWith(currentSignature + "]");
                }
            }
        }
        catch (IOException e) {
            Logme.error(e);
        }
        return false;
    }

    static {
        imDummy = new BufferedImage(800, 100, 1);
        gg = imDummy.createGraphics();
        gg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }
}

