/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp4;

import com.drew.imaging.mp4.Mp4Reader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.mp4.Mp4Directory;
import com.drew.metadata.mp4.media.Mp4SoundDirectory;
import com.drew.metadata.mp4.media.Mp4VideoDirectory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tika.exception.RuntimeSAXException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.mp4.TikaMp4BoxHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MP4Parser
extends AbstractParser {
    private static final long serialVersionUID = 84011216792285L;
    private static final Map<MediaType, List<String>> typesMap = new HashMap<MediaType, List<String>>();
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(typesMap.keySet());
    private static final MediaType APPLICATION_MP4 = MediaType.application("mp4");
    private static final int MAX_ERROR_MESSAGES = 100;

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, org.apache.tika.metadata.Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        TemporaryResources tmp = new TemporaryResources();
        TikaInputStream tstream = TikaInputStream.get(stream, tmp);
        try (InputStream is = Files.newInputStream(tstream.getPath(), new OpenOption[0]);){
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            Metadata mp4Metadata = new Metadata();
            TikaMp4BoxHandler boxHandler = new TikaMp4BoxHandler(mp4Metadata, metadata, xhtml);
            try {
                Mp4Reader.extract(is, boxHandler);
            }
            catch (RuntimeSAXException e) {
                throw (SAXException)e.getCause();
            }
            Set<String> errorMessages = this.processMp4Directories(mp4Metadata.getDirectoriesOfType(Mp4Directory.class), metadata);
            for (String m3 : errorMessages) {
                metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, m3);
            }
            xhtml.endDocument();
        }
        finally {
            tmp.dispose();
        }
    }

    private Set<String> processMp4Directories(Collection<Mp4Directory> mp4Directories, org.apache.tika.metadata.Metadata metadata) {
        HashSet<String> errorMsgs = new HashSet<String>();
        for (Mp4Directory mp4Directory : mp4Directories) {
            for (String m3 : mp4Directory.getErrors()) {
                if (errorMsgs.size() >= 100) break;
                errorMsgs.add(m3);
            }
            if (mp4Directory instanceof Mp4SoundDirectory) {
                this.processMp4SoundDirectory((Mp4SoundDirectory)mp4Directory, metadata);
                continue;
            }
            if (mp4Directory instanceof Mp4VideoDirectory) {
                this.processMp4VideoDirectory((Mp4VideoDirectory)mp4Directory, metadata);
                continue;
            }
            this.processActualMp4Directory(mp4Directory, metadata);
        }
        return errorMsgs;
    }

    private void processMp4VideoDirectory(Mp4VideoDirectory mp4Directory, org.apache.tika.metadata.Metadata metadata) {
        this.addInt(mp4Directory, metadata, 205, org.apache.tika.metadata.Metadata.IMAGE_LENGTH);
        this.addInt(mp4Directory, metadata, 204, org.apache.tika.metadata.Metadata.IMAGE_WIDTH);
        if (mp4Directory.containsTag(208)) {
            String compressor = mp4Directory.getString(208);
            metadata.set(XMPDM.VIDEO_COMPRESSOR, compressor);
        }
    }

    private void processMp4SoundDirectory(Mp4SoundDirectory mp4SoundDirectory, org.apache.tika.metadata.Metadata metadata) {
        this.addInt(mp4SoundDirectory, metadata, 304, XMPDM.AUDIO_SAMPLE_RATE);
        try {
            int numChannels = mp4SoundDirectory.getInt(302);
            if (numChannels == 1) {
                metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "Mono");
            } else if (numChannels == 2) {
                metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "Stereo");
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
    }

    private void addInt(Mp4Directory mp4Directory, org.apache.tika.metadata.Metadata metadata, int tag, Property property) {
        try {
            int val = mp4Directory.getInt(tag);
            metadata.set(property, val);
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
    }

    private void processActualMp4Directory(Mp4Directory mp4Directory, org.apache.tika.metadata.Metadata metadata) {
        this.addDate(mp4Directory, metadata, 256, TikaCoreProperties.CREATED);
        this.addDate(mp4Directory, metadata, 257, TikaCoreProperties.MODIFIED);
        this.handleBrands(mp4Directory, metadata);
        this.handleDurationInSeconds(mp4Directory, metadata);
        this.addDouble(mp4Directory, metadata, 8193, TikaCoreProperties.LATITUDE);
        this.addDouble(mp4Directory, metadata, 8194, TikaCoreProperties.LONGITUDE);
        this.addInt(mp4Directory, metadata, 258, XMPDM.AUDIO_SAMPLE_RATE);
    }

    private void handleDurationInSeconds(Mp4Directory mp4Directory, org.apache.tika.metadata.Metadata metadata) {
        String durationInSeconds = mp4Directory.getString(260);
        if (durationInSeconds == null) {
            return;
        }
        if (!durationInSeconds.contains("/")) {
            try {
                double d = Double.parseDouble(durationInSeconds);
                DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ROOT);
                df.applyPattern("0.0#");
                metadata.set(XMPDM.DURATION, df.format(d));
            }
            catch (NumberFormatException d) {
                // empty catch block
            }
            return;
        }
        String[] bits = durationInSeconds.split("/");
        if (bits.length != 2) {
            return;
        }
        try {
            long numerator = Long.parseLong(bits[0]);
            long denominator = Long.parseLong(bits[1]);
            if (denominator != 0L) {
                double durationSeconds = (double)numerator / (double)denominator;
                DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ROOT);
                df.applyPattern("0.0#");
                metadata.set(XMPDM.DURATION, df.format(durationSeconds));
            }
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    private void handleBrands(Mp4Directory mp4Directory, org.apache.tika.metadata.Metadata metadata) {
        String compatibleBrands;
        String majorBrand = mp4Directory.getString(1);
        Optional<MediaType> typeHolder = typesMap.entrySet().stream().filter(e -> ((List)e.getValue()).contains(majorBrand)).findFirst().map(Map.Entry::getKey);
        if (!typeHolder.isPresent() && (compatibleBrands = mp4Directory.getString(3)) != null) {
            typeHolder = typesMap.entrySet().stream().filter(e -> ((List)e.getValue()).stream().anyMatch(compatibleBrands::contains)).findFirst().map(Map.Entry::getKey);
        }
        MediaType type = typeHolder.orElse(MediaType.application("mp4"));
        if (metadata.getValues("Content-Type") == null) {
            metadata.set("Content-Type", type.toString());
        } else if (!type.equals(APPLICATION_MP4)) {
            metadata.set("Content-Type", type.toString());
        }
        if (type.getType().equals("audio") && !StringUtils.isBlank(majorBrand)) {
            metadata.set(XMPDM.AUDIO_COMPRESSOR, majorBrand.trim());
        }
    }

    private void addDate(Mp4Directory mp4Directory, org.apache.tika.metadata.Metadata metadata, int tag, Property property) {
        Date d = mp4Directory.getDate(tag);
        if (d == null) {
            return;
        }
        metadata.set(property, d);
    }

    private void addDouble(Directory mp4Directory, org.apache.tika.metadata.Metadata metadata, int tag, Property property) {
        try {
            double val = mp4Directory.getDouble(tag);
            metadata.set(property, val);
        }
        catch (MetadataException e) {
            return;
        }
    }

    static {
        typesMap.put(MediaType.audio("mp4"), Arrays.asList("M4A ", "M4B ", "F4A ", "F4B "));
        typesMap.put(MediaType.video("3gpp"), Arrays.asList("3ge6", "3ge7", "3gg6", "3gp1", "3gp2", "3gp3", "3gp4", "3gp5", "3gp6", "3gs7"));
        typesMap.put(MediaType.video("3gpp2"), Arrays.asList("3g2a", "3g2b", "3g2c"));
        typesMap.put(MediaType.video("mp4"), Arrays.asList("mp41", "mp42"));
        typesMap.put(MediaType.video("x-m4v"), Arrays.asList("M4V ", "M4VH", "M4VP"));
        typesMap.put(MediaType.video("quicktime"), Collections.emptyList());
        typesMap.put(MediaType.application("mp4"), Collections.emptyList());
    }
}

