/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.RecursiveParserWrapper;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.HandlerConfig;
import org.apache.tika.pipes.emitter.EmitData;
import org.apache.tika.pipes.emitter.EmitKey;
import org.apache.tika.pipes.emitter.Emitter;
import org.apache.tika.pipes.emitter.EmitterManager;
import org.apache.tika.pipes.emitter.TikaEmitterException;
import org.apache.tika.pipes.fetcher.FetchKey;
import org.apache.tika.pipes.fetcher.Fetcher;
import org.apache.tika.pipes.fetcher.FetcherManager;
import org.apache.tika.sax.BasicContentHandlerFactory;
import org.apache.tika.sax.RecursiveParserWrapperHandler;
import org.apache.tika.utils.ExceptionUtils;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class PipesServer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(PipesServer.class);
    public static final int TIMEOUT_EXIT_CODE = 17;
    public static final byte READY = 1;
    public static final byte CALL = 2;
    public static final byte PING = 3;
    public static final byte FAILED_TO_START = 4;
    public static final byte PARSE_SUCCESS = 5;
    public static final byte PARSE_EXCEPTION_NO_EMIT = 6;
    public static final byte PARSE_EXCEPTION_EMIT = 7;
    public static final byte EMIT_SUCCESS = 8;
    public static final byte EMIT_SUCCESS_PARSE_EXCEPTION = 9;
    public static final byte EMIT_EXCEPTION = 10;
    public static final byte NO_EMITTER_FOUND = 11;
    public static final byte OOM = 12;
    public static final byte TIMEOUT = 13;
    public static final byte EMPTY_OUTPUT = 14;
    private final Object[] lock = new Object[0];
    private final Path tikaConfigPath;
    private final DataInputStream input;
    private final DataOutputStream output;
    private final long maxExtractSizeToReturn;
    private final long serverParseTimeoutMillis;
    private final long serverWaitTimeoutMillis;
    private Parser parser;
    private TikaConfig tikaConfig;
    private FetcherManager fetcherManager;
    private EmitterManager emitterManager;
    private volatile boolean parsing;
    private volatile long since;

    public PipesServer(Path tikaConfigPath, InputStream in, PrintStream out, long maxExtractSizeToReturn, long serverParseTimeoutMillis, long serverWaitTimeoutMillis) throws IOException, TikaException, SAXException {
        this.tikaConfigPath = tikaConfigPath;
        this.input = new DataInputStream(in);
        this.output = new DataOutputStream(out);
        this.maxExtractSizeToReturn = maxExtractSizeToReturn;
        this.serverParseTimeoutMillis = serverParseTimeoutMillis;
        this.serverWaitTimeoutMillis = serverWaitTimeoutMillis;
        this.parsing = false;
        this.since = System.currentTimeMillis();
    }

    public static void main(String[] args) throws Exception {
        Path tikaConfig = Paths.get(args[0], new String[0]);
        long maxForEmitBatchBytes = Long.parseLong(args[1]);
        long serverParseTimeoutMillis = Long.parseLong(args[2]);
        long serverWaitTimeoutMillis = Long.parseLong(args[3]);
        PipesServer server = new PipesServer(tikaConfig, System.in, System.out, maxForEmitBatchBytes, serverParseTimeoutMillis, serverWaitTimeoutMillis);
        System.setIn(new ByteArrayInputStream(new byte[0]));
        System.setOut(System.err);
        Thread watchdog = new Thread((Runnable)server, "Tika Watchdog");
        watchdog.setDaemon(true);
        watchdog.start();
        server.processRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (true) {
                Object[] objectArray = this.lock;
                // MONITORENTER : this.lock
                long elapsed = System.currentTimeMillis() - this.since;
                if (this.parsing && elapsed > this.serverParseTimeoutMillis) {
                    LOG.warn("timeout server; elapsed {}  with {}", (Object)elapsed, (Object)this.serverParseTimeoutMillis);
                    this.exit(17);
                } else if (!this.parsing && this.serverWaitTimeoutMillis > 0L && elapsed > this.serverWaitTimeoutMillis) {
                    LOG.debug("closing down from inactivity");
                    this.exit(0);
                }
                // MONITOREXIT : objectArray
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void processRequests() {
        try {
            this.initializeParser();
        }
        catch (Throwable t) {
            LOG.error("couldn't initialize parser", t);
            try {
                this.output.writeByte(4);
                this.output.flush();
            }
            catch (IOException e) {
                LOG.warn("couldn't notify of failure to start", e);
            }
            return;
        }
        try {
            this.output.write(1);
            this.output.flush();
            while (true) {
                int request;
                if ((request = this.input.read()) == -1) {
                    this.exit(1);
                } else if (request == 3) {
                    this.output.writeByte(3);
                    this.output.flush();
                } else if (request == 2) {
                    this.parseOne();
                } else {
                    throw new IllegalStateException("Unexpected request");
                }
                this.output.flush();
            }
        }
        catch (Throwable t) {
            LOG.error("main loop error (did the forking process shut down?)", t);
            this.exit(1);
            System.err.flush();
            return;
        }
    }

    private boolean metadataIsEmpty(List<Metadata> metadataList) {
        return metadataList == null || metadataList.size() == 0;
    }

    private String getContainerStacktrace(FetchEmitTuple t, List<Metadata> metadataList) {
        if (metadataList == null || metadataList.size() < 1) {
            return "";
        }
        String stack = metadataList.get(0).get(TikaCoreProperties.CONTAINER_EXCEPTION);
        return stack != null ? stack : "";
    }

    private void emit(EmitData emitData, String parseExceptionStack) {
        Emitter emitter = this.emitterManager.getEmitter(emitData.getEmitKey().getEmitterName());
        if (emitter == null) {
            this.write((byte)11, new byte[0]);
            return;
        }
        try {
            emitter.emit(emitData.getEmitKey().getEmitKey(), emitData.getMetadataList());
        }
        catch (IOException | TikaEmitterException e) {
            String msg = ExceptionUtils.getStackTrace(e);
            byte[] bytes = msg.getBytes(StandardCharsets.UTF_8);
            this.write((byte)10, bytes);
            return;
        }
        if (StringUtils.isBlank(parseExceptionStack)) {
            this.write((byte)8);
        } else {
            this.write((byte)9, parseExceptionStack.getBytes(StandardCharsets.UTF_8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseOne() throws FetchException {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            this.parsing = true;
            this.since = System.currentTimeMillis();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                this.actuallyParse();
            }
            finally {
                objectArray = this.lock;
                synchronized (this.lock) {
                    this.parsing = false;
                    this.since = System.currentTimeMillis();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            return;
        }
    }

    public void actuallyParse() throws FetchException {
        FetchEmitTuple t = this.readFetchEmitTuple();
        List<Metadata> metadataList = null;
        Fetcher fetcher = this.getFetcher(t.getFetchKey().getFetcherName());
        Metadata metadata = new Metadata();
        try (InputStream stream = fetcher.fetch(t.getFetchKey().getFetchKey(), metadata);){
            metadataList = this.parseMetadata(t, stream, metadata);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (IOException | TikaException e) {
            LOG.warn("fetch exception", e);
            throw new FetchException(e);
        }
        catch (OutOfMemoryError e) {
            this.handleOOM(e);
        }
        if (this.metadataIsEmpty(metadataList)) {
            this.write((byte)14);
            return;
        }
        String stack = this.getContainerStacktrace(t, metadataList);
        if (StringUtils.isBlank(stack) || t.getOnParseException() == FetchEmitTuple.ON_PARSE_EXCEPTION.EMIT) {
            EmitData emitData;
            this.injectUserMetadata(t.getMetadata(), metadataList);
            EmitKey emitKey = t.getEmitKey();
            if (StringUtils.isBlank(emitKey.getEmitKey())) {
                emitKey = new EmitKey(emitKey.getEmitterName(), t.getFetchKey().getFetchKey());
                t.setEmitKey(emitKey);
            }
            if ((emitData = new EmitData(t.getEmitKey(), metadataList)).getEstimatedSizeBytes() >= this.maxExtractSizeToReturn) {
                this.emit(emitData, stack);
            } else {
                this.write(emitData, stack);
            }
        } else {
            this.write((byte)6, stack.getBytes(StandardCharsets.UTF_8));
        }
    }

    private Fetcher getFetcher(String fetcherName) throws FetchException {
        try {
            return this.fetcherManager.getFetcher(fetcherName);
        }
        catch (IOException | TikaException e) {
            LOG.error("can't load fetcher", e);
            throw new FetchException(e);
        }
    }

    private void handleOOM(OutOfMemoryError oom) {
        try {
            this.output.writeByte(12);
            this.output.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LOG.error("oom", oom);
        this.exit(1);
    }

    private List<Metadata> parseMetadata(FetchEmitTuple fetchEmitTuple, InputStream stream, Metadata metadata) {
        HandlerConfig handlerConfig = fetchEmitTuple.getHandlerConfig();
        RecursiveParserWrapperHandler handler = new RecursiveParserWrapperHandler(new BasicContentHandlerFactory(handlerConfig.getType(), handlerConfig.getWriteLimit()), handlerConfig.getMaxEmbeddedResources(), this.tikaConfig.getMetadataFilter());
        ParseContext parseContext = new ParseContext();
        FetchKey fetchKey = fetchEmitTuple.getFetchKey();
        try {
            this.parser.parse(stream, handler, metadata, parseContext);
        }
        catch (SAXException e) {
            LOG.warn("sax problem:" + fetchEmitTuple.getId(), e);
        }
        catch (EncryptedDocumentException e) {
            LOG.warn("encrypted document:" + fetchEmitTuple.getId(), e);
        }
        catch (SecurityException e) {
            LOG.warn("security exception:" + fetchEmitTuple.getId(), e);
            throw e;
        }
        catch (Exception e) {
            LOG.warn("exception: " + fetchEmitTuple.getId(), e);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        return handler.getMetadataList();
    }

    private void injectUserMetadata(Metadata userMetadata, List<Metadata> metadataList) {
        for (String n : userMetadata.names()) {
            metadataList.get(0).set(n, null);
            for (String val : userMetadata.getValues(n)) {
                metadataList.get(0).add(n, val);
            }
        }
    }

    private void exit(int exitCode) {
        LOG.warn("exiting: {}", (Object)exitCode);
        System.exit(exitCode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FetchEmitTuple readFetchEmitTuple() {
        try {
            int length = this.input.readInt();
            byte[] bytes = new byte[length];
            this.input.readFully(bytes);
            try (ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(bytes));){
                FetchEmitTuple fetchEmitTuple = (FetchEmitTuple)objectInputStream.readObject();
                return fetchEmitTuple;
            }
        }
        catch (IOException e) {
            LOG.error("problem reading tuple", e);
            this.exit(1);
            return null;
        }
        catch (ClassNotFoundException e) {
            LOG.error("can't find class?!", e);
            this.exit(1);
        }
        return null;
    }

    private void initializeParser() throws TikaException, IOException, SAXException {
        this.tikaConfig = new TikaConfig(this.tikaConfigPath);
        this.fetcherManager = FetcherManager.load(this.tikaConfigPath);
        this.emitterManager = EmitterManager.load(this.tikaConfigPath);
        AutoDetectParser autoDetectParser = new AutoDetectParser(this.tikaConfig);
        this.parser = new RecursiveParserWrapper(autoDetectParser);
    }

    private void write(EmitData emitData, String stack) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(bos);){
                objectOutputStream.writeObject(emitData);
            }
            this.write((byte)5, bos.toByteArray());
        }
        catch (IOException e) {
            LOG.error("problem writing emit data (forking process shutdown?)", e);
            this.exit(1);
        }
    }

    private void write(byte status, byte[] bytes) {
        try {
            int len = bytes.length;
            this.output.write(status);
            this.output.writeInt(len);
            this.output.write(bytes);
            this.output.flush();
        }
        catch (IOException e) {
            LOG.error("problem writing data (forking process shutdown?)", e);
            this.exit(1);
        }
    }

    private void write(byte status) {
        try {
            this.output.write(status);
            this.output.flush();
        }
        catch (IOException e) {
            LOG.error("problem writing data (forking process shutdown?)", e);
            this.exit(1);
        }
    }

    private static class FetchException
    extends IOException {
        FetchException(Throwable t) {
            super(t);
        }
    }
}

