/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.ocr;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.exception.TikaException;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TesseractOCRConfig
implements Serializable {
    private static final long serialVersionUID = -4861942486845757891L;
    private static final Logger LOG = LoggerFactory.getLogger(TesseractOCRConfig.class);
    private static Pattern ALLOWABLE_PAGE_SEPARATORS_PATTERN = Pattern.compile("(?i)^[-_/\\.A-Z0-9]+$");
    private static Pattern ALLOWABLE_OTHER_PARAMS_PATTERN = Pattern.compile("(?i)^[-_/\\.A-Z0-9]+$");
    private String language = "eng";
    private String pageSegMode = "1";
    private long minFileSizeToOcr = 0L;
    private long maxFileSizeToOcr = Integer.MAX_VALUE;
    private int timeoutSeconds = 120;
    private OUTPUT_TYPE outputType = OUTPUT_TYPE.TXT;
    private boolean enableImagePreprocessing = false;
    private int density = 300;
    private int depth = 4;
    private String colorspace = "gray";
    private String filter = "triangle";
    private int resize = 200;
    private String pageSeparator = "";
    private boolean preserveInterwordSpacing = false;
    private boolean applyRotation = false;
    private boolean skipOcr = false;
    private Map<String, String> otherTesseractConfig = new HashMap<String, String>();
    private Set<String> userConfigured = new HashSet<String>();

    public static void getLangs(String language, Set<String> validLangs, Set<String> invalidLangs) {
        String[] langs;
        if (StringUtils.isBlank(language)) {
            return;
        }
        if ((language = language.replaceAll("\\s", "")).matches("\\+.*|.*\\+")) {
            throw new IllegalArgumentException("Invalid syntax - Can't start or end with +" + language);
        }
        for (String lang : langs = language.split("\\+")) {
            if (!lang.matches("([a-zA-Z]{3}(_[a-zA-Z]{3,4}){0,2})|script(/|\\\\)[A-Z][a-zA-Z_]+")) {
                invalidLangs.add(lang + " (invalid syntax)");
                continue;
            }
            validLangs.add(lang);
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String languageString) {
        HashSet<String> invalidCodes = new HashSet<String>();
        HashSet<String> validCodes = new HashSet<String>();
        TesseractOCRConfig.getLangs(languageString, validCodes, invalidCodes);
        if (!invalidCodes.isEmpty()) {
            throw new IllegalArgumentException("Invalid language code(s): " + invalidCodes);
        }
        this.language = languageString;
        this.userConfigured.add("language");
    }

    public String getPageSegMode() {
        return this.pageSegMode;
    }

    public void setPageSegMode(String pageSegMode) {
        if (!pageSegMode.matches("[0-9]|10|11|12|13")) {
            throw new IllegalArgumentException("Invalid page segmentation mode");
        }
        this.pageSegMode = pageSegMode;
        this.userConfigured.add("pageSegMode");
    }

    public String getPageSeparator() {
        return this.pageSeparator;
    }

    public void setPageSeparator(String pageSeparator) {
        Matcher m3 = ALLOWABLE_PAGE_SEPARATORS_PATTERN.matcher(pageSeparator);
        if (!m3.find()) {
            throw new IllegalArgumentException(pageSeparator + " contains illegal characters.\nIf you trust this value, set it with setTrustedPageSeparator");
        }
        this.setTrustedPageSeparator(pageSeparator);
        this.userConfigured.add("pageSeparator");
    }

    public void setTrustedPageSeparator(String pageSeparator) {
        this.pageSeparator = pageSeparator;
    }

    public boolean isPreserveInterwordSpacing() {
        return this.preserveInterwordSpacing;
    }

    public void setPreserveInterwordSpacing(boolean preserveInterwordSpacing) {
        this.preserveInterwordSpacing = preserveInterwordSpacing;
        this.userConfigured.add("preserveInterwordSpacing");
    }

    public long getMinFileSizeToOcr() {
        return this.minFileSizeToOcr;
    }

    public void setMinFileSizeToOcr(long minFileSizeToOcr) {
        this.minFileSizeToOcr = minFileSizeToOcr;
        this.userConfigured.add("minFileSizeToOcr");
    }

    public long getMaxFileSizeToOcr() {
        return this.maxFileSizeToOcr;
    }

    public void setMaxFileSizeToOcr(long maxFileSizeToOcr) {
        this.maxFileSizeToOcr = maxFileSizeToOcr;
        this.userConfigured.add("maxFileSizeToOcr");
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        this.userConfigured.add("timeoutSeconds");
    }

    public OUTPUT_TYPE getOutputType() {
        return this.outputType;
    }

    public void setOutputType(OUTPUT_TYPE outputType) {
        this.outputType = outputType;
        this.userConfigured.add("outputType");
    }

    public void setOutputType(String outputType) {
        if (outputType == null) {
            throw new IllegalArgumentException("outputType must not be null");
        }
        String lc = outputType.toLowerCase(Locale.US);
        if ("txt".equals(lc)) {
            this.setOutputType(OUTPUT_TYPE.TXT);
        } else if ("hocr".equals(lc)) {
            this.setOutputType(OUTPUT_TYPE.HOCR);
        } else {
            throw new IllegalArgumentException("outputType must be either 'txt' or 'hocr'");
        }
    }

    public boolean isEnableImagePreprocessing() {
        return this.enableImagePreprocessing;
    }

    public void setEnableImagePreprocessing(boolean enableImagePreprocessing) {
        this.enableImagePreprocessing = enableImagePreprocessing;
        this.userConfigured.add("enableImagePreprocessing");
    }

    public int getDensity() {
        return this.density;
    }

    public void setDensity(int density) {
        if (density < 150 || density > 1200) {
            throw new IllegalArgumentException("Invalid density value. Valid range of values is 150-1200.");
        }
        this.density = density;
        this.userConfigured.add("density");
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        int[] allowedValues;
        for (int allowedValue : allowedValues = new int[]{2, 4, 8, 16, 32, 64, 256, 4096}) {
            if (depth != allowedValue) continue;
            this.depth = depth;
            this.userConfigured.add("depth");
            return;
        }
        throw new IllegalArgumentException("Invalid depth value. Valid values are 2, 4, 8, 16, 32, 64, 256, 4096.");
    }

    public String getColorspace() {
        return this.colorspace;
    }

    public void setColorspace(String colorspace) {
        if (colorspace == null) {
            throw new IllegalArgumentException("Colorspace value cannot be null.");
        }
        if (!colorspace.matches("(?i)^[-_A-Z0-9]+$")) {
            throw new IllegalArgumentException("colorspace must match this pattern: (?i)^[-_A-Z0-9]+$");
        }
        this.colorspace = colorspace;
        this.userConfigured.add("colorspace");
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        String[] allowedFilters;
        if (filter.equals(null)) {
            throw new IllegalArgumentException("Filter value cannot be null. Valid values are point, hermite, cubic, box, gaussian, catrom, triangle, quadratic and mitchell.");
        }
        for (String allowedFilter : allowedFilters = new String[]{"Point", "Hermite", "Cubic", "Box", "Gaussian", "Catrom", "Triangle", "Quadratic", "Mitchell"}) {
            if (!filter.equalsIgnoreCase(allowedFilter)) continue;
            this.filter = filter;
            this.userConfigured.add("filter");
            return;
        }
        throw new IllegalArgumentException("Invalid filter value. Valid values are point, hermite, cubic, box, gaussian, catrom, triangle, quadratic and mitchell.");
    }

    public boolean isSkipOcr() {
        return this.skipOcr;
    }

    public void setSkipOcr(boolean skipOcr) {
        this.skipOcr = skipOcr;
        this.userConfigured.add("skipOcr");
    }

    public int getResize() {
        return this.resize;
    }

    public void setResize(int resize) {
        for (int i = 1; i < 10; ++i) {
            if (resize != i * 100) continue;
            this.resize = resize;
            this.userConfigured.add("resize");
            return;
        }
        throw new IllegalArgumentException("Invalid resize value. Valid range of values is 100-900.");
    }

    public boolean isApplyRotation() {
        return this.applyRotation;
    }

    public void setApplyRotation(boolean applyRotation) {
        this.applyRotation = applyRotation;
        this.userConfigured.add("applyRotation");
    }

    public Map<String, String> getOtherTesseractConfig() {
        return this.otherTesseractConfig;
    }

    public void addOtherTesseractConfig(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        Matcher m3 = ALLOWABLE_OTHER_PARAMS_PATTERN.matcher(key);
        if (!m3.find()) {
            throw new IllegalArgumentException("Key contains illegal characters: " + key);
        }
        m3.reset(value);
        if (!m3.find()) {
            throw new IllegalArgumentException("Value contains illegal characters: " + value);
        }
        this.otherTesseractConfig.put(key.trim(), value.trim());
        this.userConfigured.add("otherTesseractConfig");
    }

    public TesseractOCRConfig cloneAndUpdate(TesseractOCRConfig updates) throws TikaException {
        TesseractOCRConfig updated = new TesseractOCRConfig();
        for (Field field : this.getClass().getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || "userConfigured".equals(field.getName())) continue;
            if ("otherTesseractConfig".equals(field.getName()) && updates.userConfigured.contains(field.getName())) {
                for (Map.Entry<String, String> e : updates.getOtherTesseractConfig().entrySet()) {
                    updated.addOtherTesseractConfig(e.getKey(), e.getValue());
                }
                continue;
            }
            if (updates.userConfigured.contains(field.getName())) {
                try {
                    field.set(updated, field.get(updates));
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new TikaException("can't update " + field.getName(), e);
                }
            }
            try {
                field.set(updated, field.get(this));
            }
            catch (IllegalAccessException e) {
                throw new TikaException("can't update " + field.getName(), e);
            }
        }
        return updated;
    }

    public static enum OUTPUT_TYPE {
        TXT,
        HOCR;

    }
}

