/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.xml;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.WriteLimitReachedException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.OfficeOpenXMLExtended;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.xml.ElementMetadataHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.TaggedContentHandler;
import org.apache.tika.sax.TeeContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractXML2003Parser
extends AbstractParser {
    static final String MS_OFFICE_PROPERTIES_URN = "urn:schemas-microsoft-com:office:office";
    static final String MS_DOC_PROPERTIES_URN = "urn:schemas-microsoft-com:office:office";
    static final String MS_SPREADSHEET_URN = "urn:schemas-microsoft-com:office:spreadsheet";
    static final String MS_VML_URN = "urn:schemas-microsoft-com:vml";
    static final String WORD_ML_URL = "http://schemas.microsoft.com/office/word/2003/wordml";
    static final Attributes EMPTY_ATTRS = new AttributesImpl();
    static final String DOCUMENT_PROPERTIES = "DocumentProperties";
    static final String PICT = "pict";
    static final String BIN_DATA = "binData";
    static final String A = "a";
    static final String BODY = "body";
    static final String BR = "br";
    static final String CDATA = "cdata";
    static final String DIV = "div";
    static final String HREF = "href";
    static final String IMG = "img";
    static final String P = "p";
    static final String TD = "td";
    static final String TR = "tr";
    static final String TABLE = "table";
    static final String TBODY = "tbody";
    static final String HLINK = "hlink";
    static final String HLINK_DEST = "dest";
    static final String NAME_ATTR = "name";
    static final char[] NEWLINE = new char[]{'\n'};

    private static ContentHandler getMSPropertiesHandler(Metadata metadata, Property property, String element) {
        return new ElementMetadataHandler("urn:schemas-microsoft-com:office:office", element, metadata, property);
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        this.setContentType(metadata);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        TaggedContentHandler tagged = new TaggedContentHandler(xhtml);
        try {
            XMLReaderUtils.getSAXParser().parse((InputStream)new CloseShieldInputStream(stream), (DefaultHandler)new OfflineContentHandler(new EmbeddedContentHandler(this.getContentHandler(tagged, metadata, context))));
        }
        catch (SAXException e) {
            WriteLimitReachedException.throwIfWriteLimitReached(e);
            throw new TikaException("XML parse error", e);
        }
        finally {
            xhtml.endDocument();
        }
    }

    protected ContentHandler getContentHandler(ContentHandler ch, Metadata md, ParseContext context) {
        return new TeeContentHandler(AbstractXML2003Parser.getMSPropertiesHandler(md, TikaCoreProperties.TITLE, "Title"), AbstractXML2003Parser.getMSPropertiesHandler(md, TikaCoreProperties.CREATOR, "Author"), AbstractXML2003Parser.getMSPropertiesHandler(md, Office.LAST_AUTHOR, "LastAuthor"), AbstractXML2003Parser.getMSPropertiesHandler(md, OfficeOpenXMLCore.REVISION, "Revision"), AbstractXML2003Parser.getMSPropertiesHandler(md, OfficeOpenXMLExtended.TOTAL_TIME, "TotalTime"), AbstractXML2003Parser.getMSPropertiesHandler(md, TikaCoreProperties.CREATED, "Created"), AbstractXML2003Parser.getMSPropertiesHandler(md, Office.SAVE_DATE, "LastSaved"), AbstractXML2003Parser.getMSPropertiesHandler(md, Office.PAGE_COUNT, "Pages"), AbstractXML2003Parser.getMSPropertiesHandler(md, Office.WORD_COUNT, "Words"), AbstractXML2003Parser.getMSPropertiesHandler(md, Office.CHARACTER_COUNT, "Characters"), AbstractXML2003Parser.getMSPropertiesHandler(md, Office.CHARACTER_COUNT_WITH_SPACES, "CharactersWithSpaces"), AbstractXML2003Parser.getMSPropertiesHandler(md, OfficeOpenXMLExtended.COMPANY, "Company"), AbstractXML2003Parser.getMSPropertiesHandler(md, Office.LINE_COUNT, "Lines"), AbstractXML2003Parser.getMSPropertiesHandler(md, Office.PARAGRAPH_COUNT, "Paragraphs"), AbstractXML2003Parser.getMSPropertiesHandler(md, OfficeOpenXMLCore.VERSION, "Version"));
    }

    protected abstract void setContentType(Metadata var1);
}

