/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.serialization.JsonMetadata;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.HandlerConfig;
import org.apache.tika.pipes.emitter.EmitKey;
import org.apache.tika.pipes.fetcher.FetchKey;
import org.apache.tika.sax.BasicContentHandlerFactory;
import org.apache.tika.utils.StringUtils;

public class JsonFetchEmitTuple {
    public static final String ID = "id";
    public static final String FETCHER = "fetcher";
    public static final String FETCHKEY = "fetchKey";
    public static final String EMITTER = "emitter";
    public static final String EMITKEY = "emitKey";
    public static final String METADATAKEY = "metadata";
    public static final String HANDLER_CONFIG = "handlerConfig";
    public static final String ON_PARSE_EXCEPTION = "onParseException";
    private static final String HANDLER_CONFIG_TYPE = "type";
    private static final String HANDLER_CONFIG_WRITE_LIMIT = "writeLimit";
    private static final String HANDLER_CONFIG_MAX_EMBEDDED_RESOURCES = "maxEmbeddedResources";

    public static FetchEmitTuple fromJson(Reader reader) throws IOException {
        try (JsonParser jParser = new JsonFactory().createParser(reader);){
            JsonToken token = jParser.nextToken();
            if (token != JsonToken.START_OBJECT) {
                throw new IOException("require start object, but see: " + token.name());
            }
            FetchEmitTuple fetchEmitTuple = JsonFetchEmitTuple.parseFetchEmitTuple(jParser);
            return fetchEmitTuple;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static FetchEmitTuple parseFetchEmitTuple(JsonParser jParser) throws IOException {
        JsonToken token = jParser.nextToken();
        if (token == JsonToken.START_OBJECT) {
            token = jParser.nextToken();
        }
        String id = null;
        String fetcherName = null;
        String fetchKey = null;
        String emitterName = null;
        String emitKey = null;
        FetchEmitTuple.ON_PARSE_EXCEPTION onParseException = FetchEmitTuple.DEFAULT_ON_PARSE_EXCEPTION;
        HandlerConfig handlerConfig = HandlerConfig.DEFAULT_HANDLER_CONFIG;
        Metadata metadata = new Metadata();
        while (token != JsonToken.END_OBJECT) {
            if (token != JsonToken.FIELD_NAME) {
                throw new IOException("required field name, but see: " + token.name());
            }
            String name = jParser.getCurrentName();
            if (ID.equals(name)) {
                id = JsonFetchEmitTuple.getValue(jParser);
            } else if (FETCHER.equals(name)) {
                fetcherName = JsonFetchEmitTuple.getValue(jParser);
            } else if (FETCHKEY.equals(name)) {
                fetchKey = JsonFetchEmitTuple.getValue(jParser);
            } else if (EMITTER.equals(name)) {
                emitterName = JsonFetchEmitTuple.getValue(jParser);
            } else if (EMITKEY.equals(name)) {
                emitKey = JsonFetchEmitTuple.getValue(jParser);
            } else if (METADATAKEY.equals(name)) {
                token = jParser.nextToken();
                if (token != JsonToken.START_OBJECT) {
                    throw new IOException("required start object, but see: " + token.name());
                }
                metadata = JsonMetadata.readMetadataObject(jParser);
            } else if (ON_PARSE_EXCEPTION.equals(name)) {
                String value = JsonFetchEmitTuple.getValue(jParser);
                if ("skip".equalsIgnoreCase(value)) {
                    onParseException = FetchEmitTuple.ON_PARSE_EXCEPTION.SKIP;
                } else {
                    if (!"emit".equalsIgnoreCase(value)) throw new IOException("onParseException must be either 'skip' or 'emit'");
                    onParseException = FetchEmitTuple.ON_PARSE_EXCEPTION.EMIT;
                }
            } else if (HANDLER_CONFIG.equals(name)) {
                handlerConfig = JsonFetchEmitTuple.getHandlerConfig(jParser);
            }
            token = jParser.nextToken();
        }
        if (id != null) return new FetchEmitTuple(id, new FetchKey(fetcherName, fetchKey), new EmitKey(emitterName, emitKey), metadata, handlerConfig, onParseException);
        id = fetchKey;
        return new FetchEmitTuple(id, new FetchKey(fetcherName, fetchKey), new EmitKey(emitterName, emitKey), metadata, handlerConfig, onParseException);
    }

    private static HandlerConfig getHandlerConfig(JsonParser jParser) throws IOException {
        JsonToken token = jParser.nextToken();
        if (token != JsonToken.START_OBJECT) {
            throw new IOException("required start object, but see: " + token.name());
        }
        BasicContentHandlerFactory.HANDLER_TYPE handlerType = BasicContentHandlerFactory.HANDLER_TYPE.TEXT;
        int writeLimit = -1;
        int maxEmbeddedResources = -1;
        String fieldName = jParser.nextFieldName();
        while (fieldName != null) {
            switch (fieldName) {
                case "type": {
                    String value = jParser.nextTextValue();
                    handlerType = BasicContentHandlerFactory.parseHandlerType(value, HandlerConfig.DEFAULT_HANDLER_CONFIG.getType());
                    break;
                }
                case "writeLimit": {
                    writeLimit = jParser.nextIntValue(-1);
                    break;
                }
                case "maxEmbeddedResources": {
                    maxEmbeddedResources = jParser.nextIntValue(-1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("I regret I don't understand '" + fieldName + "' in the context of a handler config");
                }
            }
            fieldName = jParser.nextFieldName();
        }
        return new HandlerConfig(handlerType, writeLimit, maxEmbeddedResources);
    }

    private static String getValue(JsonParser jParser) throws IOException {
        JsonToken token = jParser.nextToken();
        if (token != JsonToken.VALUE_STRING) {
            throw new IOException("required value string, but see: " + token.name());
        }
        return jParser.getValueAsString();
    }

    public static String toJson(FetchEmitTuple t) throws IOException {
        StringWriter writer = new StringWriter();
        JsonFetchEmitTuple.toJson(t, writer);
        return writer.toString();
    }

    public static void toJson(FetchEmitTuple t, Writer writer) throws IOException {
        try (JsonGenerator jsonGenerator = new JsonFactory().createGenerator(writer);){
            JsonFetchEmitTuple.writeTuple(t, jsonGenerator);
        }
    }

    static void writeTuple(FetchEmitTuple t, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(ID, t.getId());
        jsonGenerator.writeStringField(FETCHER, t.getFetchKey().getFetcherName());
        jsonGenerator.writeStringField(FETCHKEY, t.getFetchKey().getFetchKey());
        jsonGenerator.writeStringField(EMITTER, t.getEmitKey().getEmitterName());
        if (!StringUtils.isBlank(t.getEmitKey().getEmitKey())) {
            jsonGenerator.writeStringField(EMITKEY, t.getEmitKey().getEmitKey());
        }
        if (t.getMetadata().size() > 0) {
            jsonGenerator.writeFieldName(METADATAKEY);
            JsonMetadata.writeMetadataObject(t.getMetadata(), jsonGenerator, false);
        }
        if (t.getHandlerConfig() != HandlerConfig.DEFAULT_HANDLER_CONFIG) {
            jsonGenerator.writeFieldName(HANDLER_CONFIG);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField(HANDLER_CONFIG_TYPE, t.getHandlerConfig().getType().name().toLowerCase(Locale.ROOT));
            jsonGenerator.writeNumberField(HANDLER_CONFIG_WRITE_LIMIT, t.getHandlerConfig().getWriteLimit());
            jsonGenerator.writeNumberField(HANDLER_CONFIG_MAX_EMBEDDED_RESOURCES, t.getHandlerConfig().getMaxEmbeddedResources());
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeStringField(ON_PARSE_EXCEPTION, t.getOnParseException().name().toLowerCase(Locale.US));
        jsonGenerator.writeEndObject();
    }
}

