/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.common.usermodel.GenericRecord;
import org.apache.poi.hslf.blip.DIB;
import org.apache.poi.hslf.blip.EMF;
import org.apache.poi.hslf.blip.JPEG;
import org.apache.poi.hslf.blip.PICT;
import org.apache.poi.hslf.blip.PNG;
import org.apache.poi.hslf.blip.WMF;
import org.apache.poi.poifs.crypt.CryptoFunctions;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.Units;

public abstract class HSLFPictureData
implements PictureData,
GenericRecord {
    protected static final int CHECKSUM_SIZE = 16;
    private byte[] rawdata;
    private int offset;
    private int uidInstanceCount = 1;
    private int index = -1;

    protected abstract int getSignature();

    public abstract void setSignature(int var1);

    protected int getUIDInstanceCount() {
        return this.uidInstanceCount;
    }

    protected void setUIDInstanceCount(int uidInstanceCount) {
        this.uidInstanceCount = uidInstanceCount;
    }

    public byte[] getRawData() {
        return this.rawdata;
    }

    public void setRawData(byte[] data) {
        this.rawdata = data == null ? null : (byte[])data.clone();
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public byte[] getUID() {
        byte[] uid = new byte[16];
        System.arraycopy(this.rawdata, 0, uid, 0, uid.length);
        return uid;
    }

    @Override
    public byte[] getChecksum() {
        return HSLFPictureData.getChecksum(this.getData());
    }

    public static byte[] getChecksum(byte[] data) {
        MessageDigest md5 = CryptoFunctions.getMessageDigest(HashAlgorithm.md5);
        md5.update(data);
        return md5.digest();
    }

    public void write(OutputStream out) throws IOException {
        byte[] data = new byte[2];
        LittleEndian.putUShort(data, 0, this.getSignature());
        out.write(data);
        data = new byte[2];
        PictureData.PictureType pt = this.getType();
        LittleEndian.putUShort(data, 0, pt.nativeId + 61464);
        out.write(data);
        byte[] rd = this.getRawData();
        data = new byte[4];
        LittleEndian.putInt(data, 0, rd.length);
        out.write(data);
        out.write(rd);
    }

    public static HSLFPictureData create(PictureData.PictureType type) {
        HSLFPictureData pict;
        switch (type) {
            case EMF: {
                pict = new EMF();
                break;
            }
            case WMF: {
                pict = new WMF();
                break;
            }
            case PICT: {
                pict = new PICT();
                break;
            }
            case JPEG: {
                pict = new JPEG();
                break;
            }
            case PNG: {
                pict = new PNG();
                break;
            }
            case DIB: {
                pict = new DIB();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported picture type: " + (Object)((Object)type));
            }
        }
        return pict;
    }

    public byte[] getHeader() {
        byte[] header = new byte[24];
        LittleEndian.putInt(header, 0, this.getSignature());
        LittleEndian.putInt(header, 4, this.getRawData().length);
        System.arraycopy(this.rawdata, 0, header, 8, 16);
        return header;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public final String getContentType() {
        return this.getType().contentType;
    }

    @Override
    public Dimension getImageDimensionInPixels() {
        Dimension dim = this.getImageDimension();
        return new Dimension(Units.pointsToPixel(dim.getWidth()), Units.pointsToPixel(dim.getHeight()));
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        LinkedHashMap<String, Supplier<Object>> m3 = new LinkedHashMap<String, Supplier<Object>>();
        m3.put("type", this::getType);
        m3.put("imageDimension", this::getImageDimension);
        m3.put("signature", this::getSignature);
        m3.put("uidInstanceCount", this::getUIDInstanceCount);
        m3.put("offset", this::getOffset);
        m3.put("uid", this::getUID);
        m3.put("checksum", this::getChecksum);
        m3.put("index", this::getIndex);
        m3.put("rawData", this::getRawData);
        return Collections.unmodifiableMap(m3);
    }
}

