/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.hexviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.apache.pdfbox.debugger.hexviewer.HexModel;
import org.apache.pdfbox.debugger.hexviewer.HexModelChangeListener;
import org.apache.pdfbox.debugger.hexviewer.HexModelChangedEvent;
import org.apache.pdfbox.debugger.hexviewer.HexView;

class ASCIIPane
extends JComponent
implements HexModelChangeListener {
    private final HexModel model;
    private int selectedLine = -1;
    private int selectedIndexInLine;

    ASCIIPane(HexModel model) {
        this.model = model;
        this.setPreferredSize(new Dimension(270, 20 * (model.totalLine() + 1)));
        model.addHexModelChangeListener(this);
        this.setFont(HexView.FONT);
    }

    @Override
    protected void paintComponent(Graphics g2) {
        int firstLine;
        super.paintComponent(g2);
        Graphics2D g2d = (Graphics2D)g2;
        g2d.setRenderingHints(HexView.RENDERING_HINTS);
        Rectangle bound = this.getVisibleRect();
        int x = 20;
        int y = bound.y;
        if (y == 0 || y % 20 != 0) {
            y += 20 - y % 20;
        }
        for (int line = firstLine = y / 20; (double)line < (double)firstLine + bound.getHeight() / 20.0 && line <= this.model.totalLine(); ++line) {
            if (line == this.selectedLine) {
                this.paintInSelected(g2, x, y);
            } else {
                char[] chars = this.model.getLineChars(line);
                g2.drawChars(chars, 0, chars.length, x, y);
            }
            x = 20;
            y += 20;
        }
    }

    private void paintInSelected(Graphics g2, int x, int y) {
        g2.setFont(HexView.BOLD_FONT);
        char[] content = this.model.getLineChars(this.selectedLine);
        g2.drawChars(content, 0, this.selectedIndexInLine - 0, x, y);
        g2.setColor(HexView.SELECTED_COLOR);
        g2.drawChars(content, this.selectedIndexInLine, 1, x += g2.getFontMetrics().charsWidth(content, 0, this.selectedIndexInLine - 0), y);
        g2.setColor(Color.black);
        g2.drawChars(content, this.selectedIndexInLine + 1, content.length - 1 - this.selectedIndexInLine, x += g2.getFontMetrics().charWidth(content[this.selectedIndexInLine]), y);
        g2.setFont(HexView.FONT);
    }

    @Override
    public void hexModelChanged(HexModelChangedEvent event) {
        this.repaint();
    }

    void setSelected(int index) {
        this.selectedLine = HexModel.lineNumber(index);
        this.selectedIndexInLine = HexModel.elementIndexInLine(index);
        this.repaint();
    }
}

